/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1VolumeAttachmentStatus;
import io.kubernetes.client.openapi.models.V1VolumeError;
import io.kubernetes.client.openapi.models.V1VolumeErrorBuilder;
import io.kubernetes.client.openapi.models.V1VolumeErrorFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class V1VolumeAttachmentStatusFluent<A extends V1VolumeAttachmentStatusFluent<A>>
extends BaseFluent<A> {
    private V1VolumeErrorBuilder attachError;
    private Boolean attached;
    private Map<String, String> attachmentMetadata;
    private V1VolumeErrorBuilder detachError;

    public V1VolumeAttachmentStatusFluent() {
    }

    public V1VolumeAttachmentStatusFluent(V1VolumeAttachmentStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1VolumeAttachmentStatus instance) {
        V1VolumeAttachmentStatus v1VolumeAttachmentStatus = instance = instance != null ? instance : new V1VolumeAttachmentStatus();
        if (instance != null) {
            this.withAttachError(instance.getAttachError());
            this.withAttached(instance.getAttached());
            this.withAttachmentMetadata(instance.getAttachmentMetadata());
            this.withDetachError(instance.getDetachError());
        }
    }

    public V1VolumeError buildAttachError() {
        return this.attachError != null ? this.attachError.build() : null;
    }

    public A withAttachError(V1VolumeError attachError) {
        this._visitables.remove("attachError");
        if (attachError != null) {
            this.attachError = new V1VolumeErrorBuilder(attachError);
            this._visitables.get("attachError").add(this.attachError);
        } else {
            this.attachError = null;
            this._visitables.get("attachError").remove(this.attachError);
        }
        return (A)this;
    }

    public boolean hasAttachError() {
        return this.attachError != null;
    }

    public AttachErrorNested<A> withNewAttachError() {
        return new AttachErrorNested(null);
    }

    public AttachErrorNested<A> withNewAttachErrorLike(V1VolumeError item) {
        return new AttachErrorNested(item);
    }

    public AttachErrorNested<A> editAttachError() {
        return this.withNewAttachErrorLike(Optional.ofNullable(this.buildAttachError()).orElse(null));
    }

    public AttachErrorNested<A> editOrNewAttachError() {
        return this.withNewAttachErrorLike(Optional.ofNullable(this.buildAttachError()).orElse(new V1VolumeErrorBuilder().build()));
    }

    public AttachErrorNested<A> editOrNewAttachErrorLike(V1VolumeError item) {
        return this.withNewAttachErrorLike(Optional.ofNullable(this.buildAttachError()).orElse(item));
    }

    public Boolean getAttached() {
        return this.attached;
    }

    public A withAttached(Boolean attached) {
        this.attached = attached;
        return (A)this;
    }

    public boolean hasAttached() {
        return this.attached != null;
    }

    public A addToAttachmentMetadata(String key, String value) {
        if (this.attachmentMetadata == null && key != null && value != null) {
            this.attachmentMetadata = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.attachmentMetadata.put(key, value);
        }
        return (A)this;
    }

    public A addToAttachmentMetadata(Map<String, String> map) {
        if (this.attachmentMetadata == null && map != null) {
            this.attachmentMetadata = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.attachmentMetadata.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAttachmentMetadata(String key) {
        if (this.attachmentMetadata == null) {
            return (A)this;
        }
        if (key != null && this.attachmentMetadata != null) {
            this.attachmentMetadata.remove(key);
        }
        return (A)this;
    }

    public A removeFromAttachmentMetadata(Map<String, String> map) {
        if (this.attachmentMetadata == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.attachmentMetadata == null) continue;
                this.attachmentMetadata.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getAttachmentMetadata() {
        return this.attachmentMetadata;
    }

    public <K, V> A withAttachmentMetadata(Map<String, String> attachmentMetadata) {
        this.attachmentMetadata = attachmentMetadata == null ? null : new LinkedHashMap<String, String>(attachmentMetadata);
        return (A)this;
    }

    public boolean hasAttachmentMetadata() {
        return this.attachmentMetadata != null;
    }

    public V1VolumeError buildDetachError() {
        return this.detachError != null ? this.detachError.build() : null;
    }

    public A withDetachError(V1VolumeError detachError) {
        this._visitables.remove("detachError");
        if (detachError != null) {
            this.detachError = new V1VolumeErrorBuilder(detachError);
            this._visitables.get("detachError").add(this.detachError);
        } else {
            this.detachError = null;
            this._visitables.get("detachError").remove(this.detachError);
        }
        return (A)this;
    }

    public boolean hasDetachError() {
        return this.detachError != null;
    }

    public DetachErrorNested<A> withNewDetachError() {
        return new DetachErrorNested(null);
    }

    public DetachErrorNested<A> withNewDetachErrorLike(V1VolumeError item) {
        return new DetachErrorNested(item);
    }

    public DetachErrorNested<A> editDetachError() {
        return this.withNewDetachErrorLike(Optional.ofNullable(this.buildDetachError()).orElse(null));
    }

    public DetachErrorNested<A> editOrNewDetachError() {
        return this.withNewDetachErrorLike(Optional.ofNullable(this.buildDetachError()).orElse(new V1VolumeErrorBuilder().build()));
    }

    public DetachErrorNested<A> editOrNewDetachErrorLike(V1VolumeError item) {
        return this.withNewDetachErrorLike(Optional.ofNullable(this.buildDetachError()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1VolumeAttachmentStatusFluent that = (V1VolumeAttachmentStatusFluent)o;
        if (!Objects.equals(this.attachError, that.attachError)) {
            return false;
        }
        if (!Objects.equals(this.attached, that.attached)) {
            return false;
        }
        if (!Objects.equals(this.attachmentMetadata, that.attachmentMetadata)) {
            return false;
        }
        return Objects.equals(this.detachError, that.detachError);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attachError, this.attached, this.attachmentMetadata, this.detachError, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachError != null) {
            sb.append("attachError:");
            sb.append(String.valueOf(this.attachError) + ",");
        }
        if (this.attached != null) {
            sb.append("attached:");
            sb.append(this.attached + ",");
        }
        if (this.attachmentMetadata != null && !this.attachmentMetadata.isEmpty()) {
            sb.append("attachmentMetadata:");
            sb.append(String.valueOf(this.attachmentMetadata) + ",");
        }
        if (this.detachError != null) {
            sb.append("detachError:");
            sb.append(this.detachError);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAttached() {
        return this.withAttached(true);
    }

    public class AttachErrorNested<N>
    extends V1VolumeErrorFluent<AttachErrorNested<N>>
    implements Nested<N> {
        V1VolumeErrorBuilder builder;

        AttachErrorNested(V1VolumeError item) {
            this.builder = new V1VolumeErrorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1VolumeAttachmentStatusFluent.this.withAttachError(this.builder.build());
        }

        public N endAttachError() {
            return this.and();
        }
    }

    public class DetachErrorNested<N>
    extends V1VolumeErrorFluent<DetachErrorNested<N>>
    implements Nested<N> {
        V1VolumeErrorBuilder builder;

        DetachErrorNested(V1VolumeError item) {
            this.builder = new V1VolumeErrorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1VolumeAttachmentStatusFluent.this.withDetachError(this.builder.build());
        }

        public N endDetachError() {
            return this.and();
        }
    }
}

