/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.AdmissionregistrationV1WebhookClientConfig;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1MatchCondition;
import io.kubernetes.client.openapi.models.V1RuleWithOperations;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ValidatingWebhook describes an admission webhook and the resources and operations it applies to.")
public class V1ValidatingWebhook {
    public static final String SERIALIZED_NAME_ADMISSION_REVIEW_VERSIONS = "admissionReviewVersions";
    @SerializedName(value="admissionReviewVersions")
    @Nonnull
    private List<String> admissionReviewVersions = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CLIENT_CONFIG = "clientConfig";
    @SerializedName(value="clientConfig")
    @Nonnull
    private AdmissionregistrationV1WebhookClientConfig clientConfig;
    public static final String SERIALIZED_NAME_FAILURE_POLICY = "failurePolicy";
    @SerializedName(value="failurePolicy")
    @Nullable
    private String failurePolicy;
    public static final String SERIALIZED_NAME_MATCH_CONDITIONS = "matchConditions";
    @SerializedName(value="matchConditions")
    @Nullable
    private List<V1MatchCondition> matchConditions = new ArrayList<V1MatchCondition>();
    public static final String SERIALIZED_NAME_MATCH_POLICY = "matchPolicy";
    @SerializedName(value="matchPolicy")
    @Nullable
    private String matchPolicy;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_NAMESPACE_SELECTOR = "namespaceSelector";
    @SerializedName(value="namespaceSelector")
    @Nullable
    private V1LabelSelector namespaceSelector;
    public static final String SERIALIZED_NAME_OBJECT_SELECTOR = "objectSelector";
    @SerializedName(value="objectSelector")
    @Nullable
    private V1LabelSelector objectSelector;
    public static final String SERIALIZED_NAME_RULES = "rules";
    @SerializedName(value="rules")
    @Nullable
    private List<V1RuleWithOperations> rules = new ArrayList<V1RuleWithOperations>();
    public static final String SERIALIZED_NAME_SIDE_EFFECTS = "sideEffects";
    @SerializedName(value="sideEffects")
    @Nonnull
    private String sideEffects;
    public static final String SERIALIZED_NAME_TIMEOUT_SECONDS = "timeoutSeconds";
    @SerializedName(value="timeoutSeconds")
    @Nullable
    private Integer timeoutSeconds;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ValidatingWebhook admissionReviewVersions(@Nonnull List<String> admissionReviewVersions) {
        this.admissionReviewVersions = admissionReviewVersions;
        return this;
    }

    public V1ValidatingWebhook addAdmissionReviewVersionsItem(String admissionReviewVersionsItem) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        this.admissionReviewVersions.add(admissionReviewVersionsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy.")
    public List<String> getAdmissionReviewVersions() {
        return this.admissionReviewVersions;
    }

    public void setAdmissionReviewVersions(@Nonnull List<String> admissionReviewVersions) {
        this.admissionReviewVersions = admissionReviewVersions;
    }

    public V1ValidatingWebhook clientConfig(@Nonnull AdmissionregistrationV1WebhookClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public AdmissionregistrationV1WebhookClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(@Nonnull AdmissionregistrationV1WebhookClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public V1ValidatingWebhook failurePolicy(@Nullable String failurePolicy) {
        this.failurePolicy = failurePolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Fail.")
    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    public void setFailurePolicy(@Nullable String failurePolicy) {
        this.failurePolicy = failurePolicy;
    }

    public V1ValidatingWebhook matchConditions(@Nullable List<V1MatchCondition> matchConditions) {
        this.matchConditions = matchConditions;
        return this;
    }

    public V1ValidatingWebhook addMatchConditionsItem(V1MatchCondition matchConditionsItem) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList<V1MatchCondition>();
        }
        this.matchConditions.add(matchConditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MatchConditions is a list of conditions that must be met for a request to be sent to this webhook. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.  The exact matching logic is (in order):   1. If ANY matchCondition evaluates to FALSE, the webhook is skipped.   2. If ALL matchConditions evaluate to TRUE, the webhook is called.   3. If any matchCondition evaluates to an error (but none are FALSE):      - If failurePolicy=Fail, reject the request      - If failurePolicy=Ignore, the error is ignored and the webhook is skipped")
    public List<V1MatchCondition> getMatchConditions() {
        return this.matchConditions;
    }

    public void setMatchConditions(@Nullable List<V1MatchCondition> matchConditions) {
        this.matchConditions = matchConditions;
    }

    public V1ValidatingWebhook matchPolicy(@Nullable String matchPolicy) {
        this.matchPolicy = matchPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="matchPolicy defines how the \"rules\" list is used to match incoming requests. Allowed values are \"Exact\" or \"Equivalent\".  - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.  - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.  Defaults to \"Equivalent\"")
    public String getMatchPolicy() {
        return this.matchPolicy;
    }

    public void setMatchPolicy(@Nullable String matchPolicy) {
        this.matchPolicy = matchPolicy;
    }

    public V1ValidatingWebhook name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where \"imagepolicy\" is the name of the webhook, and kubernetes.io is the name of the organization. Required.")
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public V1ValidatingWebhook namespaceSelector(@Nullable V1LabelSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getNamespaceSelector() {
        return this.namespaceSelector;
    }

    public void setNamespaceSelector(@Nullable V1LabelSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
    }

    public V1ValidatingWebhook objectSelector(@Nullable V1LabelSelector objectSelector) {
        this.objectSelector = objectSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getObjectSelector() {
        return this.objectSelector;
    }

    public void setObjectSelector(@Nullable V1LabelSelector objectSelector) {
        this.objectSelector = objectSelector;
    }

    public V1ValidatingWebhook rules(@Nullable List<V1RuleWithOperations> rules) {
        this.rules = rules;
        return this;
    }

    public V1ValidatingWebhook addRulesItem(V1RuleWithOperations rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1RuleWithOperations>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.")
    public List<V1RuleWithOperations> getRules() {
        return this.rules;
    }

    public void setRules(@Nullable List<V1RuleWithOperations> rules) {
        this.rules = rules;
    }

    public V1ValidatingWebhook sideEffects(@Nonnull String sideEffects) {
        this.sideEffects = sideEffects;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="SideEffects states whether this webhook has side effects. Acceptable values are: None, NoneOnDryRun (webhooks created via v1beta1 may also specify Some or Unknown). Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission chain and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some.")
    public String getSideEffects() {
        return this.sideEffects;
    }

    public void setSideEffects(@Nonnull String sideEffects) {
        this.sideEffects = sideEffects;
    }

    public V1ValidatingWebhook timeoutSeconds(@Nullable Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 10 seconds.")
    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(@Nullable Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ValidatingWebhook v1ValidatingWebhook = (V1ValidatingWebhook)o;
        return Objects.equals(this.admissionReviewVersions, v1ValidatingWebhook.admissionReviewVersions) && Objects.equals(this.clientConfig, v1ValidatingWebhook.clientConfig) && Objects.equals(this.failurePolicy, v1ValidatingWebhook.failurePolicy) && Objects.equals(this.matchConditions, v1ValidatingWebhook.matchConditions) && Objects.equals(this.matchPolicy, v1ValidatingWebhook.matchPolicy) && Objects.equals(this.name, v1ValidatingWebhook.name) && Objects.equals(this.namespaceSelector, v1ValidatingWebhook.namespaceSelector) && Objects.equals(this.objectSelector, v1ValidatingWebhook.objectSelector) && Objects.equals(this.rules, v1ValidatingWebhook.rules) && Objects.equals(this.sideEffects, v1ValidatingWebhook.sideEffects) && Objects.equals(this.timeoutSeconds, v1ValidatingWebhook.timeoutSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.admissionReviewVersions, this.clientConfig, this.failurePolicy, this.matchConditions, this.matchPolicy, this.name, this.namespaceSelector, this.objectSelector, this.rules, this.sideEffects, this.timeoutSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ValidatingWebhook {\n");
        sb.append("    admissionReviewVersions: ").append(this.toIndentedString(this.admissionReviewVersions)).append("\n");
        sb.append("    clientConfig: ").append(this.toIndentedString(this.clientConfig)).append("\n");
        sb.append("    failurePolicy: ").append(this.toIndentedString(this.failurePolicy)).append("\n");
        sb.append("    matchConditions: ").append(this.toIndentedString(this.matchConditions)).append("\n");
        sb.append("    matchPolicy: ").append(this.toIndentedString(this.matchPolicy)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespaceSelector: ").append(this.toIndentedString(this.namespaceSelector)).append("\n");
        sb.append("    objectSelector: ").append(this.toIndentedString(this.objectSelector)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("    sideEffects: ").append(this.toIndentedString(this.sideEffects)).append("\n");
        sb.append("    timeoutSeconds: ").append(this.toIndentedString(this.timeoutSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayrules;
        int i;
        JsonArray jsonArraymatchConditions;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ValidatingWebhook is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ValidatingWebhook` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ADMISSION_REVIEW_VERSIONS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_ADMISSION_REVIEW_VERSIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `admissionReviewVersions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADMISSION_REVIEW_VERSIONS).toString()));
        }
        AdmissionregistrationV1WebhookClientConfig.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CLIENT_CONFIG));
        if (jsonObj.get(SERIALIZED_NAME_FAILURE_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_FAILURE_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FAILURE_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `failurePolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FAILURE_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MATCH_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_MATCH_CONDITIONS).isJsonNull() && (jsonArraymatchConditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_MATCH_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MATCH_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `matchConditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MATCH_CONDITIONS).toString()));
            }
            for (i = 0; i < jsonArraymatchConditions.size(); ++i) {
                V1MatchCondition.validateJsonElement(jsonArraymatchConditions.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_MATCH_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_MATCH_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MATCH_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `matchPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MATCH_POLICY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE_SELECTOR).isJsonNull()) {
            V1LabelSelector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NAMESPACE_SELECTOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_OBJECT_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_OBJECT_SELECTOR).isJsonNull()) {
            V1LabelSelector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_OBJECT_SELECTOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_RULES) != null && !jsonObj.get(SERIALIZED_NAME_RULES).isJsonNull() && (jsonArrayrules = jsonObj.getAsJsonArray(SERIALIZED_NAME_RULES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RULES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `rules` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RULES).toString()));
            }
            for (i = 0; i < jsonArrayrules.size(); ++i) {
                V1RuleWithOperations.validateJsonElement(jsonArrayrules.get(i));
            }
        }
        if (!jsonObj.get(SERIALIZED_NAME_SIDE_EFFECTS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sideEffects` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SIDE_EFFECTS).toString()));
        }
    }

    public static V1ValidatingWebhook fromJson(String jsonString) throws IOException {
        return (V1ValidatingWebhook)JSON.getGson().fromJson(jsonString, V1ValidatingWebhook.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADMISSION_REVIEW_VERSIONS);
        openapiFields.add(SERIALIZED_NAME_CLIENT_CONFIG);
        openapiFields.add(SERIALIZED_NAME_FAILURE_POLICY);
        openapiFields.add(SERIALIZED_NAME_MATCH_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_MATCH_POLICY);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_OBJECT_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_RULES);
        openapiFields.add(SERIALIZED_NAME_SIDE_EFFECTS);
        openapiFields.add(SERIALIZED_NAME_TIMEOUT_SECONDS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ADMISSION_REVIEW_VERSIONS);
        openapiRequiredFields.add(SERIALIZED_NAME_CLIENT_CONFIG);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_SIDE_EFFECTS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ValidatingWebhook.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ValidatingWebhook.class));
            return new TypeAdapter<V1ValidatingWebhook>(){

                public void write(JsonWriter out, V1ValidatingWebhook value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ValidatingWebhook read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ValidatingWebhook.validateJsonElement(jsonElement);
                    return (V1ValidatingWebhook)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

