/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.RbacV1Subject;
import io.kubernetes.client.openapi.models.RbacV1SubjectBuilder;
import io.kubernetes.client.openapi.models.RbacV1SubjectFluent;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import io.kubernetes.client.openapi.models.V1RoleBinding;
import io.kubernetes.client.openapi.models.V1RoleRef;
import io.kubernetes.client.openapi.models.V1RoleRefBuilder;
import io.kubernetes.client.openapi.models.V1RoleRefFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1RoleBindingFluent<A extends V1RoleBindingFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1RoleRefBuilder roleRef;
    private ArrayList<RbacV1SubjectBuilder> subjects;

    public V1RoleBindingFluent() {
    }

    public V1RoleBindingFluent(V1RoleBinding instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1RoleBinding instance) {
        V1RoleBinding v1RoleBinding = instance = instance != null ? instance : new V1RoleBinding();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRoleRef(instance.getRoleRef());
            this.withSubjects(instance.getSubjects());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public V1RoleRef buildRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    public A withRoleRef(V1RoleRef roleRef) {
        this._visitables.remove("roleRef");
        if (roleRef != null) {
            this.roleRef = new V1RoleRefBuilder(roleRef);
            this._visitables.get("roleRef").add(this.roleRef);
        } else {
            this.roleRef = null;
            this._visitables.get("roleRef").remove(this.roleRef);
        }
        return (A)this;
    }

    public boolean hasRoleRef() {
        return this.roleRef != null;
    }

    public RoleRefNested<A> withNewRoleRef() {
        return new RoleRefNested(null);
    }

    public RoleRefNested<A> withNewRoleRefLike(V1RoleRef item) {
        return new RoleRefNested(item);
    }

    public RoleRefNested<A> editRoleRef() {
        return this.withNewRoleRefLike(Optional.ofNullable(this.buildRoleRef()).orElse(null));
    }

    public RoleRefNested<A> editOrNewRoleRef() {
        return this.withNewRoleRefLike(Optional.ofNullable(this.buildRoleRef()).orElse(new V1RoleRefBuilder().build()));
    }

    public RoleRefNested<A> editOrNewRoleRefLike(V1RoleRef item) {
        return this.withNewRoleRefLike(Optional.ofNullable(this.buildRoleRef()).orElse(item));
    }

    public A addToSubjects(int index, RbacV1Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        RbacV1SubjectBuilder builder = new RbacV1SubjectBuilder(item);
        if (index < 0 || index >= this.subjects.size()) {
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        } else {
            this._visitables.get("subjects").add(builder);
            this.subjects.add(index, builder);
        }
        return (A)this;
    }

    public A setToSubjects(int index, RbacV1Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        RbacV1SubjectBuilder builder = new RbacV1SubjectBuilder(item);
        if (index < 0 || index >= this.subjects.size()) {
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        } else {
            this._visitables.get("subjects").add(builder);
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    public A addToSubjects(RbacV1Subject ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (RbacV1Subject item : items) {
            RbacV1SubjectBuilder builder = new RbacV1SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    public A addAllToSubjects(Collection<RbacV1Subject> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (RbacV1Subject item : items) {
            RbacV1SubjectBuilder builder = new RbacV1SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    public A removeFromSubjects(RbacV1Subject ... items) {
        if (this.subjects == null) {
            return (A)this;
        }
        for (RbacV1Subject item : items) {
            RbacV1SubjectBuilder builder = new RbacV1SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSubjects(Collection<RbacV1Subject> items) {
        if (this.subjects == null) {
            return (A)this;
        }
        for (RbacV1Subject item : items) {
            RbacV1SubjectBuilder builder = new RbacV1SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSubjects(Predicate<RbacV1SubjectBuilder> predicate) {
        if (this.subjects == null) {
            return (A)this;
        }
        Iterator<RbacV1SubjectBuilder> each = this.subjects.iterator();
        Object visitables = this._visitables.get("subjects");
        while (each.hasNext()) {
            RbacV1SubjectBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<RbacV1Subject> buildSubjects() {
        return this.subjects != null ? V1RoleBindingFluent.build(this.subjects) : null;
    }

    public RbacV1Subject buildSubject(int index) {
        return this.subjects.get(index).build();
    }

    public RbacV1Subject buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    public RbacV1Subject buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    public RbacV1Subject buildMatchingSubject(Predicate<RbacV1SubjectBuilder> predicate) {
        for (RbacV1SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSubject(Predicate<RbacV1SubjectBuilder> predicate) {
        for (RbacV1SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubjects(List<RbacV1Subject> subjects) {
        if (this.subjects != null) {
            this._visitables.get("subjects").clear();
        }
        if (subjects != null) {
            this.subjects = new ArrayList();
            for (RbacV1Subject item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)this;
    }

    public A withSubjects(RbacV1Subject ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
            this._visitables.remove("subjects");
        }
        if (subjects != null) {
            for (RbacV1Subject item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    public boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    public SubjectsNested<A> addNewSubject() {
        return new SubjectsNested(-1, null);
    }

    public SubjectsNested<A> addNewSubjectLike(RbacV1Subject item) {
        return new SubjectsNested(-1, item);
    }

    public SubjectsNested<A> setNewSubjectLike(int index, RbacV1Subject item) {
        return new SubjectsNested(index, item);
    }

    public SubjectsNested<A> editSubject(int index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    public SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public SubjectsNested<A> editMatchingSubject(Predicate<RbacV1SubjectBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.test(this.subjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1RoleBindingFluent that = (V1RoleBindingFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.roleRef, that.roleRef)) {
            return false;
        }
        return Objects.equals(this.subjects, that.subjects);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.roleRef, this.subjects, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(String.valueOf(this.metadata) + ",");
        }
        if (this.roleRef != null) {
            sb.append("roleRef:");
            sb.append(String.valueOf(this.roleRef) + ",");
        }
        if (this.subjects != null && !this.subjects.isEmpty()) {
            sb.append("subjects:");
            sb.append(this.subjects);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1RoleBindingFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class RoleRefNested<N>
    extends V1RoleRefFluent<RoleRefNested<N>>
    implements Nested<N> {
        V1RoleRefBuilder builder;

        RoleRefNested(V1RoleRef item) {
            this.builder = new V1RoleRefBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1RoleBindingFluent.this.withRoleRef(this.builder.build());
        }

        public N endRoleRef() {
            return this.and();
        }
    }

    public class SubjectsNested<N>
    extends RbacV1SubjectFluent<SubjectsNested<N>>
    implements Nested<N> {
        RbacV1SubjectBuilder builder;
        int index;

        SubjectsNested(int index, RbacV1Subject item) {
            this.index = index;
            this.builder = new RbacV1SubjectBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1RoleBindingFluent.this.setToSubjects(this.index, this.builder.build());
        }

        public N endSubject() {
            return this.and();
        }
    }
}

