/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ScopeSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ResourceQuotaSpec defines the desired hard limits to enforce for Quota.")
public class V1ResourceQuotaSpec {
    public static final String SERIALIZED_NAME_HARD = "hard";
    @SerializedName(value="hard")
    @Nullable
    private Map<String, Quantity> hard = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_SCOPE_SELECTOR = "scopeSelector";
    @SerializedName(value="scopeSelector")
    @Nullable
    private V1ScopeSelector scopeSelector;
    public static final String SERIALIZED_NAME_SCOPES = "scopes";
    @SerializedName(value="scopes")
    @Nullable
    private List<String> scopes = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ResourceQuotaSpec hard(@Nullable Map<String, Quantity> hard) {
        this.hard = hard;
        return this;
    }

    public V1ResourceQuotaSpec putHardItem(String key, Quantity hardItem) {
        if (this.hard == null) {
            this.hard = new HashMap<String, Quantity>();
        }
        this.hard.put(key, hardItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="hard is the set of desired hard limits for each named resource. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/")
    public Map<String, Quantity> getHard() {
        return this.hard;
    }

    public void setHard(@Nullable Map<String, Quantity> hard) {
        this.hard = hard;
    }

    public V1ResourceQuotaSpec scopeSelector(@Nullable V1ScopeSelector scopeSelector) {
        this.scopeSelector = scopeSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ScopeSelector getScopeSelector() {
        return this.scopeSelector;
    }

    public void setScopeSelector(@Nullable V1ScopeSelector scopeSelector) {
        this.scopeSelector = scopeSelector;
    }

    public V1ResourceQuotaSpec scopes(@Nullable List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public V1ResourceQuotaSpec addScopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A collection of filters that must match each object tracked by a quota. If not specified, the quota matches all objects.")
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(@Nullable List<String> scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceQuotaSpec v1ResourceQuotaSpec = (V1ResourceQuotaSpec)o;
        return Objects.equals(this.hard, v1ResourceQuotaSpec.hard) && Objects.equals(this.scopeSelector, v1ResourceQuotaSpec.scopeSelector) && Objects.equals(this.scopes, v1ResourceQuotaSpec.scopes);
    }

    public int hashCode() {
        return Objects.hash(this.hard, this.scopeSelector, this.scopes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceQuotaSpec {\n");
        sb.append("    hard: ").append(this.toIndentedString(this.hard)).append("\n");
        sb.append("    scopeSelector: ").append(this.toIndentedString(this.scopeSelector)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ResourceQuotaSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ResourceQuotaSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_SCOPE_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_SCOPE_SELECTOR).isJsonNull()) {
            V1ScopeSelector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SCOPE_SELECTOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCOPES) != null && !jsonObj.get(SERIALIZED_NAME_SCOPES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SCOPES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `scopes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCOPES).toString()));
        }
    }

    public static V1ResourceQuotaSpec fromJson(String jsonString) throws IOException {
        return (V1ResourceQuotaSpec)JSON.getGson().fromJson(jsonString, V1ResourceQuotaSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_HARD);
        openapiFields.add(SERIALIZED_NAME_SCOPE_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_SCOPES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ResourceQuotaSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ResourceQuotaSpec.class));
            return new TypeAdapter<V1ResourceQuotaSpec>(){

                public void write(JsonWriter out, V1ResourceQuotaSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ResourceQuotaSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ResourceQuotaSpec.validateJsonElement(jsonElement);
                    return (V1ResourceQuotaSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

