/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ReplicationControllerSpec is the specification of a replication controller.")
public class V1ReplicationControllerSpec {
    public static final String SERIALIZED_NAME_MIN_READY_SECONDS = "minReadySeconds";
    @SerializedName(value="minReadySeconds")
    @Nullable
    private Integer minReadySeconds;
    public static final String SERIALIZED_NAME_REPLICAS = "replicas";
    @SerializedName(value="replicas")
    @Nullable
    private Integer replicas;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    @Nullable
    private Map<String, String> selector = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_TEMPLATE = "template";
    @SerializedName(value="template")
    @Nullable
    private V1PodTemplateSpec template;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ReplicationControllerSpec minReadySeconds(@Nullable Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)")
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public void setMinReadySeconds(@Nullable Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
    }

    public V1ReplicationControllerSpec replicas(@Nullable Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(@Nullable Integer replicas) {
        this.replicas = replicas;
    }

    public V1ReplicationControllerSpec selector(@Nullable Map<String, String> selector) {
        this.selector = selector;
        return this;
    }

    public V1ReplicationControllerSpec putSelectorItem(String key, String selectorItem) {
        if (this.selector == null) {
            this.selector = new HashMap<String, String>();
        }
        this.selector.put(key, selectorItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Selector is a label query over pods that should match the Replicas count. If Selector is empty, it is defaulted to the labels present on the Pod template. Label keys and values that must match in order to be controlled by this replication controller, if empty defaulted to labels on Pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors")
    public Map<String, String> getSelector() {
        return this.selector;
    }

    public void setSelector(@Nullable Map<String, String> selector) {
        this.selector = selector;
    }

    public V1ReplicationControllerSpec template(@Nullable V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(@Nullable V1PodTemplateSpec template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ReplicationControllerSpec v1ReplicationControllerSpec = (V1ReplicationControllerSpec)o;
        return Objects.equals(this.minReadySeconds, v1ReplicationControllerSpec.minReadySeconds) && Objects.equals(this.replicas, v1ReplicationControllerSpec.replicas) && Objects.equals(this.selector, v1ReplicationControllerSpec.selector) && Objects.equals(this.template, v1ReplicationControllerSpec.template);
    }

    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.replicas, this.selector, this.template);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ReplicationControllerSpec {\n");
        sb.append("    minReadySeconds: ").append(this.toIndentedString(this.minReadySeconds)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ReplicationControllerSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ReplicationControllerSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_TEMPLATE) != null && !jsonObj.get(SERIALIZED_NAME_TEMPLATE).isJsonNull()) {
            V1PodTemplateSpec.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TEMPLATE));
        }
    }

    public static V1ReplicationControllerSpec fromJson(String jsonString) throws IOException {
        return (V1ReplicationControllerSpec)JSON.getGson().fromJson(jsonString, V1ReplicationControllerSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MIN_READY_SECONDS);
        openapiFields.add(SERIALIZED_NAME_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_TEMPLATE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ReplicationControllerSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ReplicationControllerSpec.class));
            return new TypeAdapter<V1ReplicationControllerSpec>(){

                public void write(JsonWriter out, V1ReplicationControllerSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ReplicationControllerSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ReplicationControllerSpec.validateJsonElement(jsonElement);
                    return (V1ReplicationControllerSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

