/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ListMeta;
import io.kubernetes.client.openapi.models.V1ListMetaBuilder;
import io.kubernetes.client.openapi.models.V1ListMetaFluent;
import io.kubernetes.client.openapi.models.V1PriorityClass;
import io.kubernetes.client.openapi.models.V1PriorityClassBuilder;
import io.kubernetes.client.openapi.models.V1PriorityClassFluent;
import io.kubernetes.client.openapi.models.V1PriorityClassList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1PriorityClassListFluent<A extends V1PriorityClassListFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private ArrayList<V1PriorityClassBuilder> items;
    private String kind;
    private V1ListMetaBuilder metadata;

    public V1PriorityClassListFluent() {
    }

    public V1PriorityClassListFluent(V1PriorityClassList instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1PriorityClassList instance) {
        V1PriorityClassList v1PriorityClassList = instance = instance != null ? instance : new V1PriorityClassList();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withItems(instance.getItems());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToItems(int index, V1PriorityClass item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        V1PriorityClassBuilder builder = new V1PriorityClassBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").add(builder);
            this.items.add(index, builder);
        }
        return (A)this;
    }

    public A setToItems(int index, V1PriorityClass item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        V1PriorityClassBuilder builder = new V1PriorityClassBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").add(builder);
            this.items.set(index, builder);
        }
        return (A)this;
    }

    public A addToItems(V1PriorityClass ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (V1PriorityClass item : items) {
            V1PriorityClassBuilder builder = new V1PriorityClassBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    public A addAllToItems(Collection<V1PriorityClass> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (V1PriorityClass item : items) {
            V1PriorityClassBuilder builder = new V1PriorityClassBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    public A removeFromItems(V1PriorityClass ... items) {
        if (this.items == null) {
            return (A)this;
        }
        for (V1PriorityClass item : items) {
            V1PriorityClassBuilder builder = new V1PriorityClassBuilder(item);
            this._visitables.get("items").remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromItems(Collection<V1PriorityClass> items) {
        if (this.items == null) {
            return (A)this;
        }
        for (V1PriorityClass item : items) {
            V1PriorityClassBuilder builder = new V1PriorityClassBuilder(item);
            this._visitables.get("items").remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromItems(Predicate<V1PriorityClassBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<V1PriorityClassBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            V1PriorityClassBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1PriorityClass> buildItems() {
        return this.items != null ? V1PriorityClassListFluent.build(this.items) : null;
    }

    public V1PriorityClass buildItem(int index) {
        return this.items.get(index).build();
    }

    public V1PriorityClass buildFirstItem() {
        return this.items.get(0).build();
    }

    public V1PriorityClass buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    public V1PriorityClass buildMatchingItem(Predicate<V1PriorityClassBuilder> predicate) {
        for (V1PriorityClassBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingItem(Predicate<V1PriorityClassBuilder> predicate) {
        for (V1PriorityClassBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withItems(List<V1PriorityClass> items) {
        if (this.items != null) {
            this._visitables.get("items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (V1PriorityClass item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    public A withItems(V1PriorityClass ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove("items");
        }
        if (items != null) {
            for (V1PriorityClass item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public ItemsNested<A> addNewItem() {
        return new ItemsNested(-1, null);
    }

    public ItemsNested<A> addNewItemLike(V1PriorityClass item) {
        return new ItemsNested(-1, item);
    }

    public ItemsNested<A> setNewItemLike(int index, V1PriorityClass item) {
        return new ItemsNested(index, item);
    }

    public ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    public ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editMatchingItem(Predicate<V1PriorityClassBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ListMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ListMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ListMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ListMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ListMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PriorityClassListFluent that = (V1PriorityClassListFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.metadata, that.metadata);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(String.valueOf(this.items) + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ItemsNested<N>
    extends V1PriorityClassFluent<ItemsNested<N>>
    implements Nested<N> {
        V1PriorityClassBuilder builder;
        int index;

        ItemsNested(int index, V1PriorityClass item) {
            this.index = index;
            this.builder = new V1PriorityClassBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PriorityClassListFluent.this.setToItems(this.index, this.builder.build());
        }

        public N endItem() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends V1ListMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ListMetaBuilder builder;

        MetadataNested(V1ListMeta item) {
            this.builder = new V1ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PriorityClassListFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

