/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1AppArmorProfile;
import io.kubernetes.client.openapi.models.V1SELinuxOptions;
import io.kubernetes.client.openapi.models.V1SeccompProfile;
import io.kubernetes.client.openapi.models.V1Sysctl;
import io.kubernetes.client.openapi.models.V1WindowsSecurityContextOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PodSecurityContext holds pod-level security attributes and common container settings. Some fields are also present in container.securityContext.  Field values of container.securityContext take precedence over field values of PodSecurityContext.")
public class V1PodSecurityContext {
    public static final String SERIALIZED_NAME_APP_ARMOR_PROFILE = "appArmorProfile";
    @SerializedName(value="appArmorProfile")
    @Nullable
    private V1AppArmorProfile appArmorProfile;
    public static final String SERIALIZED_NAME_FS_GROUP = "fsGroup";
    @SerializedName(value="fsGroup")
    @Nullable
    private Long fsGroup;
    public static final String SERIALIZED_NAME_FS_GROUP_CHANGE_POLICY = "fsGroupChangePolicy";
    @SerializedName(value="fsGroupChangePolicy")
    @Nullable
    private String fsGroupChangePolicy;
    public static final String SERIALIZED_NAME_RUN_AS_GROUP = "runAsGroup";
    @SerializedName(value="runAsGroup")
    @Nullable
    private Long runAsGroup;
    public static final String SERIALIZED_NAME_RUN_AS_NON_ROOT = "runAsNonRoot";
    @SerializedName(value="runAsNonRoot")
    @Nullable
    private Boolean runAsNonRoot;
    public static final String SERIALIZED_NAME_RUN_AS_USER = "runAsUser";
    @SerializedName(value="runAsUser")
    @Nullable
    private Long runAsUser;
    public static final String SERIALIZED_NAME_SE_LINUX_CHANGE_POLICY = "seLinuxChangePolicy";
    @SerializedName(value="seLinuxChangePolicy")
    @Nullable
    private String seLinuxChangePolicy;
    public static final String SERIALIZED_NAME_SE_LINUX_OPTIONS = "seLinuxOptions";
    @SerializedName(value="seLinuxOptions")
    @Nullable
    private V1SELinuxOptions seLinuxOptions;
    public static final String SERIALIZED_NAME_SECCOMP_PROFILE = "seccompProfile";
    @SerializedName(value="seccompProfile")
    @Nullable
    private V1SeccompProfile seccompProfile;
    public static final String SERIALIZED_NAME_SUPPLEMENTAL_GROUPS = "supplementalGroups";
    @SerializedName(value="supplementalGroups")
    @Nullable
    private List<Long> supplementalGroups = new ArrayList<Long>();
    public static final String SERIALIZED_NAME_SUPPLEMENTAL_GROUPS_POLICY = "supplementalGroupsPolicy";
    @SerializedName(value="supplementalGroupsPolicy")
    @Nullable
    private String supplementalGroupsPolicy;
    public static final String SERIALIZED_NAME_SYSCTLS = "sysctls";
    @SerializedName(value="sysctls")
    @Nullable
    private List<V1Sysctl> sysctls = new ArrayList<V1Sysctl>();
    public static final String SERIALIZED_NAME_WINDOWS_OPTIONS = "windowsOptions";
    @SerializedName(value="windowsOptions")
    @Nullable
    private V1WindowsSecurityContextOptions windowsOptions;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PodSecurityContext appArmorProfile(@Nullable V1AppArmorProfile appArmorProfile) {
        this.appArmorProfile = appArmorProfile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1AppArmorProfile getAppArmorProfile() {
        return this.appArmorProfile;
    }

    public void setAppArmorProfile(@Nullable V1AppArmorProfile appArmorProfile) {
        this.appArmorProfile = appArmorProfile;
    }

    public V1PodSecurityContext fsGroup(@Nullable Long fsGroup) {
        this.fsGroup = fsGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:  1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----  If unset, the Kubelet will not modify the ownership and permissions of any volume. Note that this field cannot be set when spec.os.name is windows.")
    public Long getFsGroup() {
        return this.fsGroup;
    }

    public void setFsGroup(@Nullable Long fsGroup) {
        this.fsGroup = fsGroup;
    }

    public V1PodSecurityContext fsGroupChangePolicy(@Nullable String fsGroupChangePolicy) {
        this.fsGroupChangePolicy = fsGroupChangePolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Valid values are \"OnRootMismatch\" and \"Always\". If not specified, \"Always\" is used. Note that this field cannot be set when spec.os.name is windows.")
    public String getFsGroupChangePolicy() {
        return this.fsGroupChangePolicy;
    }

    public void setFsGroupChangePolicy(@Nullable String fsGroupChangePolicy) {
        this.fsGroupChangePolicy = fsGroupChangePolicy;
    }

    public V1PodSecurityContext runAsGroup(@Nullable Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container. Note that this field cannot be set when spec.os.name is windows.")
    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public void setRunAsGroup(@Nullable Long runAsGroup) {
        this.runAsGroup = runAsGroup;
    }

    public V1PodSecurityContext runAsNonRoot(@Nullable Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.")
    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public void setRunAsNonRoot(@Nullable Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
    }

    public V1PodSecurityContext runAsUser(@Nullable Long runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container. Note that this field cannot be set when spec.os.name is windows.")
    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(@Nullable Long runAsUser) {
        this.runAsUser = runAsUser;
    }

    public V1PodSecurityContext seLinuxChangePolicy(@Nullable String seLinuxChangePolicy) {
        this.seLinuxChangePolicy = seLinuxChangePolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="seLinuxChangePolicy defines how the container's SELinux label is applied to all volumes used by the Pod. It has no effect on nodes that do not support SELinux or to volumes does not support SELinux. Valid values are \"MountOption\" and \"Recursive\".  \"Recursive\" means relabeling of all files on all Pod volumes by the container runtime. This may be slow for large volumes, but allows mixing privileged and unprivileged Pods sharing the same volume on the same node.  \"MountOption\" mounts all eligible Pod volumes with `-o context` mount option. This requires all Pods that share the same volume to use the same SELinux label. It is not possible to share the same volume among privileged and unprivileged Pods. Eligible volumes are in-tree FibreChannel and iSCSI volumes, and all CSI volumes whose CSI driver announces SELinux support by setting spec.seLinuxMount: true in their CSIDriver instance. Other volumes are always re-labelled recursively. \"MountOption\" value is allowed only when SELinuxMount feature gate is enabled.  If not specified and SELinuxMount feature gate is enabled, \"MountOption\" is used. If not specified and SELinuxMount feature gate is disabled, \"MountOption\" is used for ReadWriteOncePod volumes and \"Recursive\" for all other volumes.  This field affects only Pods that have SELinux label set, either in PodSecurityContext or in SecurityContext of all containers.  All Pods that use the same volume should use the same seLinuxChangePolicy, otherwise some pods can get stuck in ContainerCreating state. Note that this field cannot be set when spec.os.name is windows.")
    public String getSeLinuxChangePolicy() {
        return this.seLinuxChangePolicy;
    }

    public void setSeLinuxChangePolicy(@Nullable String seLinuxChangePolicy) {
        this.seLinuxChangePolicy = seLinuxChangePolicy;
    }

    public V1PodSecurityContext seLinuxOptions(@Nullable V1SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions;
    }

    public void setSeLinuxOptions(@Nullable V1SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
    }

    public V1PodSecurityContext seccompProfile(@Nullable V1SeccompProfile seccompProfile) {
        this.seccompProfile = seccompProfile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SeccompProfile getSeccompProfile() {
        return this.seccompProfile;
    }

    public void setSeccompProfile(@Nullable V1SeccompProfile seccompProfile) {
        this.seccompProfile = seccompProfile;
    }

    public V1PodSecurityContext supplementalGroups(@Nullable List<Long> supplementalGroups) {
        this.supplementalGroups = supplementalGroups;
        return this;
    }

    public V1PodSecurityContext addSupplementalGroupsItem(Long supplementalGroupsItem) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.add(supplementalGroupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of groups applied to the first process run in each container, in addition to the container's primary GID and fsGroup (if specified).  If the SupplementalGroupsPolicy feature is enabled, the supplementalGroupsPolicy field determines whether these are in addition to or instead of any group memberships defined in the container image. If unspecified, no additional groups are added, though group memberships defined in the container image may still be used, depending on the supplementalGroupsPolicy field. Note that this field cannot be set when spec.os.name is windows.")
    public List<Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    public void setSupplementalGroups(@Nullable List<Long> supplementalGroups) {
        this.supplementalGroups = supplementalGroups;
    }

    public V1PodSecurityContext supplementalGroupsPolicy(@Nullable String supplementalGroupsPolicy) {
        this.supplementalGroupsPolicy = supplementalGroupsPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defines how supplemental groups of the first container processes are calculated. Valid values are \"Merge\" and \"Strict\". If not specified, \"Merge\" is used. (Alpha) Using the field requires the SupplementalGroupsPolicy feature gate to be enabled and the container runtime must implement support for this feature. Note that this field cannot be set when spec.os.name is windows.")
    public String getSupplementalGroupsPolicy() {
        return this.supplementalGroupsPolicy;
    }

    public void setSupplementalGroupsPolicy(@Nullable String supplementalGroupsPolicy) {
        this.supplementalGroupsPolicy = supplementalGroupsPolicy;
    }

    public V1PodSecurityContext sysctls(@Nullable List<V1Sysctl> sysctls) {
        this.sysctls = sysctls;
        return this;
    }

    public V1PodSecurityContext addSysctlsItem(V1Sysctl sysctlsItem) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList<V1Sysctl>();
        }
        this.sysctls.add(sysctlsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. Note that this field cannot be set when spec.os.name is windows.")
    public List<V1Sysctl> getSysctls() {
        return this.sysctls;
    }

    public void setSysctls(@Nullable List<V1Sysctl> sysctls) {
        this.sysctls = sysctls;
    }

    public V1PodSecurityContext windowsOptions(@Nullable V1WindowsSecurityContextOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1WindowsSecurityContextOptions getWindowsOptions() {
        return this.windowsOptions;
    }

    public void setWindowsOptions(@Nullable V1WindowsSecurityContextOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodSecurityContext v1PodSecurityContext = (V1PodSecurityContext)o;
        return Objects.equals(this.appArmorProfile, v1PodSecurityContext.appArmorProfile) && Objects.equals(this.fsGroup, v1PodSecurityContext.fsGroup) && Objects.equals(this.fsGroupChangePolicy, v1PodSecurityContext.fsGroupChangePolicy) && Objects.equals(this.runAsGroup, v1PodSecurityContext.runAsGroup) && Objects.equals(this.runAsNonRoot, v1PodSecurityContext.runAsNonRoot) && Objects.equals(this.runAsUser, v1PodSecurityContext.runAsUser) && Objects.equals(this.seLinuxChangePolicy, v1PodSecurityContext.seLinuxChangePolicy) && Objects.equals(this.seLinuxOptions, v1PodSecurityContext.seLinuxOptions) && Objects.equals(this.seccompProfile, v1PodSecurityContext.seccompProfile) && Objects.equals(this.supplementalGroups, v1PodSecurityContext.supplementalGroups) && Objects.equals(this.supplementalGroupsPolicy, v1PodSecurityContext.supplementalGroupsPolicy) && Objects.equals(this.sysctls, v1PodSecurityContext.sysctls) && Objects.equals(this.windowsOptions, v1PodSecurityContext.windowsOptions);
    }

    public int hashCode() {
        return Objects.hash(this.appArmorProfile, this.fsGroup, this.fsGroupChangePolicy, this.runAsGroup, this.runAsNonRoot, this.runAsUser, this.seLinuxChangePolicy, this.seLinuxOptions, this.seccompProfile, this.supplementalGroups, this.supplementalGroupsPolicy, this.sysctls, this.windowsOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodSecurityContext {\n");
        sb.append("    appArmorProfile: ").append(this.toIndentedString(this.appArmorProfile)).append("\n");
        sb.append("    fsGroup: ").append(this.toIndentedString(this.fsGroup)).append("\n");
        sb.append("    fsGroupChangePolicy: ").append(this.toIndentedString(this.fsGroupChangePolicy)).append("\n");
        sb.append("    runAsGroup: ").append(this.toIndentedString(this.runAsGroup)).append("\n");
        sb.append("    runAsNonRoot: ").append(this.toIndentedString(this.runAsNonRoot)).append("\n");
        sb.append("    runAsUser: ").append(this.toIndentedString(this.runAsUser)).append("\n");
        sb.append("    seLinuxChangePolicy: ").append(this.toIndentedString(this.seLinuxChangePolicy)).append("\n");
        sb.append("    seLinuxOptions: ").append(this.toIndentedString(this.seLinuxOptions)).append("\n");
        sb.append("    seccompProfile: ").append(this.toIndentedString(this.seccompProfile)).append("\n");
        sb.append("    supplementalGroups: ").append(this.toIndentedString(this.supplementalGroups)).append("\n");
        sb.append("    supplementalGroupsPolicy: ").append(this.toIndentedString(this.supplementalGroupsPolicy)).append("\n");
        sb.append("    sysctls: ").append(this.toIndentedString(this.sysctls)).append("\n");
        sb.append("    windowsOptions: ").append(this.toIndentedString(this.windowsOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraysysctls;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PodSecurityContext is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PodSecurityContext` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_APP_ARMOR_PROFILE) != null && !jsonObj.get(SERIALIZED_NAME_APP_ARMOR_PROFILE).isJsonNull()) {
            V1AppArmorProfile.validateJsonElement(jsonObj.get(SERIALIZED_NAME_APP_ARMOR_PROFILE));
        }
        if (jsonObj.get(SERIALIZED_NAME_FS_GROUP_CHANGE_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_FS_GROUP_CHANGE_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FS_GROUP_CHANGE_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fsGroupChangePolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FS_GROUP_CHANGE_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SE_LINUX_CHANGE_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_SE_LINUX_CHANGE_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SE_LINUX_CHANGE_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `seLinuxChangePolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SE_LINUX_CHANGE_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SE_LINUX_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_SE_LINUX_OPTIONS).isJsonNull()) {
            V1SELinuxOptions.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SE_LINUX_OPTIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECCOMP_PROFILE) != null && !jsonObj.get(SERIALIZED_NAME_SECCOMP_PROFILE).isJsonNull()) {
            V1SeccompProfile.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SECCOMP_PROFILE));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS) != null && !jsonObj.get(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `supplementalGroups` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `supplementalGroupsPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SYSCTLS) != null && !jsonObj.get(SERIALIZED_NAME_SYSCTLS).isJsonNull() && (jsonArraysysctls = jsonObj.getAsJsonArray(SERIALIZED_NAME_SYSCTLS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SYSCTLS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `sysctls` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYSCTLS).toString()));
            }
            for (int i = 0; i < jsonArraysysctls.size(); ++i) {
                V1Sysctl.validateJsonElement(jsonArraysysctls.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_WINDOWS_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_WINDOWS_OPTIONS).isJsonNull()) {
            V1WindowsSecurityContextOptions.validateJsonElement(jsonObj.get(SERIALIZED_NAME_WINDOWS_OPTIONS));
        }
    }

    public static V1PodSecurityContext fromJson(String jsonString) throws IOException {
        return (V1PodSecurityContext)JSON.getGson().fromJson(jsonString, V1PodSecurityContext.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_APP_ARMOR_PROFILE);
        openapiFields.add(SERIALIZED_NAME_FS_GROUP);
        openapiFields.add(SERIALIZED_NAME_FS_GROUP_CHANGE_POLICY);
        openapiFields.add(SERIALIZED_NAME_RUN_AS_GROUP);
        openapiFields.add(SERIALIZED_NAME_RUN_AS_NON_ROOT);
        openapiFields.add(SERIALIZED_NAME_RUN_AS_USER);
        openapiFields.add(SERIALIZED_NAME_SE_LINUX_CHANGE_POLICY);
        openapiFields.add(SERIALIZED_NAME_SE_LINUX_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_SECCOMP_PROFILE);
        openapiFields.add(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS);
        openapiFields.add(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS_POLICY);
        openapiFields.add(SERIALIZED_NAME_SYSCTLS);
        openapiFields.add(SERIALIZED_NAME_WINDOWS_OPTIONS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PodSecurityContext.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PodSecurityContext.class));
            return new TypeAdapter<V1PodSecurityContext>(){

                public void write(JsonWriter out, V1PodSecurityContext value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PodSecurityContext read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1PodSecurityContext.validateJsonElement(jsonElement);
                    return (V1PodSecurityContext)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

