/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.")
public class V1NodeSelectorRequirement {
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    @Nonnull
    private String key;
    public static final String SERIALIZED_NAME_OPERATOR = "operator";
    @SerializedName(value="operator")
    @Nonnull
    private String operator;
    public static final String SERIALIZED_NAME_VALUES = "values";
    @SerializedName(value="values")
    @Nullable
    private List<String> values = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1NodeSelectorRequirement key(@Nonnull String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The label key that the selector applies to.")
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nonnull String key) {
        this.key = key;
    }

    public V1NodeSelectorRequirement operator(@Nonnull String operator) {
        this.operator = operator;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.")
    public String getOperator() {
        return this.operator;
    }

    public void setOperator(@Nonnull String operator) {
        this.operator = operator;
    }

    public V1NodeSelectorRequirement values(@Nullable List<String> values) {
        this.values = values;
        return this;
    }

    public V1NodeSelectorRequirement addValuesItem(String valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.")
    public List<String> getValues() {
        return this.values;
    }

    public void setValues(@Nullable List<String> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NodeSelectorRequirement v1NodeSelectorRequirement = (V1NodeSelectorRequirement)o;
        return Objects.equals(this.key, v1NodeSelectorRequirement.key) && Objects.equals(this.operator, v1NodeSelectorRequirement.operator) && Objects.equals(this.values, v1NodeSelectorRequirement.values);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.operator, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NodeSelectorRequirement {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString(this.operator)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1NodeSelectorRequirement is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1NodeSelectorRequirement` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_OPERATOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `operator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPERATOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VALUES) != null && !jsonObj.get(SERIALIZED_NAME_VALUES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VALUES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `values` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALUES).toString()));
        }
    }

    public static V1NodeSelectorRequirement fromJson(String jsonString) throws IOException {
        return (V1NodeSelectorRequirement)JSON.getGson().fromJson(jsonString, V1NodeSelectorRequirement.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_OPERATOR);
        openapiFields.add(SERIALIZED_NAME_VALUES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_OPERATOR);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1NodeSelectorRequirement.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1NodeSelectorRequirement.class));
            return new TypeAdapter<V1NodeSelectorRequirement>(){

                public void write(JsonWriter out, V1NodeSelectorRequirement value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1NodeSelectorRequirement read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1NodeSelectorRequirement.validateJsonElement(jsonElement);
                    return (V1NodeSelectorRequirement)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

