/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource that the fieldset applies to.")
public class V1ManagedFieldsEntry {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    @Nullable
    private String apiVersion;
    public static final String SERIALIZED_NAME_FIELDS_TYPE = "fieldsType";
    @SerializedName(value="fieldsType")
    @Nullable
    private String fieldsType;
    public static final String SERIALIZED_NAME_FIELDS_V1 = "fieldsV1";
    @SerializedName(value="fieldsV1")
    @Nullable
    private Object fieldsV1;
    public static final String SERIALIZED_NAME_MANAGER = "manager";
    @SerializedName(value="manager")
    @Nullable
    private String manager;
    public static final String SERIALIZED_NAME_OPERATION = "operation";
    @SerializedName(value="operation")
    @Nullable
    private String operation;
    public static final String SERIALIZED_NAME_SUBRESOURCE = "subresource";
    @SerializedName(value="subresource")
    @Nullable
    private String subresource;
    public static final String SERIALIZED_NAME_TIME = "time";
    @SerializedName(value="time")
    @Nullable
    private OffsetDateTime time;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ManagedFieldsEntry apiVersion(@Nullable String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the version of this resource that this field set applies to. The format is \"group/version\" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(@Nullable String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1ManagedFieldsEntry fieldsType(@Nullable String fieldsType) {
        this.fieldsType = fieldsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: \"FieldsV1\"")
    public String getFieldsType() {
        return this.fieldsType;
    }

    public void setFieldsType(@Nullable String fieldsType) {
        this.fieldsType = fieldsType;
    }

    public V1ManagedFieldsEntry fieldsV1(@Nullable Object fieldsV1) {
        this.fieldsV1 = fieldsV1;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="FieldsV1 holds the first JSON version format as described in the \"FieldsV1\" type.")
    public Object getFieldsV1() {
        return this.fieldsV1;
    }

    public void setFieldsV1(@Nullable Object fieldsV1) {
        this.fieldsV1 = fieldsV1;
    }

    public V1ManagedFieldsEntry manager(@Nullable String manager) {
        this.manager = manager;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Manager is an identifier of the workflow managing these fields.")
    public String getManager() {
        return this.manager;
    }

    public void setManager(@Nullable String manager) {
        this.manager = manager;
    }

    public V1ManagedFieldsEntry operation(@Nullable String operation) {
        this.operation = operation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.")
    public String getOperation() {
        return this.operation;
    }

    public void setOperation(@Nullable String operation) {
        this.operation = operation;
    }

    public V1ManagedFieldsEntry subresource(@Nullable String subresource) {
        this.subresource = subresource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.")
    public String getSubresource() {
        return this.subresource;
    }

    public void setSubresource(@Nullable String subresource) {
        this.subresource = subresource;
    }

    public V1ManagedFieldsEntry time(@Nullable OffsetDateTime time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.")
    public OffsetDateTime getTime() {
        return this.time;
    }

    public void setTime(@Nullable OffsetDateTime time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ManagedFieldsEntry v1ManagedFieldsEntry = (V1ManagedFieldsEntry)o;
        return Objects.equals(this.apiVersion, v1ManagedFieldsEntry.apiVersion) && Objects.equals(this.fieldsType, v1ManagedFieldsEntry.fieldsType) && Objects.equals(this.fieldsV1, v1ManagedFieldsEntry.fieldsV1) && Objects.equals(this.manager, v1ManagedFieldsEntry.manager) && Objects.equals(this.operation, v1ManagedFieldsEntry.operation) && Objects.equals(this.subresource, v1ManagedFieldsEntry.subresource) && Objects.equals(this.time, v1ManagedFieldsEntry.time);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.fieldsType, this.fieldsV1, this.manager, this.operation, this.subresource, this.time);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ManagedFieldsEntry {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    fieldsType: ").append(this.toIndentedString(this.fieldsType)).append("\n");
        sb.append("    fieldsV1: ").append(this.toIndentedString(this.fieldsV1)).append("\n");
        sb.append("    manager: ").append(this.toIndentedString(this.manager)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString(this.operation)).append("\n");
        sb.append("    subresource: ").append(this.toIndentedString(this.subresource)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ManagedFieldsEntry is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ManagedFieldsEntry` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FIELDS_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_FIELDS_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FIELDS_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fieldsType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FIELDS_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MANAGER) != null && !jsonObj.get(SERIALIZED_NAME_MANAGER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MANAGER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `manager` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MANAGER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPERATION) != null && !jsonObj.get(SERIALIZED_NAME_OPERATION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OPERATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `operation` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPERATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBRESOURCE) != null && !jsonObj.get(SERIALIZED_NAME_SUBRESOURCE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUBRESOURCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subresource` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBRESOURCE).toString()));
        }
    }

    public static V1ManagedFieldsEntry fromJson(String jsonString) throws IOException {
        return (V1ManagedFieldsEntry)JSON.getGson().fromJson(jsonString, V1ManagedFieldsEntry.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_FIELDS_TYPE);
        openapiFields.add(SERIALIZED_NAME_FIELDS_V1);
        openapiFields.add(SERIALIZED_NAME_MANAGER);
        openapiFields.add(SERIALIZED_NAME_OPERATION);
        openapiFields.add(SERIALIZED_NAME_SUBRESOURCE);
        openapiFields.add(SERIALIZED_NAME_TIME);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ManagedFieldsEntry.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ManagedFieldsEntry.class));
            return new TypeAdapter<V1ManagedFieldsEntry>(){

                public void write(JsonWriter out, V1ManagedFieldsEntry value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ManagedFieldsEntry read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ManagedFieldsEntry.validateJsonElement(jsonElement);
                    return (V1ManagedFieldsEntry)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

