/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Represents a volume that is populated with the contents of a git repository. Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.  DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.")
public class V1GitRepoVolumeSource {
    public static final String SERIALIZED_NAME_DIRECTORY = "directory";
    @SerializedName(value="directory")
    @Nullable
    private String directory;
    public static final String SERIALIZED_NAME_REPOSITORY = "repository";
    @SerializedName(value="repository")
    @Nonnull
    private String repository;
    public static final String SERIALIZED_NAME_REVISION = "revision";
    @SerializedName(value="revision")
    @Nullable
    private String revision;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1GitRepoVolumeSource directory(@Nullable String directory) {
        this.directory = directory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="directory is the target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.")
    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(@Nullable String directory) {
        this.directory = directory;
    }

    public V1GitRepoVolumeSource repository(@Nonnull String repository) {
        this.repository = repository;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="repository is the URL")
    public String getRepository() {
        return this.repository;
    }

    public void setRepository(@Nonnull String repository) {
        this.repository = repository;
    }

    public V1GitRepoVolumeSource revision(@Nullable String revision) {
        this.revision = revision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="revision is the commit hash for the specified revision.")
    public String getRevision() {
        return this.revision;
    }

    public void setRevision(@Nullable String revision) {
        this.revision = revision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1GitRepoVolumeSource v1GitRepoVolumeSource = (V1GitRepoVolumeSource)o;
        return Objects.equals(this.directory, v1GitRepoVolumeSource.directory) && Objects.equals(this.repository, v1GitRepoVolumeSource.repository) && Objects.equals(this.revision, v1GitRepoVolumeSource.revision);
    }

    public int hashCode() {
        return Objects.hash(this.directory, this.repository, this.revision);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1GitRepoVolumeSource {\n");
        sb.append("    directory: ").append(this.toIndentedString(this.directory)).append("\n");
        sb.append("    repository: ").append(this.toIndentedString(this.repository)).append("\n");
        sb.append("    revision: ").append(this.toIndentedString(this.revision)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1GitRepoVolumeSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1GitRepoVolumeSource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_DIRECTORY) != null && !jsonObj.get(SERIALIZED_NAME_DIRECTORY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DIRECTORY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `directory` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DIRECTORY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_REPOSITORY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `repository` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPOSITORY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REVISION) != null && !jsonObj.get(SERIALIZED_NAME_REVISION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REVISION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `revision` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REVISION).toString()));
        }
    }

    public static V1GitRepoVolumeSource fromJson(String jsonString) throws IOException {
        return (V1GitRepoVolumeSource)JSON.getGson().fromJson(jsonString, V1GitRepoVolumeSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DIRECTORY);
        openapiFields.add(SERIALIZED_NAME_REPOSITORY);
        openapiFields.add(SERIALIZED_NAME_REVISION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_REPOSITORY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1GitRepoVolumeSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1GitRepoVolumeSource.class));
            return new TypeAdapter<V1GitRepoVolumeSource>(){

                public void write(JsonWriter out, V1GitRepoVolumeSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1GitRepoVolumeSource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1GitRepoVolumeSource.validateJsonElement(jsonElement);
                    return (V1GitRepoVolumeSource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

