/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1DaemonSetCondition;
import io.kubernetes.client.openapi.models.V1DaemonSetConditionBuilder;
import io.kubernetes.client.openapi.models.V1DaemonSetConditionFluent;
import io.kubernetes.client.openapi.models.V1DaemonSetStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1DaemonSetStatusFluent<A extends V1DaemonSetStatusFluent<A>>
extends BaseFluent<A> {
    private Integer collisionCount;
    private ArrayList<V1DaemonSetConditionBuilder> conditions;
    private Integer currentNumberScheduled;
    private Integer desiredNumberScheduled;
    private Integer numberAvailable;
    private Integer numberMisscheduled;
    private Integer numberReady;
    private Integer numberUnavailable;
    private Long observedGeneration;
    private Integer updatedNumberScheduled;

    public V1DaemonSetStatusFluent() {
    }

    public V1DaemonSetStatusFluent(V1DaemonSetStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1DaemonSetStatus instance) {
        V1DaemonSetStatus v1DaemonSetStatus = instance = instance != null ? instance : new V1DaemonSetStatus();
        if (instance != null) {
            this.withCollisionCount(instance.getCollisionCount());
            this.withConditions(instance.getConditions());
            this.withCurrentNumberScheduled(instance.getCurrentNumberScheduled());
            this.withDesiredNumberScheduled(instance.getDesiredNumberScheduled());
            this.withNumberAvailable(instance.getNumberAvailable());
            this.withNumberMisscheduled(instance.getNumberMisscheduled());
            this.withNumberReady(instance.getNumberReady());
            this.withNumberUnavailable(instance.getNumberUnavailable());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withUpdatedNumberScheduled(instance.getUpdatedNumberScheduled());
        }
    }

    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public A withCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return (A)this;
    }

    public boolean hasCollisionCount() {
        return this.collisionCount != null;
    }

    public A addToConditions(int index, V1DaemonSetCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1DaemonSetConditionBuilder builder = new V1DaemonSetConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, V1DaemonSetCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1DaemonSetConditionBuilder builder = new V1DaemonSetConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(V1DaemonSetCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1DaemonSetCondition item : items) {
            V1DaemonSetConditionBuilder builder = new V1DaemonSetConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<V1DaemonSetCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1DaemonSetCondition item : items) {
            V1DaemonSetConditionBuilder builder = new V1DaemonSetConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(V1DaemonSetCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1DaemonSetCondition item : items) {
            V1DaemonSetConditionBuilder builder = new V1DaemonSetConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<V1DaemonSetCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1DaemonSetCondition item : items) {
            V1DaemonSetConditionBuilder builder = new V1DaemonSetConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<V1DaemonSetConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1DaemonSetConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1DaemonSetConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1DaemonSetCondition> buildConditions() {
        return this.conditions != null ? V1DaemonSetStatusFluent.build(this.conditions) : null;
    }

    public V1DaemonSetCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public V1DaemonSetCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public V1DaemonSetCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public V1DaemonSetCondition buildMatchingCondition(Predicate<V1DaemonSetConditionBuilder> predicate) {
        for (V1DaemonSetConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<V1DaemonSetConditionBuilder> predicate) {
        for (V1DaemonSetConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<V1DaemonSetCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V1DaemonSetCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(V1DaemonSetCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (V1DaemonSetCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(V1DaemonSetCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, V1DaemonSetCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<V1DaemonSetConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Integer getCurrentNumberScheduled() {
        return this.currentNumberScheduled;
    }

    public A withCurrentNumberScheduled(Integer currentNumberScheduled) {
        this.currentNumberScheduled = currentNumberScheduled;
        return (A)this;
    }

    public boolean hasCurrentNumberScheduled() {
        return this.currentNumberScheduled != null;
    }

    public Integer getDesiredNumberScheduled() {
        return this.desiredNumberScheduled;
    }

    public A withDesiredNumberScheduled(Integer desiredNumberScheduled) {
        this.desiredNumberScheduled = desiredNumberScheduled;
        return (A)this;
    }

    public boolean hasDesiredNumberScheduled() {
        return this.desiredNumberScheduled != null;
    }

    public Integer getNumberAvailable() {
        return this.numberAvailable;
    }

    public A withNumberAvailable(Integer numberAvailable) {
        this.numberAvailable = numberAvailable;
        return (A)this;
    }

    public boolean hasNumberAvailable() {
        return this.numberAvailable != null;
    }

    public Integer getNumberMisscheduled() {
        return this.numberMisscheduled;
    }

    public A withNumberMisscheduled(Integer numberMisscheduled) {
        this.numberMisscheduled = numberMisscheduled;
        return (A)this;
    }

    public boolean hasNumberMisscheduled() {
        return this.numberMisscheduled != null;
    }

    public Integer getNumberReady() {
        return this.numberReady;
    }

    public A withNumberReady(Integer numberReady) {
        this.numberReady = numberReady;
        return (A)this;
    }

    public boolean hasNumberReady() {
        return this.numberReady != null;
    }

    public Integer getNumberUnavailable() {
        return this.numberUnavailable;
    }

    public A withNumberUnavailable(Integer numberUnavailable) {
        this.numberUnavailable = numberUnavailable;
        return (A)this;
    }

    public boolean hasNumberUnavailable() {
        return this.numberUnavailable != null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public Integer getUpdatedNumberScheduled() {
        return this.updatedNumberScheduled;
    }

    public A withUpdatedNumberScheduled(Integer updatedNumberScheduled) {
        this.updatedNumberScheduled = updatedNumberScheduled;
        return (A)this;
    }

    public boolean hasUpdatedNumberScheduled() {
        return this.updatedNumberScheduled != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1DaemonSetStatusFluent that = (V1DaemonSetStatusFluent)o;
        if (!Objects.equals(this.collisionCount, that.collisionCount)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.currentNumberScheduled, that.currentNumberScheduled)) {
            return false;
        }
        if (!Objects.equals(this.desiredNumberScheduled, that.desiredNumberScheduled)) {
            return false;
        }
        if (!Objects.equals(this.numberAvailable, that.numberAvailable)) {
            return false;
        }
        if (!Objects.equals(this.numberMisscheduled, that.numberMisscheduled)) {
            return false;
        }
        if (!Objects.equals(this.numberReady, that.numberReady)) {
            return false;
        }
        if (!Objects.equals(this.numberUnavailable, that.numberUnavailable)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        return Objects.equals(this.updatedNumberScheduled, that.updatedNumberScheduled);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.collisionCount, this.conditions, this.currentNumberScheduled, this.desiredNumberScheduled, this.numberAvailable, this.numberMisscheduled, this.numberReady, this.numberUnavailable, this.observedGeneration, this.updatedNumberScheduled, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.collisionCount != null) {
            sb.append("collisionCount:");
            sb.append(this.collisionCount + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.currentNumberScheduled != null) {
            sb.append("currentNumberScheduled:");
            sb.append(this.currentNumberScheduled + ",");
        }
        if (this.desiredNumberScheduled != null) {
            sb.append("desiredNumberScheduled:");
            sb.append(this.desiredNumberScheduled + ",");
        }
        if (this.numberAvailable != null) {
            sb.append("numberAvailable:");
            sb.append(this.numberAvailable + ",");
        }
        if (this.numberMisscheduled != null) {
            sb.append("numberMisscheduled:");
            sb.append(this.numberMisscheduled + ",");
        }
        if (this.numberReady != null) {
            sb.append("numberReady:");
            sb.append(this.numberReady + ",");
        }
        if (this.numberUnavailable != null) {
            sb.append("numberUnavailable:");
            sb.append(this.numberUnavailable + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.updatedNumberScheduled != null) {
            sb.append("updatedNumberScheduled:");
            sb.append(this.updatedNumberScheduled);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends V1DaemonSetConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        V1DaemonSetConditionBuilder builder;
        int index;

        ConditionsNested(int index, V1DaemonSetCondition item) {
            this.index = index;
            this.builder = new V1DaemonSetConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1DaemonSetStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

