/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="AggregationRule describes how to locate ClusterRoles to aggregate into the ClusterRole")
public class V1AggregationRule {
    public static final String SERIALIZED_NAME_CLUSTER_ROLE_SELECTORS = "clusterRoleSelectors";
    @SerializedName(value="clusterRoleSelectors")
    @Nullable
    private List<V1LabelSelector> clusterRoleSelectors = new ArrayList<V1LabelSelector>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1AggregationRule clusterRoleSelectors(@Nullable List<V1LabelSelector> clusterRoleSelectors) {
        this.clusterRoleSelectors = clusterRoleSelectors;
        return this;
    }

    public V1AggregationRule addClusterRoleSelectorsItem(V1LabelSelector clusterRoleSelectorsItem) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList<V1LabelSelector>();
        }
        this.clusterRoleSelectors.add(clusterRoleSelectorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ClusterRoleSelectors holds a list of selectors which will be used to find ClusterRoles and create the rules. If any of the selectors match, then the ClusterRole's permissions will be added")
    public List<V1LabelSelector> getClusterRoleSelectors() {
        return this.clusterRoleSelectors;
    }

    public void setClusterRoleSelectors(@Nullable List<V1LabelSelector> clusterRoleSelectors) {
        this.clusterRoleSelectors = clusterRoleSelectors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1AggregationRule v1AggregationRule = (V1AggregationRule)o;
        return Objects.equals(this.clusterRoleSelectors, v1AggregationRule.clusterRoleSelectors);
    }

    public int hashCode() {
        return Objects.hash(this.clusterRoleSelectors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1AggregationRule {\n");
        sb.append("    clusterRoleSelectors: ").append(this.toIndentedString(this.clusterRoleSelectors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayclusterRoleSelectors;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1AggregationRule is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1AggregationRule` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CLUSTER_ROLE_SELECTORS) != null && !jsonObj.get(SERIALIZED_NAME_CLUSTER_ROLE_SELECTORS).isJsonNull() && (jsonArrayclusterRoleSelectors = jsonObj.getAsJsonArray(SERIALIZED_NAME_CLUSTER_ROLE_SELECTORS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CLUSTER_ROLE_SELECTORS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `clusterRoleSelectors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLUSTER_ROLE_SELECTORS).toString()));
            }
            for (int i = 0; i < jsonArrayclusterRoleSelectors.size(); ++i) {
                V1LabelSelector.validateJsonElement(jsonArrayclusterRoleSelectors.get(i));
            }
        }
    }

    public static V1AggregationRule fromJson(String jsonString) throws IOException {
        return (V1AggregationRule)JSON.getGson().fromJson(jsonString, V1AggregationRule.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CLUSTER_ROLE_SELECTORS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1AggregationRule.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1AggregationRule.class));
            return new TypeAdapter<V1AggregationRule>(){

                public void write(JsonWriter out, V1AggregationRule value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1AggregationRule read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1AggregationRule.validateJsonElement(jsonElement);
                    return (V1AggregationRule)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

