/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.AdmissionregistrationV1ServiceReference;
import io.kubernetes.client.openapi.models.AdmissionregistrationV1ServiceReferenceBuilder;
import io.kubernetes.client.openapi.models.AdmissionregistrationV1ServiceReferenceFluent;
import io.kubernetes.client.openapi.models.AdmissionregistrationV1WebhookClientConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AdmissionregistrationV1WebhookClientConfigFluent<A extends AdmissionregistrationV1WebhookClientConfigFluent<A>>
extends BaseFluent<A> {
    private List<Byte> caBundle;
    private AdmissionregistrationV1ServiceReferenceBuilder service;
    private String url;

    public AdmissionregistrationV1WebhookClientConfigFluent() {
    }

    public AdmissionregistrationV1WebhookClientConfigFluent(AdmissionregistrationV1WebhookClientConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AdmissionregistrationV1WebhookClientConfig instance) {
        AdmissionregistrationV1WebhookClientConfig admissionregistrationV1WebhookClientConfig = instance = instance != null ? instance : new AdmissionregistrationV1WebhookClientConfig();
        if (instance != null) {
            this.withCaBundle(instance.getCaBundle());
            this.withService(instance.getService());
            this.withUrl(instance.getUrl());
        }
    }

    public A withCaBundle(byte ... caBundle) {
        if (this.caBundle != null) {
            this.caBundle.clear();
            this._visitables.remove("caBundle");
        }
        if (caBundle != null) {
            for (byte item : caBundle) {
                this.addToCaBundle(item);
            }
        }
        return (A)this;
    }

    public byte[] getCaBundle() {
        int size = this.caBundle != null ? this.caBundle.size() : 0;
        byte[] result = new byte[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (byte item : this.caBundle) {
            result[index++] = item;
        }
        return result;
    }

    public A addToCaBundle(int index, Byte item) {
        if (this.caBundle == null) {
            this.caBundle = new ArrayList<Byte>();
        }
        this.caBundle.add(index, item);
        return (A)this;
    }

    public A setToCaBundle(int index, Byte item) {
        if (this.caBundle == null) {
            this.caBundle = new ArrayList<Byte>();
        }
        this.caBundle.set(index, item);
        return (A)this;
    }

    public A addToCaBundle(Byte ... items) {
        if (this.caBundle == null) {
            this.caBundle = new ArrayList<Byte>();
        }
        for (Byte item : items) {
            this.caBundle.add(item);
        }
        return (A)this;
    }

    public A addAllToCaBundle(Collection<Byte> items) {
        if (this.caBundle == null) {
            this.caBundle = new ArrayList<Byte>();
        }
        for (Byte item : items) {
            this.caBundle.add(item);
        }
        return (A)this;
    }

    public A removeFromCaBundle(Byte ... items) {
        if (this.caBundle == null) {
            return (A)this;
        }
        for (Byte item : items) {
            this.caBundle.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromCaBundle(Collection<Byte> items) {
        if (this.caBundle == null) {
            return (A)this;
        }
        for (Byte item : items) {
            this.caBundle.remove(item);
        }
        return (A)this;
    }

    public boolean hasCaBundle() {
        return this.caBundle != null && !this.caBundle.isEmpty();
    }

    public AdmissionregistrationV1ServiceReference buildService() {
        return this.service != null ? this.service.build() : null;
    }

    public A withService(AdmissionregistrationV1ServiceReference service) {
        this._visitables.remove("service");
        if (service != null) {
            this.service = new AdmissionregistrationV1ServiceReferenceBuilder(service);
            this._visitables.get("service").add(this.service);
        } else {
            this.service = null;
            this._visitables.get("service").remove(this.service);
        }
        return (A)this;
    }

    public boolean hasService() {
        return this.service != null;
    }

    public ServiceNested<A> withNewService() {
        return new ServiceNested(null);
    }

    public ServiceNested<A> withNewServiceLike(AdmissionregistrationV1ServiceReference item) {
        return new ServiceNested(item);
    }

    public ServiceNested<A> editService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(null));
    }

    public ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(new AdmissionregistrationV1ServiceReferenceBuilder().build()));
    }

    public ServiceNested<A> editOrNewServiceLike(AdmissionregistrationV1ServiceReference item) {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(item));
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdmissionregistrationV1WebhookClientConfigFluent that = (AdmissionregistrationV1WebhookClientConfigFluent)o;
        if (!Objects.equals(this.caBundle, that.caBundle)) {
            return false;
        }
        if (!Objects.equals(this.service, that.service)) {
            return false;
        }
        return Objects.equals(this.url, that.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.caBundle, this.service, this.url, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caBundle != null && !this.caBundle.isEmpty()) {
            sb.append("caBundle:");
            sb.append(String.valueOf(this.caBundle) + ",");
        }
        if (this.service != null) {
            sb.append("service:");
            sb.append(String.valueOf(this.service) + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServiceNested<N>
    extends AdmissionregistrationV1ServiceReferenceFluent<ServiceNested<N>>
    implements Nested<N> {
        AdmissionregistrationV1ServiceReferenceBuilder builder;

        ServiceNested(AdmissionregistrationV1ServiceReference item) {
            this.builder = new AdmissionregistrationV1ServiceReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AdmissionregistrationV1WebhookClientConfigFluent.this.withService(this.builder.build());
        }

        public N endService() {
            return this.and();
        }
    }
}

