/*
 * Decompiled with CFR 0.152.
 */
package io.kri.anotherViewPager;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DimenRes;
import android.support.annotation.FontRes;
import android.support.design.widget.TabLayout;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.kri.anotherViewPager.R;
import io.kri.anotherViewPager.TabbedViewPagerAdapter;
import io.kri.anotherViewPager.UIAndroidUtils;

public class TabbedViewPager
extends LinearLayout {
    private ViewPager viewPager;
    private TabLayout tabLayout;
    private int currentPage;
    private int oldPage = 0;
    private int selectedTabFont = 0;
    private int defaultTabFont = 0;
    private int tabMarginStart = 0;
    private int tabMarginEnd = 0;
    private int tabMarginBottom = 0;
    private int tabMarginTop = 0;
    private int tabSelectedTextColor;
    private int tabDefaultTextColor = 0;

    public TabbedViewPager(Context context) {
        this(context, null);
    }

    public TabbedViewPager(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TabbedViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    public Parcelable onSaveInstanceState() {
        this.currentPage = this.viewPager.getCurrentItem();
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putInt("currentPage", this.currentPage);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.oldPage = this.currentPage = bundle.getInt("currentPage");
            state = bundle.getParcelable("superState");
        }
        super.onRestoreInstanceState(state);
    }

    public void handleTypedArray(Context context, AttributeSet attrs, int defStyleAttr) {
        if (attrs == null) {
            return;
        }
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.TabbedViewPager, defStyleAttr, R.style.TabbedViewPagerStyle);
        this.tabMarginStart = (int)array.getDimension(R.styleable.TabbedViewPager_tabItemsMarginStart, UIAndroidUtils.getDimenFromResource(this.getContext(), R.dimen.space_16));
        this.tabMarginEnd = (int)array.getDimension(R.styleable.TabbedViewPager_tabItemsMarginEnd, 0.0f);
        this.tabMarginBottom = (int)array.getDimension(R.styleable.TabbedViewPager_tabItemsMarginBottom, 0.0f);
        this.tabMarginTop = (int)array.getDimension(R.styleable.TabbedViewPager_tabItemsMarginTop, 0.0f);
        this.tabSelectedTextColor = array.getColor(R.styleable.TabbedViewPager_tabSelectedTextColor, -16777216);
        this.selectedTabFont = array.getResourceId(R.styleable.TabbedViewPager_tabSelectedFont, 0);
        this.defaultTabFont = array.getResourceId(R.styleable.TabbedViewPager_tabDefaultFont, 0);
        array.recycle();
    }

    public TabbedViewPager setSelectedTabFont(@FontRes int font) {
        this.selectedTabFont = font;
        return this;
    }

    public TabbedViewPager setDefaultTabFont(int defaultTabFont) {
        this.defaultTabFont = defaultTabFont;
        return this;
    }

    private void setTabFont(int textViewId, @FontRes int font, int position) {
        if (font == 0) {
            return;
        }
        Typeface typeface = ResourcesCompat.getFont((Context)this.getContext(), (int)font);
        this.setTabFont(textViewId, typeface, position);
    }

    private void setTabFont(int textViewId, Typeface font, int position) {
        TabLayout.Tab tab = this.tabLayout.getTabAt(position);
        if (tab != null) {
            View tabCustomView = tab.getCustomView();
            TextView title = tabCustomView != null ? (TextView)tabCustomView.findViewById(textViewId) : (TextView)this.tabLayout.getChildAt(position).findViewById(16908310);
            title.setTypeface(font);
        }
    }

    private void setTabTextColor(int textViewId, @ColorInt int color, int position) {
        if (color == 0) {
            return;
        }
        TabLayout.Tab tab = this.tabLayout.getTabAt(position);
        if (tab != null) {
            View tabCustomView = tab.getCustomView();
            TextView title = tabCustomView != null ? (TextView)tabCustomView.findViewById(textViewId) : (TextView)this.tabLayout.getChildAt(position).findViewById(16908310);
            if (this.tabDefaultTextColor == 0) {
                this.tabDefaultTextColor = title.getCurrentTextColor();
            }
            title.setTextColor(color);
        }
    }

    public void setAdapter(TabbedViewPagerAdapter adapter) {
        this.viewPager.setAdapter((PagerAdapter)adapter);
        adapter.setTabLayout(this.tabLayout);
        this.viewPager.setCurrentItem(this.currentPage);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        if (!this.isInEditMode()) {
            LinearLayout.inflate((Context)this.getContext(), (int)R.layout.tabbed_view_pager, (ViewGroup)this);
        }
        this.viewPager = (ViewPager)this.findViewById(R.id.tabbed_pager);
        this.tabLayout = new TabLayout(this.getContext(), attrs, R.style.TabbedViewPagerStyle);
        this.addView((View)this.tabLayout, 0);
        this.tabLayout.setupWithViewPager(this.viewPager);
        this.viewPager.post(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < TabbedViewPager.this.tabLayout.getTabCount(); ++i) {
                    View tab = ((ViewGroup)TabbedViewPager.this.tabLayout.getChildAt(0)).getChildAt(i);
                    ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)tab.getLayoutParams();
                    p.setMargins(TabbedViewPager.this.tabMarginStart, TabbedViewPager.this.tabMarginTop, TabbedViewPager.this.tabMarginEnd, TabbedViewPager.this.tabMarginBottom);
                    TabbedViewPager.this.setTabFont(R.id.textView, TabbedViewPager.this.defaultTabFont, i);
                    tab.requestLayout();
                }
                TabbedViewPager.this.setTabTextColor(R.id.textView, TabbedViewPager.this.tabSelectedTextColor, TabbedViewPager.this.oldPage);
                TabbedViewPager.this.setTabFont(R.id.textView, TabbedViewPager.this.selectedTabFont, TabbedViewPager.this.oldPage);
            }
        });
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                TabbedViewPager.this.setTabFont(R.id.textView, TabbedViewPager.this.defaultTabFont, TabbedViewPager.this.oldPage);
                TabbedViewPager.this.setTabFont(R.id.textView, TabbedViewPager.this.selectedTabFont, position);
                TabbedViewPager.this.setTabTextColor(R.id.textView, TabbedViewPager.this.tabDefaultTextColor, TabbedViewPager.this.oldPage);
                TabbedViewPager.this.setTabTextColor(R.id.textView, TabbedViewPager.this.tabSelectedTextColor, position);
                TabbedViewPager.this.oldPage = position;
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.setOrientation(1);
        this.handleTypedArray(context, attrs, defStyleAttr);
    }

    public void addOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        if (this.viewPager == null) {
            return;
        }
        this.viewPager.addOnPageChangeListener(onPageChangeListener);
    }

    public TabbedViewPager setTabsMargin(@DimenRes int start, @DimenRes int top, @DimenRes int end, @DimenRes int bottom) {
        this.tabMarginStart = (int)UIAndroidUtils.getDimenFromResource(this.getContext(), start);
        this.tabMarginTop = (int)UIAndroidUtils.getDimenFromResource(this.getContext(), top);
        this.tabMarginEnd = (int)UIAndroidUtils.getDimenFromResource(this.getContext(), end);
        this.tabMarginBottom = (int)UIAndroidUtils.getDimenFromResource(this.getContext(), bottom);
        return this;
    }
}

