/*
 * Decompiled with CFR 0.152.
 */
package io.kri.anotherViewPager;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DimenRes;
import androidx.annotation.FontRes;
import androidx.core.content.res.ResourcesCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.google.android.material.tabs.TabLayout;
import io.kri.anotherViewPager.R;
import io.kri.anotherViewPager.TabbedViewPagerAdapter;
import io.kri.anotherViewPager.UIAndroidUtils;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ \u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u001d\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u001fH\u0016J\u000e\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010%\u001a\u00020\u00002\b\b\u0001\u0010&\u001a\u00020\u0007J\"\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u0007H\u0002J\"\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00072\b\b\u0001\u0010&\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007H\u0002J\"\u0010+\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00072\b\b\u0001\u0010,\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007H\u0002J.\u0010-\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u00072\b\b\u0001\u0010/\u001a\u00020\u00072\b\b\u0001\u00100\u001a\u00020\u00072\b\b\u0001\u00101\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lio/kri/anotherViewPager/TabbedViewPager;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "currentPage", "defaultTabFont", "oldPage", "selectedTabFont", "tabDefaultTextColor", "tabLayout", "Lcom/google/android/material/tabs/TabLayout;", "tabMarginBottom", "tabMarginEnd", "tabMarginStart", "tabMarginTop", "tabSelectedTextColor", "viewPager", "Landroidx/viewpager/widget/ViewPager;", "addOnPageChangeListener", "", "onPageChangeListener", "Landroidx/viewpager/widget/ViewPager$OnPageChangeListener;", "handleTypedArray", "init", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "setAdapter", "adapter", "Lio/kri/anotherViewPager/TabbedViewPagerAdapter;", "setDefaultTabFont", "setSelectedTabFont", "font", "setTabFont", "textViewId", "Landroid/graphics/Typeface;", "position", "setTabTextColor", "color", "setTabsMargin", "start", "top", "end", "bottom", "anotherViewPager_release"})
public final class TabbedViewPager
extends LinearLayout {
    private ViewPager viewPager;
    private TabLayout tabLayout;
    private int currentPage;
    private int oldPage;
    private int selectedTabFont;
    private int defaultTabFont;
    private int tabMarginStart;
    private int tabMarginEnd;
    private int tabMarginBottom;
    private int tabMarginTop;
    private int tabSelectedTextColor;
    private int tabDefaultTextColor;

    @Nullable
    public Parcelable onSaveInstanceState() {
        ViewPager viewPager = this.viewPager;
        if (viewPager == null) {
            Intrinsics.throwNpe();
        }
        this.currentPage = viewPager.getCurrentItem();
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putInt("currentPage", this.currentPage);
        return (Parcelable)bundle;
    }

    public void onRestoreInstanceState(@Nullable Parcelable state) {
        Parcelable parcelable = state;
        if (parcelable instanceof Bundle) {
            Bundle bundle;
            Bundle bundle2 = bundle = (Bundle)state;
            if (bundle2 == null) {
                Intrinsics.throwNpe();
            }
            this.oldPage = this.currentPage = bundle2.getInt("currentPage");
            parcelable = bundle.getParcelable("superState");
        }
        super.onRestoreInstanceState(parcelable);
    }

    public final void handleTypedArray(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (attrs == null) {
            return;
        }
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.TabbedViewPager, defStyleAttr, R.style.TabbedViewPagerStyle);
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"getContext()");
        this.tabMarginStart = (int)array.getDimension(R.styleable.TabbedViewPager_tabItemsMarginStart, UIAndroidUtils.INSTANCE.getDimenFromResource(context2, R.dimen.space_16));
        this.tabMarginEnd = (int)array.getDimension(R.styleable.TabbedViewPager_tabItemsMarginEnd, 0.0f);
        this.tabMarginBottom = (int)array.getDimension(R.styleable.TabbedViewPager_tabItemsMarginBottom, 0.0f);
        this.tabMarginTop = (int)array.getDimension(R.styleable.TabbedViewPager_tabItemsMarginTop, 0.0f);
        this.tabSelectedTextColor = array.getColor(R.styleable.TabbedViewPager_tabSelectedTextColor, -16777216);
        this.selectedTabFont = array.getResourceId(R.styleable.TabbedViewPager_tabSelectedFont, 0);
        this.defaultTabFont = array.getResourceId(R.styleable.TabbedViewPager_tabDefaultFont, 0);
        array.recycle();
    }

    @NotNull
    public final TabbedViewPager setSelectedTabFont(@FontRes int font) {
        this.selectedTabFont = font;
        return this;
    }

    @NotNull
    public final TabbedViewPager setDefaultTabFont(int defaultTabFont) {
        this.defaultTabFont = defaultTabFont;
        return this;
    }

    private final void setTabFont(int textViewId, @FontRes int font, int position) {
        if (font == 0) {
            return;
        }
        Typeface typeface = ResourcesCompat.getFont((Context)this.getContext(), (int)font);
        this.setTabFont(textViewId, typeface, position);
    }

    private final void setTabFont(int textViewId, Typeface font, int position) {
        TabLayout.Tab tab;
        TabLayout tabLayout = this.tabLayout;
        if (tabLayout == null) {
            Intrinsics.throwNpe();
        }
        if ((tab = tabLayout.getTabAt(position)) != null) {
            TextView title;
            View tabCustomView = tab.getCustomView();
            if (tabCustomView != null) {
                View view = tabCustomView.findViewById(textViewId);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"tabCustomView.findViewById(textViewId)");
                title = (TextView)view;
            } else {
                TabLayout tabLayout2 = this.tabLayout;
                if (tabLayout2 == null) {
                    Intrinsics.throwNpe();
                }
                View view = tabLayout2.getChildAt(position).findViewById(16908310);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"tabLayout!!.getChildAt(p\u2026wById(android.R.id.title)");
                title = (TextView)view;
            }
            title.setTypeface(font);
        }
    }

    private final void setTabTextColor(int textViewId, @ColorInt int color, int position) {
        TabLayout.Tab tab;
        if (color == 0) {
            return;
        }
        TabLayout tabLayout = this.tabLayout;
        if (tabLayout == null) {
            Intrinsics.throwNpe();
        }
        if ((tab = tabLayout.getTabAt(position)) != null) {
            TextView title;
            View tabCustomView = tab.getCustomView();
            if (tabCustomView != null) {
                View view = tabCustomView.findViewById(textViewId);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"tabCustomView.findViewById(textViewId)");
                title = (TextView)view;
            } else {
                TabLayout tabLayout2 = this.tabLayout;
                if (tabLayout2 == null) {
                    Intrinsics.throwNpe();
                }
                View view = tabLayout2.getChildAt(position).findViewById(16908310);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"tabLayout!!.getChildAt(p\u2026wById(android.R.id.title)");
                title = (TextView)view;
            }
            if (this.tabDefaultTextColor == 0) {
                this.tabDefaultTextColor = title.getCurrentTextColor();
            }
            title.setTextColor(color);
        }
    }

    public final void setAdapter(@NotNull TabbedViewPagerAdapter adapter) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)adapter), (String)"adapter");
        ViewPager viewPager = this.viewPager;
        if (viewPager == null) {
            Intrinsics.throwNpe();
        }
        viewPager.setAdapter((PagerAdapter)adapter);
        TabLayout tabLayout = this.tabLayout;
        if (tabLayout == null) {
            Intrinsics.throwNpe();
        }
        adapter.setTabLayout(tabLayout);
        ViewPager viewPager2 = this.viewPager;
        if (viewPager2 == null) {
            Intrinsics.throwNpe();
        }
        viewPager2.setCurrentItem(this.currentPage);
    }

    private final void init(Context context, AttributeSet attrs, int defStyleAttr) {
        if (!this.isInEditMode()) {
            LinearLayout.inflate((Context)this.getContext(), (int)R.layout.tabbed_view_pager, (ViewGroup)((ViewGroup)this));
        }
        this.viewPager = (ViewPager)this.findViewById(R.id.tabbed_pager);
        this.tabLayout = new TabLayout(this.getContext(), attrs, R.style.TabbedViewPagerStyle);
        this.addView((View)this.tabLayout, 0);
        TabLayout tabLayout = this.tabLayout;
        if (tabLayout == null) {
            Intrinsics.throwNpe();
        }
        tabLayout.setupWithViewPager(this.viewPager);
        ViewPager viewPager = this.viewPager;
        if (viewPager == null) {
            Intrinsics.throwNpe();
        }
        viewPager.post(new Runnable(this){
            final /* synthetic */ TabbedViewPager this$0;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                int n = 0;
                TabLayout tabLayout = TabbedViewPager.access$getTabLayout$p(this.this$0);
                if (tabLayout == null) {
                    Intrinsics.throwNpe();
                }
                int n2 = tabLayout.getTabCount();
                while (n < n2) {
                    void i;
                    View tab;
                    TabLayout tabLayout2 = TabbedViewPager.access$getTabLayout$p(this.this$0);
                    if (tabLayout2 == null) {
                        Intrinsics.throwNpe();
                    }
                    View view = tabLayout2.getChildAt(0);
                    if (view == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
                    }
                    View view2 = tab = ((ViewGroup)view).getChildAt((int)i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"tab");
                    ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
                    if (layoutParams == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                    }
                    ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)layoutParams;
                    p.setMargins(TabbedViewPager.access$getTabMarginStart$p(this.this$0), TabbedViewPager.access$getTabMarginTop$p(this.this$0), TabbedViewPager.access$getTabMarginEnd$p(this.this$0), TabbedViewPager.access$getTabMarginBottom$p(this.this$0));
                    TabbedViewPager.access$setTabFont(this.this$0, R.id.textView, TabbedViewPager.access$getDefaultTabFont$p(this.this$0), (int)i);
                    tab.requestLayout();
                    ++i;
                }
                TabbedViewPager.access$setTabTextColor(this.this$0, R.id.textView, TabbedViewPager.access$getTabSelectedTextColor$p(this.this$0), TabbedViewPager.access$getOldPage$p(this.this$0));
                TabbedViewPager.access$setTabFont(this.this$0, R.id.textView, TabbedViewPager.access$getSelectedTabFont$p(this.this$0), TabbedViewPager.access$getOldPage$p(this.this$0));
            }
            {
                this.this$0 = tabbedViewPager;
            }
        });
        ViewPager viewPager2 = this.viewPager;
        if (viewPager2 == null) {
            Intrinsics.throwNpe();
        }
        viewPager2.addOnPageChangeListener(new ViewPager.OnPageChangeListener(this){
            final /* synthetic */ TabbedViewPager this$0;

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                TabbedViewPager.access$setTabFont(this.this$0, R.id.textView, TabbedViewPager.access$getDefaultTabFont$p(this.this$0), TabbedViewPager.access$getOldPage$p(this.this$0));
                TabbedViewPager.access$setTabFont(this.this$0, R.id.textView, TabbedViewPager.access$getSelectedTabFont$p(this.this$0), position);
                TabbedViewPager.access$setTabTextColor(this.this$0, R.id.textView, TabbedViewPager.access$getTabDefaultTextColor$p(this.this$0), TabbedViewPager.access$getOldPage$p(this.this$0));
                TabbedViewPager.access$setTabTextColor(this.this$0, R.id.textView, TabbedViewPager.access$getTabSelectedTextColor$p(this.this$0), position);
                TabbedViewPager.access$setOldPage$p(this.this$0, position);
            }

            public void onPageScrollStateChanged(int state) {
            }
            {
                this.this$0 = $outer;
            }
        });
        this.setOrientation(1);
        this.handleTypedArray(context, attrs, defStyleAttr);
    }

    public final void addOnPageChangeListener(@NotNull ViewPager.OnPageChangeListener onPageChangeListener) {
        Intrinsics.checkParameterIsNotNull((Object)onPageChangeListener, (String)"onPageChangeListener");
        if (this.viewPager == null) {
            return;
        }
        ViewPager viewPager = this.viewPager;
        if (viewPager == null) {
            Intrinsics.throwNpe();
        }
        viewPager.addOnPageChangeListener(onPageChangeListener);
    }

    @NotNull
    public final TabbedViewPager setTabsMargin(@DimenRes int start, @DimenRes int top, @DimenRes int end, @DimenRes int bottom) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.tabMarginStart = (int)UIAndroidUtils.INSTANCE.getDimenFromResource(context, start);
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        this.tabMarginTop = (int)UIAndroidUtils.INSTANCE.getDimenFromResource(context2, top);
        Context context3 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"context");
        this.tabMarginEnd = (int)UIAndroidUtils.INSTANCE.getDimenFromResource(context3, end);
        Context context4 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context4, (String)"context");
        this.tabMarginBottom = (int)UIAndroidUtils.INSTANCE.getDimenFromResource(context4, bottom);
        return this;
    }

    @JvmOverloads
    public TabbedViewPager(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @JvmOverloads
    public /* synthetic */ TabbedViewPager(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public TabbedViewPager(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TabbedViewPager(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    @Nullable
    public static final /* synthetic */ TabLayout access$getTabLayout$p(TabbedViewPager $this) {
        return $this.tabLayout;
    }

    public static final /* synthetic */ void access$setTabLayout$p(TabbedViewPager $this, @Nullable TabLayout tabLayout) {
        $this.tabLayout = tabLayout;
    }

    public static final /* synthetic */ int access$getTabMarginStart$p(TabbedViewPager $this) {
        return $this.tabMarginStart;
    }

    public static final /* synthetic */ void access$setTabMarginStart$p(TabbedViewPager $this, int n) {
        $this.tabMarginStart = n;
    }

    public static final /* synthetic */ int access$getTabMarginTop$p(TabbedViewPager $this) {
        return $this.tabMarginTop;
    }

    public static final /* synthetic */ void access$setTabMarginTop$p(TabbedViewPager $this, int n) {
        $this.tabMarginTop = n;
    }

    public static final /* synthetic */ int access$getTabMarginEnd$p(TabbedViewPager $this) {
        return $this.tabMarginEnd;
    }

    public static final /* synthetic */ void access$setTabMarginEnd$p(TabbedViewPager $this, int n) {
        $this.tabMarginEnd = n;
    }

    public static final /* synthetic */ int access$getTabMarginBottom$p(TabbedViewPager $this) {
        return $this.tabMarginBottom;
    }

    public static final /* synthetic */ void access$setTabMarginBottom$p(TabbedViewPager $this, int n) {
        $this.tabMarginBottom = n;
    }

    public static final /* synthetic */ void access$setTabFont(TabbedViewPager $this, int textViewId, @FontRes int font, int position) {
        $this.setTabFont(textViewId, font, position);
    }

    public static final /* synthetic */ int access$getDefaultTabFont$p(TabbedViewPager $this) {
        return $this.defaultTabFont;
    }

    public static final /* synthetic */ void access$setDefaultTabFont$p(TabbedViewPager $this, int n) {
        $this.defaultTabFont = n;
    }

    public static final /* synthetic */ void access$setTabTextColor(TabbedViewPager $this, int textViewId, @ColorInt int color, int position) {
        $this.setTabTextColor(textViewId, color, position);
    }

    public static final /* synthetic */ int access$getTabSelectedTextColor$p(TabbedViewPager $this) {
        return $this.tabSelectedTextColor;
    }

    public static final /* synthetic */ void access$setTabSelectedTextColor$p(TabbedViewPager $this, int n) {
        $this.tabSelectedTextColor = n;
    }

    public static final /* synthetic */ int access$getOldPage$p(TabbedViewPager $this) {
        return $this.oldPage;
    }

    public static final /* synthetic */ void access$setOldPage$p(TabbedViewPager $this, int n) {
        $this.oldPage = n;
    }

    public static final /* synthetic */ int access$getSelectedTabFont$p(TabbedViewPager $this) {
        return $this.selectedTabFont;
    }

    public static final /* synthetic */ void access$setSelectedTabFont$p(TabbedViewPager $this, int n) {
        $this.selectedTabFont = n;
    }

    public static final /* synthetic */ int access$getTabDefaultTextColor$p(TabbedViewPager $this) {
        return $this.tabDefaultTextColor;
    }

    public static final /* synthetic */ void access$setTabDefaultTextColor$p(TabbedViewPager $this, int n) {
        $this.tabDefaultTextColor = n;
    }
}

