/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.community.ssl.util;

import io.javalin.community.ssl.SslConfig;
import io.javalin.community.ssl.SslConfigException;
import io.javalin.community.ssl.TrustConfig;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.X509KeyManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.jetty.util.JettySslUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lio/javalin/community/ssl/util/SSLUtils;", "", "()V", "createSslContextFactory", "Lorg/eclipse/jetty/util/ssl/SslContextFactory$Server;", "sslFactory", "Lnl/altindag/ssl/SSLFactory;", "getSslFactory", "config", "Lio/javalin/community/ssl/SslConfig;", "reloading", "", "parseIdentity", "", "builder", "Lnl/altindag/ssl/SSLFactory$Builder;", "parseTrust", "Lio/javalin/community/ssl/TrustConfig;", "ssl-plugin"})
public final class SSLUtils {
    @NotNull
    public static final SSLUtils INSTANCE = new SSLUtils();

    private SSLUtils() {
    }

    @NotNull
    public final SslContextFactory.Server createSslContextFactory(@Nullable SSLFactory sslFactory) {
        SslContextFactory.Server server = JettySslUtils.forServer((SSLFactory)sslFactory);
        Intrinsics.checkNotNullExpressionValue((Object)server, (String)"forServer(...)");
        return server;
    }

    @NotNull
    public final SSLFactory getSslFactory(@NotNull SslConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return this.getSslFactory(config, false);
    }

    @NotNull
    public final SSLFactory getSslFactory(@NotNull SslConfig config, boolean reloading) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        SSLFactory.Builder builder = SSLFactory.builder();
        Intrinsics.checkNotNull((Object)builder);
        this.parseIdentity(config, builder);
        TrustConfig trustConfig = config.getTrustConfig();
        if (trustConfig != null) {
            TrustConfig it = trustConfig;
            boolean bl = false;
            INSTANCE.parseTrust(it, builder);
            builder.withNeedClientAuthentication();
        }
        if (!reloading) {
            builder.withSwappableIdentityMaterial();
            builder.withSwappableTrustMaterial();
            if (config.securityProvider != null) {
                builder.withSecurityProvider(config.securityProvider);
            }
            String[] stringArray = config.tlsConfig.getCipherSuites();
            builder.withCiphers(Arrays.copyOf(stringArray, stringArray.length));
            stringArray = config.tlsConfig.getProtocols();
            builder.withProtocols(Arrays.copyOf(stringArray, stringArray.length));
        }
        SSLFactory sSLFactory = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)sSLFactory, (String)"build(...)");
        return sSLFactory;
    }

    private final void parseIdentity(SslConfig config, SSLFactory.Builder builder) throws SslConfigException {
        switch (WhenMappings.$EnumSwitchMapping$0[config.getPvt().getLoadedIdentity().ordinal()]) {
            case 1: {
                throw new SslConfigException(SslConfigException.Types.MISSING_CERT_AND_KEY_FILE);
            }
            case 2: {
                builder.withIdentityMaterial((X509KeyManager)config.getPvt().getKeyManager());
                break;
            }
            case 3: {
                KeyStore keyStore = config.getPvt().getKeyStore();
                String string = config.getPvt().getIdentityPassword();
                Intrinsics.checkNotNull((Object)string);
                char[] cArray = string.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                builder.withIdentityMaterial(keyStore, cArray);
            }
        }
    }

    private final void parseTrust(TrustConfig config, SSLFactory.Builder builder) {
        if (!((Collection)config.getCertificates()).isEmpty()) {
            builder.withTrustMaterial(config.getCertificates());
        }
        if (!((Collection)config.getKeyStore()).isEmpty()) {
            config.getKeyStore().forEach(arg_0 -> SSLUtils.parseTrust$lambda$1(builder, arg_0));
        }
    }

    private static final void parseTrust$lambda$1(SSLFactory.Builder $builder, KeyStore trustStore) {
        Intrinsics.checkNotNullParameter((Object)$builder, (String)"$builder");
        $builder.withTrustMaterial(trustStore);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SslConfig.LoadedIdentity.values().length];
            try {
                nArray[SslConfig.LoadedIdentity.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SslConfig.LoadedIdentity.KEY_MANAGER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SslConfig.LoadedIdentity.KEY_STORE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

