/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import io.intercom.android.nexus.NexusClient;
import io.intercom.android.nexus.NexusConfig;
import io.intercom.android.nexus.NexusEvent;
import io.intercom.android.nexus.NexusListener;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.logger.Logger;
import io.intercom.android.sdk.models.Events.realtime.CreateConversationEvent;
import io.intercom.android.sdk.models.Events.realtime.NewCommentEvent;

public class NexusWrapper
extends NexusClient
implements NexusListener {
    public void connect(NexusConfig config, boolean shouldSendPresence) {
        if (!this.isConnected() && NexusWrapper.isRealTime()) {
            super.connect(config, shouldSendPresence);
            this.addEventListener(this);
        }
    }

    public void disconnect() {
        this.removeEventListener(this);
        super.disconnect();
    }

    public void cycle(NexusConfig config, boolean shouldSendPresence) {
        this.disconnect();
        this.connect(config, shouldSendPresence);
    }

    public void notifyEvent(NexusEvent event) {
        switch (event) {
            case AdminIsTyping: {
                Logger.INTERNAL("realtime", "received " + event.name() + " event");
                Bridge.getBus().post((Object)new AdminIsTypingEvent(event.getAdminId(), event.getConversationId(), event.getAdminName(), event.getAdminAvatarUrl()));
                break;
            }
            case NewComment: {
                Logger.INTERNAL("realtime", "received " + event.name() + " event");
                Bridge.getBus().post((Object)new NewCommentEvent(event.getConversationId(), event.getUserId()));
                break;
            }
            case CreateConversation: {
                Logger.INTERNAL("realtime", "received " + event.name() + " event");
                Bridge.getBus().post((Object)new CreateConversationEvent());
                break;
            }
            default: {
                Logger.INTERNAL("realtime", "unexpected event: " + event.name());
            }
        }
    }

    public void fire(NexusEvent event) {
        if (NexusWrapper.isRealTime()) {
            super.fire(event);
        }
    }

    public void setPresenceHeartbeatEnabled(boolean presenceHeartbeatEnabled) {
        if (NexusWrapper.isRealTime()) {
            super.setPresenceHeartbeatEnabled(presenceHeartbeatEnabled);
        }
    }

    public boolean isConnected() {
        return super.isConnected() && NexusWrapper.isRealTime();
    }

    private static boolean isRealTime() {
        return Bridge.getIdentityStore().getAppConfig().isRealTime();
    }
}

