/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.gcm;

import android.app.IntentService;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.chathead.NotificationsService;
import io.intercom.android.sdk.gcm.GcmBroadcastReceiver;
import io.intercom.android.sdk.gcm.GcmNotificationManager;
import io.intercom.android.sdk.logger.Logger;
import io.intercom.android.sdk.models.PushNotification;

public class GcmIntentService
extends IntentService {
    public static final String ACTION_REMOVE_NOTIFICATION = "intercom_sdk_remove_notification";
    private static final String TAG = "GcmIntentService";
    private GcmNotificationManager gcmNotificationManager;

    public GcmIntentService() {
        super(TAG);
    }

    public void onCreate() {
        super.onCreate();
        this.gcmNotificationManager = new GcmNotificationManager((NotificationManager)this.getSystemService("notification"));
    }

    protected void onHandleIntent(Intent intent) {
        Bridge.init(this.getApplicationContext());
        if (!Bridge.getIdentityStore().userIdentityExists()) {
            this.gcmNotificationManager.killNotifications();
            return;
        }
        if (ACTION_REMOVE_NOTIFICATION.equals(intent.getAction())) {
            this.gcmNotificationManager.killNotifications();
        } else {
            Bundle extras = intent.getExtras();
            if (extras != null && !extras.isEmpty()) {
                Logger.INTERNAL(TAG, "Notification Data Json :" + extras.getString("message"));
                PushNotification notification = new PushNotification(extras);
                if (!notification.getReceiver().isEmpty() && notification.getReceiver().equals("intercom_sdk") && !NotificationsService.isChatheadVisible()) {
                    this.gcmNotificationManager.addNotification(notification);
                    this.gcmNotificationManager.createNotification(GoogleCloudMessaging.getInstance((Context)this).getMessageType(intent), (Context)this);
                    GcmBroadcastReceiver.completeWakefulIntent((Intent)intent);
                }
            }
        }
    }
}

