/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.blocks.models;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;

public class Block
implements Parcelable {
    private String type;
    private String text;
    private String language;
    private String url;
    private String linkUrl;
    private String embedUrl;
    private String trackingUrl;
    private String username;
    private String provider;
    private String id;
    private List<String> items;
    public static final Parcelable.Creator<Block> CREATOR = new Parcelable.Creator<Block>(){

        public Block createFromParcel(Parcel in) {
            return new Block(in);
        }

        public Block[] newArray(int size) {
            return new Block[size];
        }
    };

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLinkUrl() {
        if (this.linkUrl == null) {
            return "";
        }
        return this.linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public String getEmbedUrl() {
        return this.embedUrl;
    }

    public void setEmbedUrl(String embedUrl) {
        this.embedUrl = embedUrl;
    }

    public String getTrackingUrl() {
        return this.trackingUrl;
    }

    public void setTrackingUrl(String trackingUrl) {
        this.trackingUrl = trackingUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getItems() {
        return this.items;
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    public Block() {
        this(new Builder());
    }

    private Block(Builder builder) {
        this.type = builder.type == null ? "" : builder.type;
        this.text = builder.text == null ? "" : builder.text;
        this.language = builder.language == null ? "" : builder.language;
        this.url = builder.url == null ? "" : builder.url;
        this.linkUrl = builder.linkUrl == null ? "" : builder.linkUrl;
        this.embedUrl = builder.embedUrl == null ? "" : builder.embedUrl;
        this.trackingUrl = builder.trackingUrl == null ? "" : builder.trackingUrl;
        this.username = builder.username == null ? "" : builder.username;
        this.provider = builder.provider == null ? "" : builder.provider;
        this.id = builder.id == null ? "" : builder.id;
        this.items = new ArrayList<String>();
        if (builder.items != null) {
            for (String item : builder.items) {
                this.items.add(item == null ? "" : item);
            }
        }
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (o instanceof Block) {
            Block otherBlock = (Block)o;
            if (this.type.equals(otherBlock.type) && this.text.equals(otherBlock.text) && this.language.equals(otherBlock.language) && this.url.equals(otherBlock.url) && this.linkUrl.equals(otherBlock.linkUrl) && this.embedUrl.equals(otherBlock.embedUrl) && this.trackingUrl.equals(otherBlock.trackingUrl) && this.username.equals(otherBlock.username) && this.provider.equals(otherBlock.provider) && this.items.equals(otherBlock.items)) {
                isEqual = true;
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.type.hashCode() + this.text.hashCode() + this.language.hashCode() + this.url.hashCode() + this.linkUrl.hashCode() + this.embedUrl.hashCode() + this.trackingUrl.hashCode() + this.username.hashCode() + this.provider.hashCode() + this.id.hashCode() + this.items.hashCode();
        return result;
    }

    protected Block(Parcel in) {
        this.type = in.readString();
        this.text = in.readString();
        this.language = in.readString();
        this.url = in.readString();
        this.linkUrl = in.readString();
        this.embedUrl = in.readString();
        this.username = in.readString();
        this.provider = in.readString();
        this.id = in.readString();
        if (in.readByte() == 1) {
            this.items = new ArrayList<String>();
            in.readList(this.items, String.class.getClassLoader());
        } else {
            this.items = null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.type);
        dest.writeString(this.text);
        dest.writeString(this.language);
        dest.writeString(this.url);
        dest.writeString(this.linkUrl);
        dest.writeString(this.embedUrl);
        dest.writeString(this.username);
        dest.writeString(this.provider);
        dest.writeString(this.id);
        if (this.items == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.items);
        }
    }

    public static final class Builder {
        private String type;
        private String text;
        private String language;
        private String url;
        private String linkUrl;
        private String embedUrl;
        private String trackingUrl;
        private String username;
        private String provider;
        private String id;
        private List<String> items;

        public Block build() {
            return new Block(this);
        }
    }
}

