/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.gcm;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.gcm.NotificationAvatarUtils;
import io.intercom.android.sdk.gcm.PushNotification;
import io.intercom.android.sdk.gcm.R;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.transforms.RoundTransform;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.Transformation;
import java.util.List;

class GcmNotificationFactory {
    private static final int LARGE_ICON_SIZE_DP = 48;
    private static final String CONVERSATION_URI = "conversation_id=%s";
    private static final String INTERCOM_SDK_GCM = "intercom_sdk_gcm";

    GcmNotificationFactory() {
    }

    Notification createSingleNotification(PushNotification notification, Context context) {
        Uri destination = Uri.parse((String)String.format("intercom_sdk/conversation_id=%s", notification.getConversationId()));
        NotificationCompat.Builder builder = this.getBaseNotificationBuilder(notification.getTitle(context), notification.getMessage(), destination, null, -1, notification.getPriority(), context);
        Bitmap icon = this.generateAvatar(notification, context);
        builder.setLargeIcon(icon);
        builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)notification.getMessage()));
        return builder.build();
    }

    @SuppressLint(value={"PrivateResource"})
    Notification createGroupedNotification(List<PushNotification> notifications, Context context) {
        Uri destination = Uri.parse((String)"intercom_sdk/multiple_notifications");
        CharSequence subtitle = notifications.size() == 1 ? context.getString(R.string.intercom_groupMessage_one) : Phrase.from((Context)context, (int)R.string.intercom_groupMessage_other).put("n", notifications.size()).format();
        NotificationCompat.Builder builder = this.getBaseNotificationBuilder(context.getString(R.string.intercom_groupTitle), subtitle, destination, null, -1, notifications.get(notifications.size() - 1).getPriority(), context);
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        inboxStyle.setBigContentTitle((CharSequence)context.getString(R.string.intercom_groupTitle));
        for (PushNotification notification : notifications) {
            SpannableString spannable = new SpannableString((CharSequence)(notification.getName() + ": " + notification.getMessage()));
            spannable.setSpan((Object)new StyleSpan(1), 0, notification.getName().length(), 33);
            inboxStyle.addLine((CharSequence)spannable);
        }
        builder.setStyle((NotificationCompat.Style)inboxStyle);
        return builder.build();
    }

    Notification createPushOnlyNotification(PushNotification notification, Context context) {
        Uri destination = Uri.parse((String)notification.getUri());
        NotificationCompat.Builder builder = this.getBaseNotificationBuilder(notification.getTitle(context), notification.getMessage(), destination, notification.getPushOnlyConversationId(), notification.getPushOnlyConversationId().hashCode(), notification.getPriority(), context);
        builder.setColor(Injector.get().getAppIdentity().getAppConfig().getBaseColor());
        builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)notification.getMessage()));
        return builder.build();
    }

    private NotificationCompat.Builder getBaseNotificationBuilder(CharSequence title, CharSequence content, Uri destination, @Nullable String pushOnlyConversationId, int requestCode, int priority, Context context) {
        Intent newIntent;
        PackageManager packageManager = context.getPackageManager();
        try {
            newIntent = packageManager.getLaunchIntentForPackage(context.getPackageName());
            if (newIntent == null) {
                throw new PackageManager.NameNotFoundException();
            }
            newIntent.addCategory("android.intent.category.LAUNCHER");
            newIntent.setData(destination);
            newIntent.putExtra("intercom_push_key", INTERCOM_SDK_GCM);
            if (pushOnlyConversationId != null) {
                newIntent.putExtra("push_only_convo_id", pushOnlyConversationId);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            newIntent = new Intent();
        }
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)newIntent, (int)0x10000000);
        NotificationCompat.Builder notification = new NotificationCompat.Builder(context).setSmallIcon(R.drawable.intercom_push_icon).setContentTitle(title).setContentText(content).setAutoCancel(true).setLights(Injector.get().getAppIdentity().getAppConfig().getBaseColor(), 500, 2000).setContentIntent(pendingIntent);
        if (DeviceUtils.hasPermission((Context)context, (String)"android.permission.VIBRATE")) {
            notification.setDefaults(3);
        } else {
            notification.setDefaults(1);
        }
        notification.setPriority(priority);
        return notification;
    }

    private Bitmap generateAvatar(PushNotification notification, Context context) {
        if (TextUtils.isEmpty((CharSequence)notification.getImageUrl()) && !TextUtils.isEmpty((CharSequence)notification.getName())) {
            return NotificationAvatarUtils.getNotificationInitialsBitmap(context, notification.getName());
        }
        BitmapDrawable defaultDrawable = new BitmapDrawable(context.getResources(), NotificationAvatarUtils.getNotificationDefaultBitmap(context));
        try {
            int iconSize = ScreenUtils.convertDpToPixel((float)48.0f, (Context)context);
            return (Bitmap)Glide.with((Context)context.getApplicationContext()).load(notification.getImageUrl()).asBitmap().error((Drawable)defaultDrawable).transform(new Transformation[]{new RoundTransform(context)}).into(iconSize, iconSize).get();
        }
        catch (Exception e) {
            IntercomLogger.d((String)"Failed to retrieve the notification image");
            return defaultDrawable.getBitmap();
        }
    }
}

