/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.gcm;

import android.app.Application;
import android.app.IntentService;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.gcm.GcmBroadcastReceiver;
import io.intercom.android.sdk.gcm.GcmNotificationManager;
import io.intercom.android.sdk.gcm.models.PushNotification;
import io.intercom.android.sdk.lifecycles.Lifecycles;
import io.intercom.android.sdk.logger.IntercomLogger;

public class GcmIntentService
extends IntentService {
    private static final String TAG = "GcmIntentService";
    private GcmNotificationManager gcmNotificationManager;

    public GcmIntentService() {
        super(TAG);
    }

    public void onCreate() {
        super.onCreate();
        this.gcmNotificationManager = new GcmNotificationManager((NotificationManager)this.getSystemService("notification"));
    }

    protected void onHandleIntent(Intent intent) {
        Injector.init((Application)this.getApplication());
        if (!Injector.get().getUserIdentity().identityExists()) {
            this.removeAllNotifications();
            IntercomLogger.i((String)"Can't create GCM message we have no user identity. This can be caused by messages being sent to a logged out user.");
        } else if (intent != null) {
            if ("intercom_sdk_remove_notification".equals(intent.getAction())) {
                if (!this.gcmNotificationManager.getNotifications().isEmpty()) {
                    IntercomLogger.i((String)"Removing Intercom GCM messages.");
                }
                this.removeAllNotifications();
            } else {
                Bundle extras = intent.getExtras();
                if (extras != null && !extras.isEmpty()) {
                    IntercomLogger.internal((String)TAG, (String)("Notification Data Json :" + extras.getString("message")));
                    PushNotification notification = new PushNotification(extras);
                    if (notification.isIntercomPush()) {
                        if (notification.isPushOnly()) {
                            this.gcmNotificationManager.createPushOnlyNotification(notification, (Context)this);
                        } else if (Lifecycles.isAppBackgrounded()) {
                            String messageType = GoogleCloudMessaging.getInstance((Context)this).getMessageType(intent);
                            this.gcmNotificationManager.createNotification(notification, messageType, (Context)this);
                        } else {
                            IntercomLogger.i((String)"Intercom message received but not displayed in notification bar. This happened because the host app was in the foreground.");
                        }
                    } else {
                        IntercomLogger.i((String)"This is not a Intercom GCM message");
                    }
                } else {
                    IntercomLogger.e((String)"The GCM intent contained no data");
                }
            }
        } else {
            IntercomLogger.w((String)"The intent sent to the GCMIntentService was null, we were not able to create your GCM Notification");
        }
        this.completeWakeLock(intent);
    }

    private void removeAllNotifications() {
        this.gcmNotificationManager.killNotifications();
    }

    private void completeWakeLock(Intent intent) {
        if (intent != null) {
            GcmBroadcastReceiver.completeWakefulIntent((Intent)intent);
        }
    }
}

