/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.fcm;

import android.app.NotificationManager;
import android.content.Context;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.fcm.FcmNotificationManager;
import io.intercom.android.sdk.fcm.PushNotification;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import java.util.Map;

public class IntercomFcmMessengerService
extends FirebaseMessagingService {
    private FcmNotificationManager fcmNotificationManager;

    public void onCreate() {
        super.onCreate();
        this.fcmNotificationManager = new FcmNotificationManager((NotificationManager)this.getSystemService("notification"));
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        if (Injector.get().getUserIdentity().identityExists()) {
            if (remoteMessage.getData().size() > 0) {
                Map message = remoteMessage.getData();
                this.sendNotification(message);
            } else {
                IntercomLogger.i((String)"Can't create FCM message because there was no data in the payload");
            }
        } else {
            this.removeAllNotifications();
            IntercomLogger.i((String)"Can't create FCM message because we have no user identity. This can be caused by messages being sent to a logged out user.");
        }
    }

    private void sendNotification(Map<String, String> message) {
        if (message != null && !message.isEmpty()) {
            PushNotification notification = new PushNotification(message);
            if (notification.isIntercomPush()) {
                Context localisedContext = ContextLocaliser.create().createLocalisedContext((Context)this);
                if (notification.isPushOnly()) {
                    Injector.get().getMetricsStore().track(MetricFactory.receivedPushOnlyNotification((String)notification.getPushOnlyConversationId()));
                    this.fcmNotificationManager.createPushOnlyNotification(notification, localisedContext);
                } else if (Injector.get().getLifecycleTracker().isAppBackgrounded()) {
                    Injector.get().getMetricsStore().track(MetricFactory.receivedPushNotification((String)notification.getConversationId()));
                    this.fcmNotificationManager.createNotification(notification, localisedContext);
                } else {
                    IntercomLogger.i((String)"Intercom message received but not displayed in notification bar. This happened because the host app was in the foreground.");
                }
            } else {
                IntercomLogger.i((String)"This is not a Intercom FCM message");
            }
        } else {
            IntercomLogger.e((String)"The FCM intent contained no data");
        }
    }

    private void removeAllNotifications() {
        this.fcmNotificationManager.killNotifications();
    }
}

