/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.squareup.otto.Bus;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.messengercard.CardWebView;
import io.intercom.android.sdk.blocks.messengercard.MessengerCardWebViewPresenter;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.utilities.ColorUtils;

public class MessengerAppCardViewHolder
extends RecyclerView.ViewHolder {
    private final CardWebView webView;
    private final ProgressBar loadingView;
    private final Bus bus;
    private final Provider<AppConfig> appConfigProvider;
    private final Gson gson;
    private final MetricTracker metricTracker;
    private final Activity activity;

    MessengerAppCardViewHolder(View itemView, Bus bus, Provider<AppConfig> appConfigProvider, Gson gson, MetricTracker metricTracker, Activity activity) {
        super(itemView);
        this.webView = MessengerCardWebViewPresenter.createCardWebView(itemView.getContext());
        ((FrameLayout)itemView).addView((View)this.webView);
        this.webView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, this.webView.getResources().getDimensionPixelSize(R.dimen.intercom_home_app_card_min_height)));
        this.loadingView = (ProgressBar)itemView.findViewById(R.id.loading_view);
        this.bus = bus;
        this.appConfigProvider = appConfigProvider;
        this.gson = gson;
        this.metricTracker = metricTracker;
        this.activity = activity;
        FrameLayout rootLayout = (FrameLayout)itemView.findViewById(R.id.messenger_card_layout);
        ColorUtils.updateInnerBorderColor(appConfigProvider.get(), (View)rootLayout);
    }

    public void bindCard(String cardUrl) {
        int primaryColor = ColorUtils.primaryOrDarkColor(this.webView.getContext(), this.appConfigProvider.get());
        MessengerCardWebViewPresenter presenter = new MessengerCardWebViewPresenter(this.webView, (View)this.loadingView, cardUrl, this.bus, primaryColor, this.gson, this.metricTracker, this.webView.getContext().getCacheDir(), "", true, this.activity);
        presenter.setUpWebView();
        if (!TextUtils.isEmpty((CharSequence)cardUrl)) {
            this.webView.loadUrl(cardUrl);
        }
    }
}

