/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Application;
import android.app.TaskStackBuilder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.InvalidIntercom;
import io.intercom.android.sdk.LateInitializationPreparer;
import io.intercom.android.sdk.RealIntercom;
import io.intercom.android.sdk.UnreadConversationCountListener;
import io.intercom.android.sdk.UserAttributes;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.utilities.ValidatorUtil;
import java.util.Map;

public abstract class Intercom {
    public static final Visibility VISIBLE = Visibility.VISIBLE;
    public static final Visibility GONE = Visibility.GONE;
    public static final String PUSH_RECEIVER = "intercom_sdk";
    private static final Twig TWIG = LumberMill.getLogger();
    @Nullable
    private static Intercom instance;

    public static synchronized void initialize(Application application, String apiKey, String appId) {
        if (instance != null) {
            TWIG.i("Intercom has already been initialized", new Object[0]);
            return;
        }
        if (ValidatorUtil.isValidConstructorParams(application, apiKey, appId)) {
            TWIG.i("Intercom has already been initialized", new Object[0]);
            instance = RealIntercom.create(application, apiKey, appId);
            LateInitializationPreparer.getInstance().handlePastLifecycleEvents(application, Injector.get());
        } else {
            instance = new InvalidIntercom();
        }
    }

    public static synchronized void registerForLaterInitialisation(@NonNull Application application) {
        if (instance != null) {
            TWIG.i("Intercom has already been initialized", new Object[0]);
            return;
        }
        if (application == null) {
            throw new NullPointerException("Cannot call registerForLaterInitialisation() with a null Application");
        }
        LateInitializationPreparer.getInstance().register(application);
    }

    public static void unregisterForLateInitialisation(@NonNull Application application) {
        if (application == null) {
            throw new NullPointerException("Cannot call unregisterForLateInitialisation() with a null Application");
        }
        LateInitializationPreparer.getInstance().unregister(application);
    }

    public static synchronized Intercom client() {
        if (instance == null) {
            throw new IllegalStateException("Please call Intercom.initialize() before requesting the client.");
        }
        return instance;
    }

    public abstract void registerUnidentifiedUser();

    public abstract void registerIdentifiedUser(Registration var1);

    public abstract void setUserHash(String var1);

    public abstract void updateUser(UserAttributes var1);

    public abstract void logEvent(String var1);

    public abstract void logEvent(String var1, Map<String, ?> var2);

    public abstract void displayMessenger();

    public abstract void displayMessageComposer();

    public abstract void displayMessageComposer(String var1);

    @Deprecated
    public abstract void displayConversationsList();

    public abstract void displayHelpCenter();

    public abstract void displayCarousel(String var1);

    public abstract void setBottomPadding(int var1);

    public abstract void setInAppMessageVisibility(Visibility var1);

    public abstract void setLauncherVisibility(Visibility var1);

    public abstract void hideMessenger();

    public abstract void handlePushMessage();

    public abstract void handlePushMessage(TaskStackBuilder var1);

    @Deprecated
    public abstract void reset();

    public abstract void logout();

    public abstract int getUnreadConversationCount();

    public abstract void addUnreadConversationCountListener(@NonNull UnreadConversationCountListener var1);

    public abstract void removeUnreadConversationCountListener(UnreadConversationCountListener var1);

    public static void setLogLevel(@LogLevel int logLevel) {
        LumberMill.setLogLevel(logLevel);
    }

    public abstract void displayArticle(@NonNull String var1);

    public static @interface LogLevel {
        public static final int VERBOSE = 2;
        public static final int DEBUG = 3;
        public static final int INFO = 4;
        public static final int WARN = 5;
        public static final int ERROR = 6;
        public static final int ASSERT = 7;
        public static final int DISABLED = 8;
    }

    public static enum Visibility {
        GONE,
        VISIBLE;

    }
}

