/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.blocks.lib.models.Author;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.commons.utilities.CollectionUtils;
import io.intercom.android.sdk.models.AutoValue_Link;
import io.intercom.android.sdk.models.Card;
import io.intercom.android.sdk.models.ReactionReply;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@AutoValue
public abstract class Link {
    public static final String ARTICLE_TYPE = "educate.article";
    public static final String SUGGESTION_TYPE = "educate.suggestion";
    public static final String HELP_CENTER_TYPE = "educate.help_center";

    public abstract String getId();

    public abstract Card getCard();

    public abstract List<Block> getBlocks();

    public abstract ReactionReply getReactionReply();

    public abstract long getCreatedAt();

    public abstract long getUpdatedAt();

    public String getTitle() {
        return this.getCard().getTitle();
    }

    public String getText() {
        return this.getCard().getText();
    }

    public String getType() {
        return this.getCard().getType();
    }

    public String getDescription() {
        return this.getCard().getDescription();
    }

    public Author getAuthor() {
        return this.getCard().getAuthor();
    }

    public static final class Builder {
        @Nullable
        String id;
        @Nullable
        Card.Builder card;
        @Nullable
        List<Block.Builder> blocks;
        @Nullable
        ReactionReply.Builder reactions_reply;
        long created_at;
        long updated_at;

        public Link build() {
            String id2 = this.id == null ? UUID.randomUUID().toString() : this.id;
            ArrayList<Block> blocks = new ArrayList<Block>(CollectionUtils.capacityFor(this.blocks));
            if (this.blocks != null) {
                for (Block.Builder blockBuilder : this.blocks) {
                    if (blockBuilder == null) continue;
                    blocks.add(blockBuilder.build());
                }
            }
            ReactionReply reactionReply = this.reactions_reply == null ? ReactionReply.NULL : this.reactions_reply.build();
            Card card = this.card == null ? new Card.Builder().build() : this.card.build();
            return new AutoValue_Link(id2, card, blocks, reactionReply, this.created_at, this.updated_at);
        }
    }
}

