/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.ResourceDecoder;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.util.Util;
import java.io.IOException;

public final class UnitBitmapDecoder
implements ResourceDecoder<Bitmap, Bitmap> {
    @Override
    public boolean handles(Bitmap source2, Options options) throws IOException {
        return true;
    }

    @Override
    public Resource<Bitmap> decode(Bitmap source2, int width, int height, Options options) throws IOException {
        return new NonOwnedBitmapResource(source2);
    }

    private static final class NonOwnedBitmapResource
    implements Resource<Bitmap> {
        private final Bitmap bitmap;

        NonOwnedBitmapResource(Bitmap bitmap) {
            this.bitmap = bitmap;
        }

        @Override
        public Class<Bitmap> getResourceClass() {
            return Bitmap.class;
        }

        @Override
        public Bitmap get() {
            return this.bitmap;
        }

        @Override
        public int getSize() {
            return Util.getBitmapByteSize(this.bitmap);
        }

        @Override
        public void recycle() {
        }
    }
}

