/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.ButtonClickListener;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.lib.BlockAlignment;
import io.intercom.android.sdk.blocks.lib.interfaces.ButtonBlock;
import io.intercom.android.sdk.blocks.lib.interfaces.FacebookBlock;
import io.intercom.android.sdk.blocks.lib.interfaces.TwitterBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.blocks.views.ParagraphView;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.views.ButtonSelector;

class Button
implements ButtonBlock,
FacebookBlock,
TwitterBlock {
    private static final int FACEBOOK_LOGO_PADDING_LEFT_DP = 20;
    private static final int TWITTER_LOGO_PADDING_LEFT_DP = 16;
    private final StyleType style;
    private final Provider<AppConfig> appConfigProvider;
    @Nullable
    private final ButtonClickListener buttonClickListener;

    public Button(StyleType style2, Provider<AppConfig> appConfigProvider, @Nullable ButtonClickListener buttonClickListener) {
        this.style = style2;
        this.appConfigProvider = appConfigProvider;
        this.buttonClickListener = buttonClickListener;
    }

    @Override
    public View addButton(String text, String url, BlockAlignment alignment, BlockMetadata blockMetadata, ViewGroup parent) {
        Context context = parent.getContext();
        Object view = this.style == StyleType.NOTE || this.style == StyleType.ARTICLE || this.style == StyleType.POST || this.style == StyleType.CONTAINER_CARD ? this.createFullWidthButton(context, text) : this.createDefaultTextView(context, text, alignment);
        return this.setButtonDefaults((View)view, url, alignment, blockMetadata.isLastObject());
    }

    @Override
    public View addFacebookButton(String url, BlockAlignment blockAlignment, BlockMetadata blockMetadata, ViewGroup parent) {
        View view;
        Context context = parent.getContext();
        String text = context.getString(R.string.intercom_facebook_like);
        if (this.style == StyleType.NOTE || this.style == StyleType.ARTICLE || this.style == StyleType.POST || this.style == StyleType.CONTAINER_CARD) {
            int paddingLeft = ScreenUtils.dpToPx((float)20.0f, (Context)context);
            view = this.createButtonWithLogo(context, text, paddingLeft, R.drawable.intercom_icn_fb);
        } else {
            view = this.createDefaultTextView(context, text, blockAlignment);
        }
        return this.setButtonDefaults(view, url, blockAlignment, blockMetadata.isLastObject());
    }

    @Override
    public View addTwitterButton(String url, BlockAlignment blockAlignment, BlockMetadata blockMetadata, ViewGroup parent) {
        View view;
        Context context = parent.getContext();
        String text = context.getString(R.string.intercom_twitter_follow);
        if (this.style == StyleType.NOTE || this.style == StyleType.ARTICLE || this.style == StyleType.POST || this.style == StyleType.CONTAINER_CARD) {
            int paddingLeft = ScreenUtils.dpToPx((float)16.0f, (Context)context);
            view = this.createButtonWithLogo(context, text, paddingLeft, R.drawable.intercom_icn_twitter);
        } else {
            view = this.createDefaultTextView(context, text, blockAlignment);
        }
        return this.setButtonDefaults(view, url, blockAlignment, blockMetadata.isLastObject());
    }

    private View setButtonDefaults(View view, final String url, BlockAlignment alignment, boolean isLastObject) {
        if (this.buttonClickListener != null && this.buttonClickListener.shouldHandleClicks()) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Button.this.buttonClickListener.onButtonClicked(view, url);
                }
            });
        }
        BlockUtils.setLayoutMarginsAndGravity(view, alignment.getGravity(), isLastObject);
        return view;
    }

    private TextView createDefaultTextView(Context context, String text, BlockAlignment alignment) {
        AppConfig appConfig = this.appConfigProvider.get();
        ParagraphView textView = new ParagraphView(context, this.style, alignment, appConfig);
        textView.setTextColor(appConfig.getPrimaryColor());
        textView.setPaintFlags(textView.getPaintFlags() | 8);
        textView.setGravity(alignment.getGravity());
        textView.setText(text);
        return textView;
    }

    private android.widget.Button createFullWidthButton(Context context, String text) {
        AppConfig appConfig = this.appConfigProvider.get();
        android.widget.Button button = new android.widget.Button(context);
        button.setTextSize(16.0f);
        button.setTextColor(ColorUtils.whiteOrDarkColor(context, appConfig.primaryColorRenderDarkText()));
        button.setAllCaps(false);
        button.setGravity(17);
        button.setText((CharSequence)text);
        BlockUtils.createLayoutParams((View)button, -1, -2);
        BlockUtils.setDefaultMarginBottom((View)button);
        int primaryColor = appConfig.getPrimaryColor();
        BackgroundUtils.setBackground((View)button, (Drawable)new ButtonSelector(context, R.drawable.intercom_border, primaryColor));
        FontUtils.setRobotoMediumTypeface((TextView)button);
        return button;
    }

    private View createButtonWithLogo(Context context, String text, int paddingLeft, @DrawableRes int logoResource) {
        FrameLayout frame = new FrameLayout(context);
        BlockUtils.createLayoutParams((View)frame, -1, ScreenUtils.dpToPx((float)44.0f, (Context)context));
        BlockUtils.setDefaultMarginBottom((View)frame);
        int primaryColor = this.appConfigProvider.get().getPrimaryColor();
        BackgroundUtils.setBackground((View)frame, (Drawable)new ButtonSelector(context, R.drawable.intercom_border, primaryColor));
        ((LinearLayout.LayoutParams)frame.getLayoutParams()).gravity = 17;
        ImageView logo = new ImageView(context);
        BlockUtils.createLayoutParams((View)logo, -2, -1);
        logo.setImageResource(logoResource);
        logo.setBackgroundResource(R.color.intercom_full_transparent_full_black);
        logo.setPadding(paddingLeft, 0, 0, 0);
        ((LinearLayout.LayoutParams)logo.getLayoutParams()).gravity = 19;
        TextView textView = new TextView(context);
        BlockUtils.createLayoutParams((View)textView, -1, -1);
        textView.setText((CharSequence)text);
        textView.setTextSize(16.0f);
        textView.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_white));
        textView.setBackgroundResource(R.color.intercom_full_transparent_full_black);
        textView.setGravity(17);
        FontUtils.setRobotoMediumTypeface(textView);
        frame.addView((View)logo);
        frame.addView((View)textView);
        return frame;
    }
}

