/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.errorreporting;

import android.content.Context;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.errorreporting.ErrorReportStore;
import io.intercom.android.sdk.errorreporting.ExceptionParser;
import io.intercom.android.sdk.errorreporting.IntercomExceptionHandler;
import io.intercom.com.google.gson.Gson;

public class ErrorReporter {
    private final ErrorReportStore reportStore;
    private final Provider<Api> apiProvider;
    private final ExceptionParser exceptionParser;

    public static ErrorReporter create(Context androidContext, Gson gson, Provider<Api> apiProvider) {
        ErrorReportStore reportStore = ErrorReportStore.create(androidContext.getApplicationContext(), gson);
        return new ErrorReporter(reportStore, apiProvider, new ExceptionParser());
    }

    ErrorReporter(ErrorReportStore reportStore, Provider<Api> apiProvider, ExceptionParser exceptionParser) {
        this.reportStore = reportStore;
        this.apiProvider = apiProvider;
        this.exceptionParser = exceptionParser;
    }

    void saveReport(Throwable exception) {
        if (this.exceptionParser.containsIntercomMethod(exception)) {
            this.reportStore.saveToDisk(this.exceptionParser.createReportFrom(exception));
        }
    }

    public void sendSavedReport() {
        this.reportStore.sendSavedReport(this.apiProvider);
    }

    public void enableExceptionHandler() {
        IntercomExceptionHandler.enable(this);
    }

    public void disableExceptionHandler() {
        IntercomExceptionHandler.disable();
        this.reportStore.deleteFromDisk();
    }
}

