/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatTextView;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.lib.BlockAlignment;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;

@SuppressLint(value={"ViewConstructor"})
public class ParagraphView
extends AppCompatTextView {
    private static final int POST_BOTTOM_MARGIN_DP = 24;
    private static final int POST_LINE_SPACING_DP = 4;
    private static final int CAROUSEL_LINE_SPACING_DP = 8;
    private static final int DEFAULT_LINE_SPACING_DP = 2;
    private final Context context;
    private final StyleType style;
    private final BlockAlignment alignment;
    private final AppConfig appConfig;
    private final BlockMetadata blockMetadata;

    public ParagraphView(Context context, StyleType style2, BlockAlignment alignment, AppConfig appConfig, BlockMetadata blockMetadata) {
        super(context);
        this.context = context;
        this.style = style2;
        this.alignment = alignment;
        this.appConfig = appConfig;
        this.blockMetadata = blockMetadata;
        this.applyParagraphStyle();
    }

    public ParagraphView(Context context, StyleType style2, BlockAlignment alignment, AppConfig appConfig) {
        this(context, style2, alignment, appConfig, BlockMetadata.NULL);
    }

    private void applyParagraphStyle() {
        BlockUtils.createLayoutParams((View)this, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)this);
        this.setLineSpacing(ScreenUtils.dpToPx((float)2.0f, (Context)this.context), 1.0f);
        this.setTextSize(16.0f);
        this.setTextIsSelectable(false);
        this.setEllipsize(TextUtils.TruncateAt.END);
        this.setScrollContainer(false);
        this.setFocusable(false);
        this.setClickable(false);
        this.setLongClickable(false);
        this.setGravity(this.alignment.getGravity());
        this.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
        int primaryColor = this.appConfig.getPrimaryColor();
        switch (this.style) {
            case ADMIN: {
                this.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.intercom_grey_800));
                this.setLinkTextColor(primaryColor);
                break;
            }
            case ARTICLE: {
                this.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.intercom_grey_700));
                this.setLinkTextColor(ColorUtils.primaryOrDarkColor(this.context, this.appConfig));
                break;
            }
            case NOTE: 
            case CONTAINER_CARD: {
                this.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.intercom_grey_700));
                this.setLinkTextColor(primaryColor);
                break;
            }
            case POST: {
                params.bottomMargin = ScreenUtils.dpToPx((float)24.0f, (Context)this.context);
                this.setLineSpacing(ScreenUtils.dpToPx((float)4.0f, (Context)this.context), 1.0f);
                this.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.intercom_white));
                this.setLinkTextColor(ColorUtils.lightenColor(primaryColor));
                break;
            }
            case CHAT_FULL: {
                this.setMovementMethod(null);
                this.setTextSize(14.0f);
                this.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.intercom_grey_600));
                this.setLinkTextColor(primaryColor);
                break;
            }
            case CAROUSEL: {
                this.setTextSize(20.0f);
                this.setLineSpacing(ScreenUtils.dpToPx((float)8.0f, (Context)this.context), 1.0f);
                String textColor = this.blockMetadata.getAppearance().getTextColor();
                if (textColor.isEmpty()) break;
                int color2 = Color.parseColor((String)textColor);
                this.setTextColor(color2);
                this.setLinkTextColor(color2);
                break;
            }
            default: {
                this.setIncludeFontPadding(false);
                ColorUtils.setTextColorWhiteOrDark((TextView)this, this.appConfig.primaryColorRenderDarkText());
            }
        }
    }
}

