/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.lib.models;

import android.support.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.blocks.lib.models.AutoValue_BlockMetadata;
import io.intercom.android.sdk.models.carousel.Appearance;
import io.intercom.android.sdk.utilities.NullSafety;

@AutoValue
public abstract class BlockMetadata {
    public static BlockMetadata NULL = new Builder().build();

    static BlockMetadata create(boolean isFirst, boolean isLast, Appearance appearance) {
        return new AutoValue_BlockMetadata(isFirst, isLast, appearance);
    }

    public abstract boolean isFirstObject();

    public abstract boolean isLastObject();

    public abstract Appearance getAppearance();

    public boolean isSingleObject() {
        return this.isFirstObject() && this.isLastObject();
    }

    public static final class Builder {
        @Nullable
        Boolean isFirstObject;
        @Nullable
        Boolean isLastObject;
        @Nullable
        Appearance.Builder appearance;

        public Builder isFirstObject(Boolean isFirst) {
            this.isFirstObject = isFirst;
            return this;
        }

        public Builder isLastObject(Boolean isLast) {
            this.isLastObject = isLast;
            return this;
        }

        public Builder withAppearance(Appearance.Builder appearance) {
            this.appearance = appearance;
            return this;
        }

        public BlockMetadata build() {
            Appearance appearance = this.appearance == null ? Appearance.NULL : this.appearance.build();
            return BlockMetadata.create(NullSafety.valueOrDefault(this.isFirstObject, false), NullSafety.valueOrDefault(this.isLastObject, false), appearance);
        }
    }
}

