/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.constraint.ConstraintLayout;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.carousel.CarouselListener;
import io.intercom.android.sdk.carousel.CarouselPresenter;
import io.intercom.android.sdk.carousel.CarouselScreenFragment;
import io.intercom.android.sdk.carousel.CarouselScreenPagerAdapter;
import io.intercom.android.sdk.carousel.PermissionManager;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.carousel.Carousel;
import io.intercom.android.sdk.models.carousel.CarouselScreen;
import io.intercom.android.sdk.models.carousel.ScreenAction;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.IntentUtils;
import io.intercom.com.squareup.otto.Bus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IntercomCarouselActivity
extends IntercomBaseActivity
implements ViewPager.OnPageChangeListener,
View.OnClickListener,
CarouselListener {
    private static final int PERMISSION_REQUEST_CODE = 12306;
    @VisibleForTesting
    ViewPager viewPager;
    private View closeBackground;
    private ImageButton closeButton;
    private ConstraintLayout closeButtonContainer;
    @VisibleForTesting
    LinearLayout navigationDotsLayout;
    @VisibleForTesting
    CarouselScreenPagerAdapter adapter;
    @VisibleForTesting
    CarouselPresenter carouselPresenter;
    @VisibleForTesting
    Bus bus;
    @VisibleForTesting
    PermissionManager permissionManager;
    @VisibleForTesting
    MetricTracker metricTracker;
    @VisibleForTesting
    Provider<AppConfig> appConfigProvider;
    @VisibleForTesting
    boolean isLastScreenViewed = false;
    @VisibleForTesting
    int numberOfScreensSeen = 0;
    @VisibleForTesting
    ScreenAction currentPermissionAction = ScreenAction.NULL;
    @VisibleForTesting
    boolean sentToSettings = false;
    @VisibleForTesting
    String currentScreenId = "";

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_carousel);
        this.viewPager = (ViewPager)this.findViewById(R.id.intercom_view_pager);
        this.closeBackground = this.findViewById(R.id.intercom_close_background);
        this.closeButton = (ImageButton)this.findViewById(R.id.intercom_close);
        this.closeButtonContainer = (ConstraintLayout)this.findViewById(R.id.intercom_carousel_close_container);
        this.navigationDotsLayout = (LinearLayout)this.findViewById(R.id.intercom_page_navigation_layout);
        this.closeButtonContainer.setOnClickListener((View.OnClickListener)this);
        Injector injector = Injector.get();
        this.bus = injector.getBus();
        this.appConfigProvider = injector.getAppConfigProvider();
        this.permissionManager = new PermissionManager((Activity)this);
        this.metricTracker = injector.getMetricTracker();
        this.carouselPresenter = new CarouselPresenter(injector.getStore(), injector.getApi(), this.metricTracker, this.permissionManager);
        Carousel carousel = this.carouselPresenter.getCarousel();
        List<CarouselScreen> carouselScreens = carousel.getScreens();
        if (carouselScreens.isEmpty()) {
            this.finish();
        }
        this.closeButtonContainer.setVisibility(carousel.isDismissible() ? 0 : 8);
        this.showOrHideNavigationDots(carouselScreens);
        this.setupViewPagerWithScreens(carouselScreens);
        this.carouselPresenter.recordOpenMetric();
    }

    public void onBackPressed() {
        if (this.carouselPresenter.getCarousel().isDismissible()) {
            this.dismissCarousel("from_android_back_button");
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 12306) {
            this.carouselPresenter.recordPermissionRequestedMetric(this.currentPermissionAction.getType(), grantResults, this.currentScreenId);
            if (this.permissionManager.anyPermissionPermanentlyDeniedInResult(permissions, grantResults)) {
                this.showGoToSettingsDialog();
            } else if (this.permissionManager.permissionsGranted(Arrays.asList(permissions))) {
                this.selectNextScreenWithDelay();
            } else {
                this.selectNextScreen("from_permission");
            }
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.sentToSettings) {
            this.sentToSettings = false;
            this.carouselPresenter.recordSentToPermissionSettingsMetric(this.currentPermissionAction, this.currentScreenId);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        List<CarouselScreen> screens = this.carouselPresenter.getCarousel().getScreens();
        int numberOfScreens = screens.size();
        if (numberOfScreens > position) {
            CarouselScreen selectedScreen = screens.get(position);
            this.currentPermissionAction = selectedScreen.getPermissionAction();
            this.currentScreenId = selectedScreen.getId();
            boolean isColorLight = ColorUtils.isColorLight(selectedScreen.getBackgroundColor());
            this.renderNavigationDots(this.adapter.getCount(), isColorLight, position);
            this.updateCloseButtonColor(isColorLight);
            if (position >= this.numberOfScreensSeen) {
                this.carouselPresenter.recordScreenSeenStats(selectedScreen.getId());
                this.numberOfScreensSeen = position + 1;
            }
            if (position + 1 == numberOfScreens) {
                this.isLastScreenViewed = true;
            }
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    public void onClick(View view) {
        this.dismissCarousel("from_close_button");
    }

    @Override
    public void dismissCarousel(String context) {
        this.carouselPresenter.resetPersistedCarousel();
        this.carouselPresenter.recordDismissedOrCompletedStats(this.isLastScreenViewed);
        this.carouselPresenter.recordDismissedOrCompletedMetric(context, this.isLastScreenViewed, this.numberOfScreensSeen);
        this.finish();
    }

    @Override
    public void selectNextScreen(String dismissContext) {
        int nextItemPosition = this.viewPager.getCurrentItem() + 1;
        if (nextItemPosition < this.adapter.getCount()) {
            this.viewPager.setCurrentItem(nextItemPosition);
        } else {
            this.dismissCarousel(dismissContext);
        }
    }

    @Override
    public void requestPermissions(ScreenAction screenAction) {
        List<String> permissions = screenAction.getValidPermissions(this.permissionManager);
        if (!permissions.isEmpty()) {
            String[] permissionsArray = permissions.toArray(new String[0]);
            ActivityCompat.requestPermissions((Activity)this, (String[])permissionsArray, (int)12306);
        }
    }

    @Override
    public void openLink(String link) {
        this.dismissCarousel("from_cta");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
        intent.setFlags(0x10000000);
        IntentUtils.safelyOpenIntent((Context)this, intent);
    }

    @Override
    public void startChat() {
        this.dismissCarousel("from_cta");
        if (this.appConfigProvider.get().isInboundMessages()) {
            this.startActivity(IntercomMessengerActivity.openComposer((Context)this, ""));
        }
    }

    @Override
    public void skipPermissionScreen() {
        this.metricTracker.skippedPermission(this.currentPermissionAction.getType(), this.carouselPresenter.getCarousel().getInstanceId());
        this.selectNextScreen("from_permission_skipped");
    }

    @Override
    public void trackActionButtonTappedStats() {
        this.carouselPresenter.recordActionButtonTappedStats(this.currentScreenId);
    }

    private void setupViewPagerWithScreens(List<CarouselScreen> screens) {
        ArrayList<CarouselScreenFragment> fragments = new ArrayList<CarouselScreenFragment>(screens.size());
        for (CarouselScreen screen : screens) {
            fragments.add(CarouselScreenFragment.newInstance(screen));
        }
        this.adapter = new CarouselScreenPagerAdapter(this.getSupportFragmentManager(), fragments);
        this.viewPager.setAdapter((PagerAdapter)this.adapter);
        this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.onPageSelected(0);
    }

    @VisibleForTesting
    void showOrHideNavigationDots(List<CarouselScreen> screens) {
        this.navigationDotsLayout.setVisibility(screens.size() > 1 ? 0 : 8);
    }

    @VisibleForTesting
    void renderNavigationDots(int screenCount, boolean isColorLight, int selectedPosition) {
        this.navigationDotsLayout.removeAllViews();
        int resource = isColorLight ? R.drawable.intercom_tab_dot_selector_dark : R.drawable.intercom_tab_dot_selector_light;
        for (int position = 0; position < screenCount; ++position) {
            View dotView = new View((Context)this);
            int dotSize = ScreenUtils.dpToPx((float)16.0f, (Context)this);
            dotView.setLayoutParams(new ViewGroup.LayoutParams(dotSize, dotSize));
            dotView.setBackgroundResource(resource);
            this.navigationDotsLayout.addView(dotView);
            if (position != selectedPosition) continue;
            dotView.setSelected(true);
        }
    }

    private void updateCloseButtonColor(boolean isColorLight) {
        int colorResource = isColorLight ? R.color.intercom_carousel_grey : R.color.intercom_white;
        int color2 = ContextCompat.getColor((Context)this, (int)colorResource);
        Drawable background = this.closeBackground.getBackground();
        background.setTint(color2);
        Drawable icon = this.closeButton.getDrawable();
        icon.setTint(color2);
    }

    @VisibleForTesting
    void goToSettings() {
        this.sentToSettings = true;
        Uri uri = Uri.fromParts((String)"package", (String)this.getPackageName(), null);
        this.startActivity(new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", uri));
    }

    @VisibleForTesting
    void showGoToSettingsDialog() {
        AlertDialog dialog = new AlertDialog.Builder((Context)this).setTitle(R.string.intercom_permission_denied).setMessage(R.string.intercom_go_to_device_settings).setPositiveButton(R.string.intercom_app_settings, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                IntercomCarouselActivity.this.goToSettings();
            }
        }).setNegativeButton(R.string.intercom_not_now, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                IntercomCarouselActivity.this.skipPermissionScreen();
            }
        }).setCancelable(false).show();
        int buttonColor = ColorUtils.primaryOrDarkColor((Context)this, this.appConfigProvider.get());
        dialog.getButton(-2).setTextColor(buttonColor);
        dialog.getButton(-1).setTextColor(buttonColor);
    }

    @VisibleForTesting
    void selectNextScreenWithDelay() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                IntercomCarouselActivity.this.selectNextScreen("from_permission");
            }
        }, 1000L);
    }
}

