/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.lib;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.intercom.android.sdk.blocks.lib.BlockTypeNotImplementedException;
import io.intercom.android.sdk.blocks.lib.BlocksViewHolder;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.twig.Twig;
import java.util.List;

public class Blocks {
    private final LayoutInflater inflater;
    private final Twig twig;

    public Blocks(Context context, Twig twig) {
        this.inflater = LayoutInflater.from((Context)context);
        this.twig = twig;
    }

    public LinearLayout createBlocks(List<Block> body, BlocksViewHolder viewHolder) {
        LinearLayout layout2 = (LinearLayout)this.inflater.inflate(viewHolder.getLayout(), null);
        if (body != null) {
            for (int i = 0; i < body.size(); ++i) {
                Block block = body.get(i);
                boolean isFirstObject = i == 0;
                boolean isLastObject = i == body.size() - 1;
                try {
                    View view = block.getType().getView(viewHolder, block, (ViewGroup)layout2, isFirstObject, isLastObject);
                    layout2.addView(view);
                    continue;
                }
                catch (BlockTypeNotImplementedException e) {
                    this.twig.e((Throwable)e, "Error creating view for block with type %s ", new Object[]{block.getType()});
                }
            }
        }
        return layout2;
    }
}

