/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;

public class IntercomPushManager {
    private static final String PREFS_SENDER_ID = "intercom_sender_id";
    public static final String MULTIPLE_NOTIFICATIONS = "multiple_notifications";
    public static final String PUSH_ONLY_CONVO_ID = "push_only_convo_id";
    public static final String PUSH_ONLY_INSTANCE_ID = "push_only_instance_id";
    public static final String INTERCOM_PUSH_KEY = "intercom_push_key";
    public static final String HOST_APP_INTENT = "host_app_intent";
    public static final String INTERCOM_PUSH_PATH = "intercom_push_notification_path";
    private static final Twig TWIG = LumberMill.getLogger();

    public static IntercomPushIntegrationType getInstalledModuleType() {
        IntercomPushIntegrationType integrationType = IntercomPushIntegrationType.NONE;
        if (IntercomPushManager.fcmModuleInstalled()) {
            TWIG.internal("FCM is installed");
            integrationType = IntercomPushIntegrationType.FCM;
        }
        return integrationType;
    }

    private static boolean fcmModuleInstalled() {
        return IntercomPushManager.getFcmServiceClass() != null;
    }

    public static void cacheSenderId(Context context, String senderId) {
        SharedPreferences prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        prefs.edit().putString(PREFS_SENDER_ID, senderId).apply();
    }

    @Nullable
    private static Class getFcmServiceClass() {
        try {
            return Class.forName("io.intercom.android.sdk.fcm.IntercomFcmMessengerService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static enum IntercomPushIntegrationType {
        FCM,
        NONE;

    }
}

