/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.messengercard;

import android.animation.LayoutTransition;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.MessengerCardBlock;
import io.intercom.android.sdk.blocks.messengercard.CardWebView;
import io.intercom.android.sdk.blocks.messengercard.MessengerCardWebViewPresenter;
import io.intercom.android.sdk.blocks.views.ParagraphView;
import io.intercom.android.sdk.commons.utilities.HtmlCompat;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.com.google.gson.Gson;
import io.intercom.com.squareup.otto.Bus;

public class MessengerCard
implements MessengerCardBlock {
    private final Provider<AppConfig> appConfigProvider;
    private final Gson gson;
    private final Bus bus;
    private final MetricTracker metricTracker;
    private final String conversationId;
    private final StyleType styleType;
    private final Activity activity;

    public MessengerCard(Provider<AppConfig> appConfigProvider, Gson gson, Bus bus, MetricTracker metricTracker, String conversationId, StyleType styleType, Activity activity) {
        this.appConfigProvider = appConfigProvider;
        this.gson = gson;
        this.bus = bus;
        this.metricTracker = metricTracker;
        this.conversationId = conversationId;
        this.styleType = styleType;
        this.activity = activity;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public View addCard(String text, String fallbackUrl, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        if (TextUtils.isEmpty((CharSequence)fallbackUrl)) {
            return this.textFallback(text, parent);
        }
        Context context = parent.getContext();
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        FrameLayout rootLayout = (FrameLayout)layoutInflater.inflate(R.layout.intercom_messenger_card_block, parent, false);
        if (Build.VERSION.SDK_INT >= 16) {
            LayoutTransition layoutTransition = rootLayout.getLayoutTransition();
            layoutTransition.enableTransitionType(4);
        }
        this.removeShadowAndMargin(rootLayout);
        ColorUtils.updateInnerBorderColor(this.appConfigProvider.get(), (View)rootLayout);
        ProgressBar loadingView = (ProgressBar)rootLayout.findViewById(R.id.loading_view);
        CardWebView webView = MessengerCardWebViewPresenter.createCardWebView(context);
        rootLayout.addView((View)webView);
        MessengerCardWebViewPresenter presenter = new MessengerCardWebViewPresenter(webView, (View)loadingView, fallbackUrl, this.bus, this.appConfigProvider.get().getPrimaryColor(), this.gson, this.metricTracker, context.getCacheDir(), this.conversationId, false, this.activity);
        presenter.setUpWebView();
        webView.loadUrl(fallbackUrl);
        return rootLayout;
    }

    private View textFallback(String text, ViewGroup parent) {
        ParagraphView textView = new ParagraphView(parent.getContext(), StyleType.ADMIN, BlockAlignment.LEFT, this.appConfigProvider.get());
        textView.setText((CharSequence)HtmlCompat.fromHtml((String)text));
        return textView;
    }

    private void removeShadowAndMargin(FrameLayout rootLayout) {
        if (this.isWithinInAppMessage()) {
            if (Build.VERSION.SDK_INT >= 21) {
                rootLayout.setElevation(0.0f);
            }
            try {
                LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)rootLayout.getLayoutParams();
                params.setMargins(0, params.topMargin, 0, params.bottomMargin);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private boolean isWithinInAppMessage() {
        return this.styleType.equals((Object)StyleType.NOTE) || this.styleType.equals((Object)StyleType.POST) || this.styleType.equals((Object)StyleType.CONTAINER_CARD) || this.styleType.equals((Object)StyleType.CHAT_FULL);
    }
}

