/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.activities.ConversationReactionListener;
import io.intercom.android.sdk.activities.IntercomPostActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.BlockFactory;
import io.intercom.android.sdk.blocks.BlockType;
import io.intercom.android.sdk.blocks.Blocks;
import io.intercom.android.sdk.blocks.logic.TextSplittingStrategy;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.blocks.models.BlockAttachment;
import io.intercom.android.sdk.conversation.ConversationContentPresenter;
import io.intercom.android.sdk.conversation.ConversationPartAdapter;
import io.intercom.android.sdk.conversation.ProfileExpansionLogic;
import io.intercom.android.sdk.conversation.ReactionInputView;
import io.intercom.android.sdk.conversation.SoundPlayer;
import io.intercom.android.sdk.conversation.composer.ComposerPresenter;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.failure.ConversationFailedEvent;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.profile.ProfilePresenter;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import io.intercom.android.sdk.utilities.StoreUtils;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.android.sdk.utilities.connectivity.NetworkConnectivityMonitor;
import io.intercom.android.sdk.views.IntercomErrorView;
import io.intercom.android.sdk.views.IntercomLinkView;
import io.intercom.android.sdk.views.IntercomToolbar;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.Subscribe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConversationFragment
extends Fragment
implements ConversationPartAdapter.Listener,
IntercomToolbar.Listener,
Store.Subscriber2<Integer, TeamPresence>,
ConversationContentPresenter.Host {
    private static final String ARG_IS_READ = "intercomsdk-isRead";
    private static final String ARG_CONVERSATION_ID = "conversationId";
    private static final String ARG_LAST_PARTICIPANT = "last_participant";
    private static final String ARG_GROUP_PARTICIPANTS = "group_participants";
    private static final String ARG_IS_TWO_PANE = "is_two_pane";
    private static final String ARG_INITIAL_MESSAGE = "initial_message";
    private static final String IMAGE_MIME_TYPE = "image";
    private static final int MAX_FILE_SIZE_BYTES = 0x2800000;
    private static final int COMPOSER_LIGHTBOX_REQUEST_CODE = 25;
    private static final String EXTRA_GALLERY_IMAGE = "gallery_image";
    final NetworkConnectivityMonitor networkConnectivityMonitor = new NetworkConnectivityMonitor();
    private final ProfileExpansionLogic profileExpansionLogic = new ProfileExpansionLogic();
    private Listener listener;
    String conversationId;
    View rootView;
    private ReactionInputView reactionComposer;
    private IntercomErrorView intercomErrorView;
    private IntercomToolbar intercomToolbar;
    Conversation conversation;
    private LastParticipatingAdmin lastParticipant;
    private List<Participant> groupParticipants;
    SoundPlayer soundPlayer;
    private CharSequence lastActiveTime;
    private boolean canOpenProfile = true;
    private Bus bus;
    private NexusClient nexusClient;
    private Store<State> store;
    Provider<AppConfig> appConfigProvider;
    private UserIdentity userIdentity;
    private RelativeLayout composerHolder;
    private boolean hasLoadedConversation = false;
    boolean orientationChanged = false;
    private int currentOrientation;
    boolean shouldStayAtBottom = false;
    private String initialMessage = "";
    private boolean isTwoPane = false;
    private MetricTracker metricTracker;
    private OpsMetricTracker opsMetricTracker;
    private Store.Subscription subscription;
    private IntercomLinkView intercomLinkView;
    @VisibleForTesting
    ComposerPresenter composerPresenter;
    ConversationContentPresenter contentPresenter;
    ProfilePresenter profilePresenter;
    private RequestManager requestManager;
    private final ViewTreeObserver.OnGlobalLayoutListener globalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){
        private int previousHeight;

        public void onGlobalLayout() {
            int newHeight = ConversationFragment.this.rootView.getHeight();
            if (this.previousHeight != 0 && !ConversationFragment.this.orientationChanged && this.previousHeight > newHeight) {
                ConversationFragment.this.profilePresenter.closeProfile();
                if (ConversationFragment.this.shouldStayAtBottom) {
                    ConversationFragment.this.contentPresenter.scrollToBottom();
                    ConversationFragment.this.shouldStayAtBottom = false;
                }
            }
            if (ConversationFragment.this.orientationChanged && this.previousHeight != newHeight) {
                ConversationFragment.this.orientationChanged = false;
            }
            this.previousHeight = newHeight;
            ConversationFragment.this.contentPresenter.onGlobalLayout();
        }
    };
    private final NetworkConnectivityMonitor.ConnectivityEventListener connectivityEventListener = new NetworkConnectivityMonitor.ConnectivityEventListener(){

        @Override
        public void onDisconnect() {
            Snackbar.make((View)ConversationFragment.this.rootView, (int)R.string.intercom_no_network_connection, (int)-2).show();
        }

        @Override
        public void onReconnect() {
            Snackbar.make((View)ConversationFragment.this.rootView, (int)R.string.intercom_connected, (int)0).setActionTextColor(ConversationFragment.this.appConfigProvider.get().getPrimaryColor()).setAction(R.string.intercom_dismiss, new View.OnClickListener(){

                public void onClick(View v) {
                }
            }).show();
        }
    };
    private final ComposerPresenter.Listener composerListener = new ComposerPresenter.Listener(){
        private final BlockFactory blockFactory = new BlockFactory(new TextSplittingStrategy());

        @Override
        public void onSendButtonPressed(CharSequence text) {
            String trimmedText = text.toString().trim();
            if (!trimmedText.isEmpty()) {
                ConversationFragment.this.opsMetricTracker.trackEvent("start", "time-to-process-action-send-part-ms");
                ConversationFragment.this.contentPresenter.sendPart(this.blockFactory.getBlocksForText(trimmedText));
                if (TextUtils.isEmpty((CharSequence)ConversationFragment.this.conversationId)) {
                    ConversationFragment.this.rootView.findViewById(R.id.disabled_view).setVisibility(0);
                }
            }
        }

        @Override
        public void onUploadImageSelected(GalleryImage galleryImage) {
            if (galleryImage.getFileSize() > 0x2800000) {
                this.showUploadError();
                return;
            }
            ConversationFragment.this.contentPresenter.uploadImage(this.createBlocks(galleryImage), galleryImage);
        }

        private List<Block.Builder> createBlocks(GalleryImage uploadImage) {
            ArrayList<Block.Builder> blocks = new ArrayList<Block.Builder>();
            if (uploadImage.getMimeType().contains(ConversationFragment.IMAGE_MIME_TYPE)) {
                blocks.add(new Block.Builder().withUrl(uploadImage.getPath()).withType(BlockType.LOCALIMAGE.name()).withWidth(uploadImage.getImageWidth()).withHeight(uploadImage.getImageHeight()));
            } else {
                BlockAttachment attachment = new BlockAttachment.Builder().withName(uploadImage.getFileName()).withUrl(uploadImage.getPath()).withContentType(uploadImage.getMimeType()).build();
                blocks.add(new Block.Builder().withAttachments(Collections.singletonList(attachment)).withType(BlockType.LOCAL_ATTACHMENT.name()));
            }
            return blocks;
        }

        private void showUploadError() {
            new AlertDialog.Builder((Context)ConversationFragment.this.getActivity()).setTitle(R.string.intercom_failed_to_send).setMessage(R.string.intercom_file_too_big).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).show();
        }

        @Override
        public void onRemoteImageSelected(GalleryImage galleryImage) {
            ConversationFragment.this.contentPresenter.sendPart(Collections.singletonList(new Block.Builder().withType(ConversationFragment.IMAGE_MIME_TYPE).withUrl(galleryImage.getPath()).withAttribution(galleryImage.getAttribution()).withHeight(galleryImage.getImageHeight()).withWidth(galleryImage.getImageWidth())));
            ConversationFragment.this.composerPresenter.returnToDefaultInput();
        }
    };

    public static ConversationFragment newInstance(String conversationId, LastParticipatingAdmin participant, boolean isRead, boolean isTwoPane, String initialMessage, List<Participant> groupParticipants) {
        ConversationFragment frag = new ConversationFragment();
        Bundle args = new Bundle();
        args.putString(ARG_CONVERSATION_ID, conversationId);
        args.putString(ARG_INITIAL_MESSAGE, initialMessage);
        args.putParcelable(ARG_LAST_PARTICIPANT, (Parcelable)participant);
        args.putParcelableArrayList(ARG_GROUP_PARTICIPANTS, new ArrayList<Participant>(groupParticipants));
        args.putBoolean(ARG_IS_READ, isRead);
        args.putBoolean(ARG_IS_TWO_PANE, isTwoPane);
        args.setClassLoader(Part.class.getClassLoader());
        frag.setArguments(args);
        return frag;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.listener = (Listener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context + " must implement ConversationFragment.Listener");
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestManager = Glide.with((Fragment)this);
        Injector injector = Injector.get();
        this.bus = injector.getBus();
        this.nexusClient = injector.getNexusClient();
        this.appConfigProvider = injector.getAppConfigProvider();
        this.userIdentity = injector.getUserIdentity();
        this.store = injector.getStore();
        this.metricTracker = injector.getMetricTracker();
        this.opsMetricTracker = injector.getOpsMetricTracker();
        this.opsMetricTracker.trackEvent("start", "time-to-process-action-load-conversation-ms");
        Bundle args = this.getArguments();
        if (args != null) {
            boolean isRead;
            args.setClassLoader(Part.class.getClassLoader());
            this.conversationId = args.getString(ARG_CONVERSATION_ID, "");
            this.initialMessage = args.getString(ARG_INITIAL_MESSAGE, "");
            this.lastParticipant = (LastParticipatingAdmin)args.getParcelable(ARG_LAST_PARTICIPANT);
            if (this.lastParticipant == null) {
                this.lastParticipant = LastParticipatingAdmin.NULL;
            }
            this.groupParticipants = args.getParcelableArrayList(ARG_GROUP_PARTICIPANTS);
            if (this.groupParticipants == null) {
                this.groupParticipants = new ArrayList<Participant>();
            }
            if (!(isRead = args.getBoolean(ARG_IS_READ, false))) {
                this.store.dispatch(Actions.conversationMarkedAsRead(this.conversationId));
            }
            this.isTwoPane = args.getBoolean(ARG_IS_TWO_PANE, false);
            if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
                this.store.dispatch(Actions.composerOpened());
            } else {
                this.store.dispatch(Actions.conversationOpened(this.conversationId));
            }
        }
        this.conversation = new Conversation();
        this.soundPlayer = new SoundPlayer((Context)this.getActivity(), this.appConfigProvider);
        this.currentOrientation = this.getResources().getConfiguration().orientation;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 25: {
                if (data == null || !data.hasExtra(EXTRA_GALLERY_IMAGE)) {
                    return;
                }
                GalleryImage image = (GalleryImage)data.getParcelableExtra(EXTRA_GALLERY_IMAGE);
                this.composerListener.onUploadImageSelected(image);
                break;
            }
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.intercom_fragment_conversation, container, false);
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
        }
        this.intercomLinkView = (IntercomLinkView)this.rootView.findViewById(R.id.intercom_link);
        this.composerHolder = (RelativeLayout)this.rootView.findViewById(R.id.composer_holder);
        CoordinatorLayout coordinator = (CoordinatorLayout)this.rootView.findViewById(R.id.conversation_coordinator_layout);
        this.profilePresenter = new ProfilePresenter(coordinator, this.metricTracker, this.appConfigProvider, this.requestManager);
        this.profilePresenter.setConversationId(this.conversationId);
        this.intercomErrorView = (IntercomErrorView)this.rootView.findViewById(R.id.error_layout_conversation);
        this.intercomErrorView.setActionButtonTextColor(this.appConfigProvider.get().getPrimaryColor());
        this.intercomErrorView.setActionButtonClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationFragment.this.displayLoadingView();
                ConversationFragment.this.contentPresenter.fetchConversation(ConversationFragment.this.conversationId);
            }
        });
        this.profilePresenter.addListener(new AppBarLayout.OnOffsetChangedListener(){

            public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                ConversationFragment.this.contentPresenter.onProfileScrolled();
            }
        });
        this.reactionComposer = (ReactionInputView)this.rootView.findViewById(R.id.reaction_input_view);
        this.intercomToolbar = (IntercomToolbar)this.rootView.findViewById(R.id.intercom_toolbar);
        this.intercomToolbar.updateToolbarColors(this.appConfigProvider.get());
        this.intercomToolbar.updateToolbarSize();
        this.intercomToolbar.setListener(this);
        this.intercomToolbar.setLeftNavigationItemVisibility(this.isTwoPane ? 8 : 0);
        this.intercomToolbar.animateBackButton();
        this.rootView.getViewTreeObserver().addOnGlobalLayoutListener(this.globalLayoutListener);
        return this.rootView;
    }

    void displayLoadingView() {
        if (this.isAdded()) {
            this.intercomErrorView.setVisibility(8);
            this.composerPresenter.hideComposer();
            this.contentPresenter.showLoadingView();
        }
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.contentPresenter = this.createContentPresenter(view);
        FrameLayout composerContainer = (FrameLayout)this.rootView.findViewById(R.id.composer_container);
        composerContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ConversationFragment.this.contentPresenter.isAtBottom()) {
                    ConversationFragment.this.shouldStayAtBottom = true;
                }
            }
        });
        this.composerPresenter = new ComposerPresenter(this.composerListener, composerContainer, this.getChildFragmentManager(), LayoutInflater.from((Context)view.getContext()), this.nexusClient, this.userIdentity, this.appConfigProvider, this.metricTracker, this.conversationId, this.initialMessage, this.store, (Context)this.getActivity(), this.appConfigProvider.get().getPrimaryColor());
        this.contentPresenter.setup();
        this.composerPresenter.requestFocus();
        this.configureInputView(this.conversation);
        if (this.conversationId.isEmpty()) {
            this.animateComposerIn();
            this.displayConversation();
        } else {
            this.composerPresenter.setConversationId(this.conversationId);
            this.displayLoadingView();
        }
        if (this.conversationId.isEmpty()) {
            this.canOpenProfile = false;
            view.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ConversationFragment.this.getActivity() == null) {
                        return;
                    }
                    ConversationFragment.this.profilePresenter.profileAutoOpened();
                    ConversationFragment.this.profilePresenter.startOffsetListener();
                    ConversationFragment.this.contentPresenter.smoothScrollToTop();
                }
            }, 50L);
        }
    }

    private ConversationContentPresenter createContentPresenter(View view) {
        Injector injector = Injector.get();
        TextView pill = (TextView)view.findViewById(R.id.pill);
        RecyclerView conversationList = (RecyclerView)view.findViewById(R.id.conversation_list);
        Blocks blocks = new Blocks((Context)this.getActivity(), LumberMill.getBlocksTwig());
        Api api = injector.getApi();
        ArrayList<Part> conversationParts = new ArrayList<Part>();
        ContextLocaliser contextLocaliser = new ContextLocaliser(this.appConfigProvider);
        ConversationPartAdapter adapter = ConversationPartAdapter.create((Activity)this.getActivity(), conversationParts, this, api, this.conversationId, this.appConfigProvider, this.userIdentity, injector.getTimeProvider(), contextLocaliser, this.requestManager);
        return ConversationContentPresenter.create(this, conversationList, adapter, this.intercomLinkView, this.appConfigProvider, api, conversationParts, this.conversationId, pill, this.soundPlayer, blocks, this.userIdentity, this.opsMetricTracker, this.requestManager, (Activity)this.getActivity());
    }

    private void configureInputView(Conversation conversation) {
        Part lastPart = conversation.getLastPart();
        if (ReactionReply.isNull(lastPart.getReactionReply())) {
            this.composerPresenter.showComposer();
            this.composerPresenter.requestFocus();
            this.reactionComposer.setVisibility(8);
        } else {
            ConversationReactionListener listener = new ConversationReactionListener(MetricTracker.ReactionLocation.CONVERSATION, lastPart.getId(), conversation.getId(), Injector.get().getApi(), this.metricTracker);
            this.reactionComposer.setUpReactions(lastPart.getReactionReply(), true, listener, this.requestManager);
            this.composerPresenter.hideComposer();
        }
    }

    private void animateComposerIn() {
        Animation slideUp = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.intercom_composer_slide_up);
        this.composerHolder.setVisibility(0);
        this.intercomLinkView.startAnimation(slideUp);
        this.composerHolder.startAnimation(slideUp);
    }

    @VisibleForTesting
    void displayConversation() {
        if (this.isAdded()) {
            this.intercomErrorView.setVisibility(8);
            this.contentPresenter.showContentView();
            this.configureInputView(this.conversation);
        }
    }

    public void onStart() {
        super.onStart();
        this.networkConnectivityMonitor.startListening((Context)this.getActivity());
        this.networkConnectivityMonitor.setListener(this.connectivityEventListener);
        this.subscription = this.store.subscribeToChanges(Selectors.UNREAD_COUNT, Selectors.TEAM_PRESENCE, this);
        this.bus.register((Object)this);
        this.bus.register((Object)this.contentPresenter);
        this.contentPresenter.fetchConversation(this.conversationId);
    }

    boolean hasNotLoadedLastAdminForExistingConversation() {
        return !this.hasLoadedConversation && !this.conversationId.isEmpty() && LastParticipatingAdmin.isNull(this.lastParticipant);
    }

    private void updateProfileToolbar(TeamPresence teamPresence) {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        if (LastParticipatingAdmin.isNull(this.lastParticipant) || this.lastParticipant == LastParticipatingAdmin.NONE) {
            int maxWidth = activity.getWindow().getDecorView().getMeasuredWidth();
            this.profilePresenter.setTeamPresence(teamPresence, maxWidth, this.requestManager);
        } else {
            this.updateLastActiveTime();
            this.profilePresenter.setTeammatePresence(this.lastParticipant, this.groupParticipants, this.lastActiveTime, this.rootView.getWidth());
        }
    }

    private void updateLastActiveTime() {
        LastParticipatingAdmin lastAdmin = this.conversation.getLastParticipatingAdmin();
        if (lastAdmin != null && this.getActivity() != null) {
            TimeFormatter timeFormatter = new TimeFormatter((Context)this.getActivity(), Injector.get().getTimeProvider());
            this.lastActiveTime = timeFormatter.getAdminActiveStatus(this.lastParticipant, this.appConfigProvider);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation != this.currentOrientation) {
            this.orientationChanged = true;
            this.composerPresenter.updateMaxLines();
        }
        this.currentOrientation = newConfig.orientation;
    }

    @Override
    public void onStateChange(Integer unreadCount, TeamPresence teamPresence) {
        this.intercomToolbar.setUnreadCount(unreadCount);
        if (this.hasNotLoadedLastAdminForExistingConversation()) {
            this.profilePresenter.setUnknownPresence();
        } else {
            this.updateProfileToolbar(teamPresence);
        }
    }

    public void onStop() {
        StoreUtils.safeUnsubscribe(this.subscription);
        this.bus.unregister((Object)this);
        this.bus.unregister((Object)this.contentPresenter);
        this.networkConnectivityMonitor.setListener(null);
        this.networkConnectivityMonitor.stopListening((Context)this.getActivity());
        this.opsMetricTracker.clear();
        this.profilePresenter.onStop();
        super.onStop();
    }

    public void onDestroyView() {
        ViewUtils.removeGlobalLayoutListener(this.rootView, this.globalLayoutListener);
        this.composerPresenter.cleanup();
        this.contentPresenter.cleanup();
        this.profilePresenter.cleanup();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.store.dispatch(Actions.conversationClosed());
        super.onDestroy();
    }

    public void sdkWindowFinishedAnimating() {
        if (this.getView() != null && this.profileExpansionLogic.shouldExpandProfile(this.conversation)) {
            this.profilePresenter.profileAutoOpened();
            this.contentPresenter.smoothScrollToTop();
        }
    }

    @Override
    public String getConversationId() {
        return this.conversationId;
    }

    @Override
    public Conversation getConversation() {
        return this.conversation;
    }

    @Override
    public void onConversationCreated(Conversation conversation) {
        this.rootView.findViewById(R.id.disabled_view).setVisibility(8);
        this.conversation = conversation;
        this.conversationId = conversation.getId();
        this.profilePresenter.setConversationId(this.conversationId);
        this.composerPresenter.setConversationId(this.conversationId);
        this.composerPresenter.setHint(R.string.intercom_reply_to_conversation);
        this.nexusClient.fire(NexusEvent.getNewCommentEvent((String)this.conversationId, (String)this.userIdentity.getIntercomId()));
        Part part = conversation.getParts().get(0);
        this.metricTracker.sentInNewConversation(part.hasAttachments(), part.isGifOnlyPart(), part.getId(), this.conversationId, this.store.select(Selectors.TEAM_PRESENCE).getOfficeHours().isEmpty());
        this.metricTracker.startConversation(this.conversationId);
        this.hasLoadedConversation = true;
    }

    private void toggleProfile() {
        if (this.profilePresenter.isExpanded()) {
            this.profilePresenter.closeProfile();
        } else {
            this.profilePresenter.profileClicked();
            this.contentPresenter.smoothScrollToTop();
        }
    }

    @Subscribe
    public void conversationSuccess(ConversationEvent event) {
        int conversationSize = this.conversation.getParts().size();
        boolean initialLoad = conversationSize == 0;
        List<Part> eventParts = event.getResponse().getParts();
        if (event.getResponse().getId().equals(this.conversationId) && eventParts.size() > conversationSize) {
            boolean isUnread;
            this.conversation = event.getResponse();
            if (this.isAdded()) {
                this.contentPresenter.onConversationFetched(event, initialLoad);
                this.displayConversation();
            }
            boolean bl = isUnread = !this.conversation.isRead();
            if (isUnread) {
                Injector.get().getApi().markConversationAsRead(this.conversationId);
                this.store.dispatch(Actions.conversationMarkedAsRead(this.conversationId));
                this.nexusClient.fire(NexusEvent.getConversationSeenEvent((String)this.conversationId, (String)this.userIdentity.getIntercomId()));
            }
            if (initialLoad) {
                View view;
                this.animateComposerIn();
                Part lastPart = eventParts.get(eventParts.size() - 1);
                if (lastPart.isReply() && isUnread) {
                    this.trackLastPart(lastPart);
                }
                if (this.canOpenProfile && (view = this.getView()) != null) {
                    final boolean profileWillOpen = this.profileExpansionLogic.shouldExpandProfile(this.conversation);
                    view.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationFragment.this.getContext() == null) {
                                return;
                            }
                            if (profileWillOpen) {
                                ConversationFragment.this.profilePresenter.profileAutoOpened();
                                ConversationFragment.this.profilePresenter.startOffsetListener();
                                ConversationFragment.this.contentPresenter.smoothScrollToTop();
                            } else {
                                ConversationFragment.this.profilePresenter.startOffsetListener();
                            }
                        }
                    }, 50L);
                    if (profileWillOpen) {
                        this.contentPresenter.scrollToTop();
                    } else {
                        this.contentPresenter.scrollToBottom();
                    }
                    this.canOpenProfile = false;
                }
            } else {
                List<Part> newParts = eventParts.subList(conversationSize, eventParts.size());
                for (Part part : newParts) {
                    if (!part.isAdmin()) continue;
                    if (part.getParticipant().isBot().booleanValue()) {
                        this.soundPlayer.playOperatorReceivedSound();
                        break;
                    }
                    this.soundPlayer.playMessageReceivedSound();
                    break;
                }
                this.contentPresenter.onNewPartReceived();
                this.trackLastPart(newParts.get(newParts.size() - 1));
            }
        }
        this.lastParticipant = this.conversation.getLastParticipatingAdmin();
        this.groupParticipants = this.conversation.getGroupConversationParticipants();
        if (this.lastParticipant != null) {
            this.updateLastActiveTime();
        }
        this.updateProfileToolbar(this.store.select(Selectors.TEAM_PRESENCE));
        this.hasLoadedConversation = true;
    }

    private void trackLastPart(Part part) {
        if (part.isLinkList()) {
            this.metricTracker.receivedOperatorReply(this.conversationId);
        } else {
            this.metricTracker.receivedReply(part.hasAttachments(), part.isLinkCard(), part.getId(), this.conversationId);
        }
    }

    @Subscribe
    public void conversationFailure(ConversationFailedEvent event) {
        if (this.isAdded()) {
            this.displayErrorView();
        }
    }

    private void displayErrorView() {
        this.intercomErrorView.setVisibility(0);
        this.composerHolder.setVisibility(8);
        this.contentPresenter.showErrorView();
    }

    @Subscribe
    public void replySuccess(ReplyEvent event) {
        if (event.getConversationId().equals(this.conversationId)) {
            this.nexusClient.fire(NexusEvent.getNewCommentEvent((String)this.conversationId, (String)this.userIdentity.getIntercomId()));
            Part part = event.getResponse();
            Participant participant = this.conversation.getParticipant(part.getParticipantId());
            if (participant == Participant.NULL) {
                participant = new Participant.Builder().withId(part.getParticipantId()).build();
                this.conversation.getParticipants().put(part.getParticipantId(), participant);
            }
            part.setParticipant(participant);
            this.contentPresenter.onReplyDelivered(event);
            TimeFormatter timeFormatter = new TimeFormatter((Context)this.getActivity(), Injector.get().getTimeProvider());
            this.metricTracker.sentInConversation(part.hasAttachments(), part.isGifOnlyPart(), part.getId(), this.conversationId, this.store.select(Selectors.TEAM_PRESENCE).getOfficeHours().isEmpty(), this.lastParticipant.isActive(), timeFormatter.getLastActiveMinutes(this.lastParticipant.getLastActiveAt()));
        }
    }

    @Subscribe
    public void adminIsTyping(AdminIsTypingEvent event) {
        if (this.conversationId.equals(event.getConversationId())) {
            this.contentPresenter.onAdminStartedTyping(event);
        }
    }

    @Override
    public void onPartClicked(Part part) {
        this.contentPresenter.onPartClicked(part);
    }

    @Override
    public void onPostCardClicked(Part part) {
        this.startActivity(IntercomPostActivity.buildPostIntent(this.getContext(), part, "", this.lastParticipant, false));
    }

    @Override
    public void onCloseClicked() {
        this.listener.onToolbarCloseClicked();
    }

    @Override
    public void onToolbarClicked() {
        this.toggleProfile();
    }

    @Override
    public void onInboxClicked() {
        this.composerPresenter.cleanup();
        this.listener.onBackClicked();
    }

    public boolean shouldHandleOnBackPressed() {
        return this.composerPresenter != null && this.composerPresenter.isOpen();
    }

    public void handleOnBackPressed() {
        this.composerPresenter.onBackPressed();
    }

    public static interface Listener {
        public void onToolbarCloseClicked();

        public void onBackClicked();
    }
}

