/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.model.stream;

import android.content.Context;
import android.net.Uri;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.data.mediastore.MediaStoreUtil;
import io.intercom.com.bumptech.glide.load.data.mediastore.ThumbFetcher;
import io.intercom.com.bumptech.glide.load.model.ModelLoader;
import io.intercom.com.bumptech.glide.load.model.ModelLoaderFactory;
import io.intercom.com.bumptech.glide.load.model.MultiModelLoaderFactory;
import io.intercom.com.bumptech.glide.signature.ObjectKey;
import java.io.InputStream;

public class MediaStoreImageThumbLoader
implements ModelLoader<Uri, InputStream> {
    private final Context context;

    public MediaStoreImageThumbLoader(Context context) {
        this.context = context.getApplicationContext();
    }

    @Override
    public ModelLoader.LoadData<InputStream> buildLoadData(Uri model, int width, int height, Options options) {
        if (MediaStoreUtil.isThumbnailSize(width, height)) {
            return new ModelLoader.LoadData<InputStream>(new ObjectKey(model), ThumbFetcher.buildImageFetcher(this.context, model));
        }
        return null;
    }

    @Override
    public boolean handles(Uri model) {
        return MediaStoreUtil.isMediaStoreImageUri(model);
    }

    public static class Factory
    implements ModelLoaderFactory<Uri, InputStream> {
        private final Context context;

        public Factory(Context context) {
            this.context = context;
        }

        @Override
        public ModelLoader<Uri, InputStream> build(MultiModelLoaderFactory multiFactory) {
            return new MediaStoreImageThumbLoader(this.context);
        }

        @Override
        public void teardown() {
        }
    }
}

