/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.app.Activity;
import android.os.Bundle;
import com.intercom.composer.ComposerFragment;
import com.intercom.input.gallery.GalleryInput;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.activities.IntercomHelpCenterActivity;
import javax.annotation.Nullable;

public class ActivityUtils {
    private static final String PACKAGE_NAME = Intercom.class.getPackage().getName();
    private static final String COMPOSER_PACKAGE_NAME = ComposerFragment.class.getPackage().getName();
    private static final String COMPOSER_INPUT_PACKAGE_NAME = GalleryInput.class.getPackage().getName();
    private static final String[] INTERCOM_PACKAGES = new String[]{PACKAGE_NAME, COMPOSER_PACKAGE_NAME, COMPOSER_INPUT_PACKAGE_NAME};

    public static boolean isHostActivity(@Nullable Activity activity) {
        return activity != null && ActivityUtils.isInHostAppPackage(activity.getClass().getName());
    }

    public static boolean isFullScreenHelpCenter(@Nullable Activity activity) {
        if (activity == null || activity.getIntent() == null) {
            return false;
        }
        Bundle data = activity.getIntent().getExtras();
        int displayMode = 1;
        if (data != null) {
            displayMode = data.getInt("parcel_display_mode", 1);
        }
        return activity instanceof IntercomHelpCenterActivity && displayMode == 1;
    }

    private static boolean isInHostAppPackage(String activityName) {
        for (String packageName : INTERCOM_PACKAGES) {
            if (!activityName.startsWith(packageName)) continue;
            return false;
        }
        return true;
    }
}

