/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.overlay.LauncherOpenBehaviour;
import io.intercom.android.sdk.profile.ProfilePresenter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.UUID;

public class MetricTracker {
    static final String METADATA_BADGE_VALUE = "badge_value";
    static final String METADATA_IS_ATTACHMENT = "is_attachment";
    static final String METADATA_IS_GIF = "is_gif";
    static final String METADATA_MESSAGE_ID = "message_id";
    static final String METADATA_CONVERSATION_ID = "conversation_id";
    static final String METADATA_PART_ID = "part_id";
    static final String METADATA_QUICK_REPLY_ID = "quick_reply_id";
    static final String METADATA_COMMENT_ID = "comment_id";
    static final String METADATA_REACTION_INDEX = "reaction_index";
    static final String METADATA_MESSAGE_TYPE = "message_type";
    static final String METADATA_PUSH_TYPE = "push_type";
    static final String METADATA_HAS_ARTICLE_CARD = "has_article_card";
    static final String METADATA_SEARCH_QUERY = "search_query";
    static final String METADATA_TEAMMATE_STATUS = "teammate_status";
    static final String METADATA_TIME_SINCE_LAST_ACTIVE = "time_since_last_active";
    static final String METADATA_WITHIN_OFFICE_HOURS = "within_office_hours";
    static final String METADATA_URL = "url";
    static final String VALUE_MESSAGE = "message";
    static final String VALUE_NOTIFICATION = "notification";
    static final String VALUE_ACTIVE = "active";
    static final String VALUE_AWAY = "away";
    private final UserIdentity userIdentity;
    private final TimeProvider timeProvider;
    private final MetricsStore store;
    private final String sdkVersion;
    private final String appVersion;

    public MetricTracker(UserIdentity userIdentity, MetricsStore store, android.content.Context androidContext) {
        this(userIdentity, store, TimeProvider.SYSTEM, androidContext);
    }

    @VisibleForTesting
    MetricTracker(UserIdentity userIdentity, MetricsStore store, TimeProvider timeProvider, android.content.Context androidContext) {
        this.userIdentity = userIdentity;
        this.timeProvider = timeProvider;
        this.store = store;
        this.sdkVersion = "5.1.3";
        this.appVersion = DeviceUtils.getAppVersion((android.content.Context)androidContext);
    }

    public void openedMessengerConversationList(LauncherOpenBehaviour.LauncherType launcherType) {
        this.track(this.newMetric("opened", "conversation_list", "messenger", MetricTracker.contextFrom(launcherType)));
    }

    public void openedMessengerConversation(String conversationId, LauncherOpenBehaviour.LauncherType launcherType) {
        this.track(this.newMetric("opened", "conversation", "messenger", MetricTracker.contextFrom(launcherType)).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void openedMessengerNewConversation(LauncherOpenBehaviour.LauncherType launcherType) {
        this.track(this.newMetric("opened", "new_conversation", "messenger", MetricTracker.contextFrom(launcherType)));
    }

    private static String contextFrom(LauncherOpenBehaviour.LauncherType launcherType) {
        return LauncherOpenBehaviour.LauncherType.DEFAULT == launcherType ? "from_launcher" : "from_custom_launcher";
    }

    public void closedMessengerBackButton() {
        this.track(this.newMetric("closed", "messenger", "messenger", "from_android_back_button"));
    }

    public void closedMessengerCloseButton() {
        this.track(this.newMetric("closed", "messenger", "messenger", "from_close_button"));
    }

    public void newConversationFromComposeButton(boolean withinOfficeHours) {
        this.track(this.newMetric("opened", "new_conversation", "messenger", "from_conversation_list").addMetaData(METADATA_WITHIN_OFFICE_HOURS, withinOfficeHours));
    }

    void typeInNewConversation() {
        this.track(this.newMetric("typed", VALUE_MESSAGE, "messenger", "in_new_conversation"));
    }

    void typeInConversation(String conversationId) {
        this.track(this.newMetric("typed", "reply", "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void sentInNewConversation(boolean isAttachment, boolean isGif, String partId, String conversationId, boolean withinOfficeHours) {
        this.track(this.newMetric("sent", VALUE_MESSAGE, "messenger", "in_new_conversation").addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_IS_GIF, isGif).addMetaData(METADATA_MESSAGE_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_WITHIN_OFFICE_HOURS, withinOfficeHours));
    }

    public void sentInConversation(boolean isAttachment, boolean isGif, String partId, String conversationId, boolean withinOfficeHours, boolean isTeamMateActive, String timeSinceLastActive) {
        this.track(this.newMetric("sent", "reply", "messenger", "in_conversation").addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_IS_GIF, isGif).addMetaData(METADATA_MESSAGE_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_WITHIN_OFFICE_HOURS, withinOfficeHours).addMetaData(METADATA_TEAMMATE_STATUS, isTeamMateActive ? VALUE_ACTIVE : VALUE_AWAY).addMetaData(METADATA_TIME_SINCE_LAST_ACTIVE, timeSinceLastActive));
    }

    public void openConversationsListFromNewConversation() {
        this.track(this.newMetric("opened", "conversation_list", "messenger", "from_new_conversation"));
    }

    public void startConversation(String conversationId) {
        this.track(this.newMetric("opened", "conversation", "messenger", "from_new_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void openConversationsListFromConversation(String conversationId) {
        this.track(this.newMetric("opened", "conversation_list", "messenger", "from_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void openedConversationFromFull(String conversationId, String commentId) {
        this.track(this.newMetric("opened", "conversation", "messenger", "from_full").addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void openedConversationFromSnippet(String conversationId, String commentId) {
        this.track(this.newMetric("opened", "conversation", "messenger", "from_snippet").addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void receivedReply(boolean isAttachment, boolean hasArticle, String partId, String conversationId) {
        this.track(this.newMetric("received", "reply", "messenger", "in_conversation").addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle).addMetaData(METADATA_COMMENT_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void viewedReply(boolean isAttachment, boolean hasArticle, String partId, String conversationId) {
        this.track(this.newMetric("viewed", "reply", "messenger", "from_snippet").addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle).addMetaData(METADATA_COMMENT_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void sentReaction(String conversationId, String messageId, int reactionIndex, ReactionLocation reactionLocation) {
        if (ReactionLocation.CONVERSATION == reactionLocation) {
            this.track(this.newMetric("sent", "reaction", "messenger", "in_conversation").addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_REACTION_INDEX, reactionIndex).addMetaData(METADATA_CONVERSATION_ID, conversationId));
        } else if (ReactionLocation.LINK == reactionLocation) {
            this.track(this.newEducateMetric("sent", "reaction", "messenger", "on_article").addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
        } else {
            this.track(this.newMetric("sent", "reaction", "in_app", "from_full").addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
        }
    }

    public void profileClickedOpen(String conversationId, ProfilePresenter.ProfileType profileType) {
        this.track(this.newMetric("opened", MetricTracker.objectFrom(profileType), "messenger", "from_clicking").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void profileAutoOpen(String conversationId, ProfilePresenter.ProfileType profileType) {
        this.track(this.newMetric("opened", MetricTracker.objectFrom(profileType), "messenger", "from_auto").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void profileScrolledOpen(String conversationId, ProfilePresenter.ProfileType profileType) {
        this.track(this.newMetric("opened", MetricTracker.objectFrom(profileType), "messenger", "from_scrolling").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    private static String objectFrom(ProfilePresenter.ProfileType profileType) {
        return ProfilePresenter.ProfileType.TEAMMATE == profileType ? "teammate_profile" : "team_profile";
    }

    public void openConversationFromConversationList(String conversationId, boolean withinOfficeHours, boolean isTeamMateActive, String timeSinceLastActive) {
        this.track(this.newMetric("opened", "conversation", "messenger", "from_conversation_list").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_WITHIN_OFFICE_HOURS, withinOfficeHours).addMetaData(METADATA_TEAMMATE_STATUS, isTeamMateActive ? VALUE_ACTIVE : VALUE_AWAY).addMetaData(METADATA_TIME_SINCE_LAST_ACTIVE, timeSinceLastActive));
    }

    public void viewedPushNotification(String conversationId) {
        this.track(this.newMetric("viewed", VALUE_MESSAGE, "in_app", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, VALUE_NOTIFICATION));
    }

    public void openedPushOnlyNotification(String conversationId) {
        this.track(this.newMetric("opened", VALUE_MESSAGE, "in_app", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, VALUE_MESSAGE));
    }

    public void dismissedPushNotification(String conversationId, boolean isPushOnly) {
        String pushType = isPushOnly ? VALUE_MESSAGE : VALUE_NOTIFICATION;
        this.track(this.newMetric("dismissed", VALUE_MESSAGE, "in_app", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, pushType));
    }

    public void receivedMessageFromSnippetWhenClosed(boolean isAttachment, boolean hasArticle, String conversationId, String messageId, String messageStyle) {
        this.track(this.newMetric("received", VALUE_MESSAGE, "in_app", "from_snippet").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_MESSAGE_TYPE, messageStyle).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle));
    }

    public void receivedReplyFromSnippetWhenClosed(boolean isAttachment, boolean hasArticle, String conversationId, String commentId) {
        this.track(this.newMetric("received", "reply", "in_app", "from_snippet").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle));
    }

    public void receivedMessageFromFullWhenClosed(boolean isAttachment, boolean hasArticle, String conversationId, String messageId, String messageStyle) {
        this.track(this.newMetric("received", VALUE_MESSAGE, "in_app", "from_full").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_MESSAGE_TYPE, messageStyle).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle));
    }

    public void receivedQuickReply(String quickReplyId, String conversationId, String partId) {
        this.track(this.newMetric("received", "quick_replies", "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PART_ID, partId).addMetaData(METADATA_QUICK_REPLY_ID, quickReplyId));
    }

    public void clickedQuickReply(String quickReplyId, String conversationId, String partId) {
        this.track(this.newMetric("clicked", "quick_reply", "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PART_ID, partId).addMetaData(METADATA_QUICK_REPLY_ID, quickReplyId));
    }

    public void dismissInAppMessageSnippet(String conversationId, String messageId) {
        this.track(this.newMetric("dismissed", VALUE_MESSAGE, "in_app", "from_snippet").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_MESSAGE_ID, messageId));
    }

    public void dismissInAppCommentSnippet(String conversationId, String commentId) {
        this.track(this.newMetric("dismissed", "reply", "in_app", "from_snippet").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_COMMENT_ID, commentId));
    }

    public void viewedInAppFromMessenger(String conversationId, String messageId, String messageStyle) {
        this.track(this.newMetric("viewed", VALUE_MESSAGE, "messenger", "from_full").addMetaData(METADATA_MESSAGE_TYPE, messageStyle).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void viewedInApp(String conversationId, String messageId, @InAppMessageViewContext int context) {
        this.track(this.newMetric("viewed", VALUE_MESSAGE, "in_app", MetricTracker.contextForInApp(context)).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    private static String contextForInApp(@InAppMessageViewContext int context) {
        return context == 0 ? "from_snippet" : "from_full";
    }

    public void closedInAppFromFull(String conversationId, String messageId) {
        this.track(this.newMetric("closed", VALUE_MESSAGE, "in_app", "from_full").addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void receivedPushNotification(String conversationId) {
        this.track(this.newMetric("received", VALUE_MESSAGE, "push", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, VALUE_NOTIFICATION));
    }

    public void receivedPushOnlyNotification(String conversationId) {
        this.track(this.newMetric("received", VALUE_MESSAGE, "push", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, VALUE_MESSAGE));
    }

    public void receivedNotificationFromBadgeWhenMessengerClosed(String badgeValue) {
        this.track(this.newMetric("received", "badge", "in_app", "from_launcher").addMetaData(METADATA_BADGE_VALUE, badgeValue));
    }

    public void viewedArticle(String conversationId, String messageId) {
        this.track(this.newEducateMetric("viewed", "article", "messenger", "from_conversation").addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void closedArticle(String conversationId, String messageId, int closeContext) {
        String context = closeContext == 0 ? "from_close_button" : "from_android_back_button";
        this.track(this.newEducateMetric("closed", "article", "messenger", context).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void receivedOperatorReply(String conversationId) {
        this.track(this.newEducateMetric("received", "operator_reply", "messenger", "from_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void viewedHelpCenter(String conversationId) {
        this.track(this.newEducateMetric("viewed", "help_center", "messenger", "from_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void closedHelpCenter(String conversationId, int closeContext) {
        String context = closeContext == 0 ? "from_close_button" : "from_android_back_button";
        this.track(this.newEducateMetric("closed", "help_center", "messenger", context).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void clickedInput(String conversationId, String input) {
        this.track(this.newMetric("clicked", input, "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void searchedGifInput(String query) {
        this.track(this.newMetric("searched", "expanded_gif_input", "messenger", "in_conversation").addMetaData(METADATA_SEARCH_QUERY, query));
    }

    public void expandedInput(String conversationId, String expandedInput) {
        this.track(this.newMetric("opened", "expanded_gif_input", "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void educateWebviewMetric(String action, String object, String place, @Nullable Map<String, java.lang.Object> eventMetaData) {
        MetricObject metricObject = this.newEducateMetric(action, object, place, "from_help_center_webview");
        this.addMetadataToMetricObject(metricObject, eventMetaData);
        this.track(metricObject);
    }

    public void viewedMessengerSheet(String conversationId, String url, boolean isHomeScreen) {
        String context = isHomeScreen ? "home_screen" : "conversation";
        this.track(this.newMetric("viewed", "messenger_sheet", "messenger", context).addMetaData(METADATA_URL, url).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void closedMessengerSheet(String conversationId, String url, boolean isHomeScreen) {
        String context = isHomeScreen ? "home_screen" : "conversation";
        this.track(this.newMetric("closed", "messenger_sheet", "messenger", context).addMetaData(METADATA_URL, url).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void messengerCardWebViewEvent(String action, String object, String place, @Nullable Map<String, java.lang.Object> eventMetaData, boolean isHomeScreen) {
        String context = isHomeScreen ? "home_screen" : "conversation";
        MetricObject metricObject = this.newEducateMetric(action, object, place, context);
        this.addMetadataToMetricObject(metricObject, eventMetaData);
        this.track(metricObject);
    }

    public void openedHomeScreen(LauncherOpenBehaviour.LauncherType launcherType) {
        this.track(this.newMetric("opened", "home_screen", "messenger", MetricTracker.contextFrom(launcherType)));
    }

    public void openedNewConversationFromHomeScreen() {
        this.track(this.newMetric("opened", "new_conversation", "messenger", "home_screen"));
    }

    public void openedConversationFromHomeScreen(String conversationId) {
        this.track(this.newMetric("opened", "conversation", "messenger", "home_screen").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    private void track(MetricObject metric) {
        this.store.track(metric);
    }

    private MetricObject newMetric(String action, String object, String place, String context) {
        return this.createMetric("mv4_metric", "messenger", action, object, place, context);
    }

    private MetricObject newEducateMetric(String action, String object, String place, String context) {
        return this.createMetric("educate_event", "educate", action, object, place, context);
    }

    private MetricObject createMetric(String name, String owner, String action, String object, String place, String context) {
        return new MetricObject(name, owner, UUID.randomUUID().toString(), this.userIdentity.getIntercomId(), action, object, place, context, this.timeProvider, this.appVersion, this.sdkVersion);
    }

    private void addMetadataToMetricObject(MetricObject metricObject, @Nullable Map<String, java.lang.Object> eventMetaData) {
        if (eventMetaData != null && !eventMetaData.isEmpty()) {
            for (String key : eventMetaData.keySet()) {
                metricObject.addMetaData(key, eventMetaData.get(key));
            }
        }
    }

    public static enum ReactionLocation {
        CONVERSATION,
        IN_APP,
        LINK;

    }

    public static @interface InAppMessageViewContext {
        public static final int SNIPPET = 0;
        public static final int FULL = 1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CloseActionContext {
        public static final int CLOSE_BUTTON = 0;
        public static final int BACK_BUTTON = 1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Owner {
        public static final String MESSENGER = "messenger";
        public static final String EDUCATE = "educate";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Context {
        public static final String FROM_LAUNCHER = "from_launcher";
        public static final String FROM_CUSTOM_LAUNCHER = "from_custom_launcher";
        public static final String FROM_ANDROID_BACK_BUTTON = "from_android_back_button";
        public static final String FROM_CLOSE_BUTTON = "from_close_button";
        public static final String FROM_CONVERSATION_LIST = "from_conversation_list";
        public static final String IN_NEW_CONVERSATION = "in_new_conversation";
        public static final String FROM_NEW_CONVERSATION = "from_new_conversation";
        public static final String FROM_CONVERSATION = "from_conversation";
        public static final String IN_CONVERSATION = "in_conversation";
        public static final String FROM_SNIPPET = "from_snippet";
        public static final String FROM_FULL = "from_full";
        public static final String FROM_CLICKING = "from_clicking";
        public static final String FROM_SCROLLING = "from_scrolling";
        public static final String FROM_AUTO = "from_auto";
        public static final String FROM_PUSH = "from_push";
        public static final String ON_ARTICLE = "on_article";
        public static final String FROM_HELP_CENTER_WEBVIEW = "from_help_center_webview";
        public static final String CONVERSATION = "conversation";
        public static final String HOME_SCREEN = "home_screen";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Place {
        public static final String MESSENGER = "messenger";
        public static final String IN_APP = "in_app";
        public static final String PUSH = "push";
        public static final String MESSENGER_CARD = "messenger_card";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Object {
        public static final String BADGE = "badge";
        public static final String CONVERSATION_LIST = "conversation_list";
        public static final String CONVERSATION = "conversation";
        public static final String NEW_CONVERSATION = "new_conversation";
        public static final String MESSENGER = "messenger";
        public static final String MESSAGE = "message";
        public static final String REPLY = "reply";
        public static final String REACTION = "reaction";
        public static final String TEAMMATE_PROFILE = "teammate_profile";
        public static final String TEAM_PROFILE = "team_profile";
        public static final String ARTICLE = "article";
        public static final String HELP_CENTER = "help_center";
        public static final String OPERATOR_REPLY = "operator_reply";
        public static final String EXPANDED_GIF_INPUT = "expanded_gif_input";
        public static final String EXPANDED_IMAGE_INPUT = "expanded_image_input";
        public static final String GIF_INPUT = "gif_input";
        public static final String INPUT = "input";
        public static final String IMAGE_INPUT = "image_input";
        public static final String MESSENGER_SHEET = "messenger_sheet";
        public static final String HOME_SCREEN = "home_screen";
        public static final String QUICK_REPLY = "quick_reply";
        public static final String QUICK_REPLIES = "quick_replies";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Action {
        public static final String OPENED = "opened";
        public static final String CLOSED = "closed";
        public static final String TYPED = "typed";
        public static final String SENT = "sent";
        public static final String RECEIVED = "received";
        public static final String VIEWED = "viewed";
        public static final String DISMISSED = "dismissed";
        public static final String SEARCHED = "searched";
        public static final String CLICKED = "clicked";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Name {
        public static final String MESSENGER = "mv4_metric";
        public static final String EDUCATE = "educate_event";
    }
}

