/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.content.res.Resources;
import android.support.annotation.Nullable;
import android.view.View;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.views.IntercomLinkView;

public class IntercomLinkPresenter {
    private static final String SOLUTION_LIVE_CHAT = "live_chat";
    final IntercomLinkView intercomLinkView;
    private final Provider<AppConfig> appConfigProvider;
    private final Api api;
    private final String conversationId;
    private final String appId;
    private final String userId;
    private final boolean fromHomeScreen;
    private String solution = "live_chat";
    private boolean wasAtBottom = false;

    public IntercomLinkPresenter(IntercomLinkView intercomLinkView, Provider<AppConfig> appConfigProvider, Api api, String conversationId, String appId, String userId, boolean fromHomeScreen) {
        this.intercomLinkView = intercomLinkView;
        this.appConfigProvider = appConfigProvider;
        this.api = api;
        this.conversationId = conversationId;
        this.appId = appId;
        this.userId = userId;
        this.fromHomeScreen = fromHomeScreen;
    }

    public void setup(IntercomLinkHost host) {
        this.intercomLinkView.setAlpha(0.0f);
        if (!this.shouldShowIntercomLink()) {
            return;
        }
        Resources resources = this.intercomLinkView.getResources();
        int extraBottomPadding = resources.getDimensionPixelSize(R.dimen.intercom_link_height) + resources.getDimensionPixelSize(R.dimen.intercom_link_text_padding) * 2;
        host.addBottomPadding(extraBottomPadding);
        this.intercomLinkView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (IntercomLinkPresenter.this.intercomLinkView.getAlpha() == 1.0f) {
                    IntercomLinkPresenter.this.intercomLinkView.followIntercomLink(IntercomLinkPresenter.this.appConfigProvider, IntercomLinkPresenter.this.api, IntercomLinkPresenter.this.fromHomeScreen, IntercomLinkPresenter.this.appId, IntercomLinkPresenter.this.userId, IntercomLinkPresenter.this.solution);
                }
            }
        });
        if (this.conversationId.isEmpty()) {
            this.intercomLinkView.show();
        }
    }

    void updateIntercomLink(IntercomLinkHost host) {
        if (!this.shouldShowIntercomLink()) {
            return;
        }
        boolean isAtBottom = host.isAtBottom();
        if (isAtBottom && !this.wasAtBottom) {
            this.intercomLinkView.show();
        } else if (this.wasAtBottom && !isAtBottom) {
            this.intercomLinkView.hide();
        }
        this.wasAtBottom = host.isAtBottom();
    }

    void onProfileScrolled(@Nullable View lastConversationChildView) {
        if (!this.shouldShowIntercomLink()) {
            return;
        }
        if (lastConversationChildView != null) {
            this.intercomLinkView.hideIfIntersectedOrShow(lastConversationChildView);
        }
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    private boolean shouldShowIntercomLink() {
        return this.appConfigProvider.get().shouldShowIntercomLink();
    }

    public static interface IntercomLinkHost {
        public void addBottomPadding(int var1);

        public boolean isAtBottom();
    }
}

