/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.model.stream;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.data.mediastore.MediaStoreUtil;
import io.intercom.com.bumptech.glide.load.data.mediastore.ThumbFetcher;
import io.intercom.com.bumptech.glide.load.model.ModelLoader;
import io.intercom.com.bumptech.glide.load.model.ModelLoaderFactory;
import io.intercom.com.bumptech.glide.load.model.MultiModelLoaderFactory;
import io.intercom.com.bumptech.glide.load.resource.bitmap.VideoBitmapDecoder;
import io.intercom.com.bumptech.glide.signature.ObjectKey;
import java.io.InputStream;

public class MediaStoreVideoThumbLoader
implements ModelLoader<Uri, InputStream> {
    private final Context context;

    public MediaStoreVideoThumbLoader(Context context) {
        this.context = context.getApplicationContext();
    }

    @Override
    @Nullable
    public ModelLoader.LoadData<InputStream> buildLoadData(Uri model, int width, int height, Options options) {
        if (MediaStoreUtil.isThumbnailSize(width, height) && this.isRequestingDefaultFrame(options)) {
            return new ModelLoader.LoadData<InputStream>(new ObjectKey(model), ThumbFetcher.buildVideoFetcher(this.context, model));
        }
        return null;
    }

    private boolean isRequestingDefaultFrame(Options options) {
        Long specifiedFrame = options.get(VideoBitmapDecoder.TARGET_FRAME);
        return specifiedFrame != null && specifiedFrame == -1L;
    }

    @Override
    public boolean handles(Uri model) {
        return MediaStoreUtil.isMediaStoreVideoUri(model);
    }

    public static class Factory
    implements ModelLoaderFactory<Uri, InputStream> {
        private final Context context;

        public Factory(Context context) {
            this.context = context;
        }

        @Override
        public ModelLoader<Uri, InputStream> build(MultiModelLoaderFactory multiFactory) {
            return new MediaStoreVideoThumbLoader(this.context);
        }

        @Override
        public void teardown() {
        }
    }
}

