/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatTextView;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;

@SuppressLint(value={"ViewConstructor"})
public class ParagraphView
extends AppCompatTextView {
    private static final int POST_BOTTOM_MARGIN_DP = 24;
    private static final int POST_LINE_SPACING_DP = 4;
    private static final int DEFAULT_LINE_SPACING_DP = 2;

    public ParagraphView(Context context, StyleType style, BlockAlignment alignment, AppConfig appConfig) {
        super(context);
        BlockUtils.createLayoutParams((View)this, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)this);
        this.setLineSpacing(ScreenUtils.dpToPx((float)2.0f, (Context)context), 1.0f);
        this.setTextSize(16.0f);
        this.setTextIsSelectable(false);
        this.setEllipsize(TextUtils.TruncateAt.END);
        this.setScrollContainer(false);
        this.setFocusable(false);
        this.setClickable(false);
        this.setLongClickable(false);
        this.setGravity(alignment.getGravity());
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
        int primaryColor = appConfig.getPrimaryColor();
        switch (style) {
            case ADMIN: {
                this.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
                this.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_800));
                this.setLinkTextColor(primaryColor);
                break;
            }
            case ARTICLE: {
                this.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
                this.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_700));
                this.setLinkTextColor(ColorUtils.primaryOrDarkColor(context, appConfig));
                break;
            }
            case NOTE: 
            case CONTAINER_CARD: {
                this.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
                this.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_700));
                this.setLinkTextColor(primaryColor);
                break;
            }
            case POST: {
                params.bottomMargin = ScreenUtils.dpToPx((float)24.0f, (Context)context);
                this.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
                this.setLineSpacing(ScreenUtils.dpToPx((float)4.0f, (Context)context), 1.0f);
                this.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_white));
                this.setLinkTextColor(ColorUtils.lightenColor(primaryColor));
                break;
            }
            case CHAT_FULL: {
                this.setTextSize(14.0f);
                this.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_600));
                this.setLinkTextColor(primaryColor);
                break;
            }
            default: {
                this.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
                this.setIncludeFontPadding(false);
                ColorUtils.setTextColorWhiteOrDark((TextView)this, appConfig.primaryColorRenderDarkText());
            }
        }
    }
}

