/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.messengercard;

import android.annotation.SuppressLint;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.view.View;
import android.webkit.WebSettings;
import android.webkit.WebView;
import io.intercom.android.sdk.blocks.messengercard.CardWebView;
import io.intercom.android.sdk.blocks.messengercard.MessengerCardWebViewClient;
import io.intercom.android.sdk.blocks.messengercard.MessengerCardWebViewInterface;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.com.google.gson.Gson;
import io.intercom.com.squareup.otto.Bus;

class MessengerCardWebViewPresenter {
    private final CardWebView webView;
    private final View loadingView;
    private final String fallbackUrl;
    private final Bus bus;
    @ColorInt
    private final int baseColor;
    private final Gson gson;
    private final MetricTracker metricTracker;
    private final String conversationId;

    MessengerCardWebViewPresenter(CardWebView webView, View loadingView, String fallbackUrl, Bus bus, @ColorInt int baseColor, Gson gson, MetricTracker metricTracker, String conversationId) {
        this.webView = webView;
        this.loadingView = loadingView;
        this.fallbackUrl = fallbackUrl;
        this.bus = bus;
        this.baseColor = baseColor;
        this.gson = gson;
        this.metricTracker = metricTracker;
        this.conversationId = conversationId;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    void setUpWebView() {
        this.webView.setUp(this.bus);
        this.webView.setBackgroundColor(0);
        this.webView.setWebViewClient(new MessengerCardWebViewClient(Uri.parse((String)this.fallbackUrl).getHost(), this.loadingView));
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setUseWideViewPort(true);
        this.webView.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        this.webView.setVerticalScrollBarEnabled(false);
        this.webView.setHorizontalScrollBarEnabled(false);
        MessengerCardWebViewInterface cardWebViewInterface = new MessengerCardWebViewInterface(this.webView, this.gson, this.baseColor, this.metricTracker, this.conversationId);
        this.webView.addJavascriptInterface(cardWebViewInterface, "AndroidHost");
    }
}

