/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.messengercard;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import android.widget.AutoCompleteTextView;
import io.intercom.android.sdk.R;
import java.util.Map;

class MessengerCardAlertDialogBuilder
extends AlertDialog.Builder {
    MessengerCardAlertDialogBuilder(@NonNull Context context, @NonNull Map<String, Object> payload, int baseColor, @NonNull WebView webView) {
        super(context);
        this.setUp(context, payload, baseColor, webView);
    }

    private void setUp(Context context, final Map<String, Object> payload, int baseColor, final WebView webView) {
        View viewInflated = LayoutInflater.from((Context)context).inflate(R.layout.intercom_webview_card_input, null, false);
        this.setTitle((CharSequence)payload.get("label"));
        final AutoCompleteTextView inputView = (AutoCompleteTextView)viewInflated.findViewById(R.id.input);
        inputView.setText((CharSequence)payload.get("currentValue"));
        inputView.setHint((CharSequence)payload.get("placeholder"));
        ColorStateList colorStateList = ColorStateList.valueOf((int)baseColor);
        ViewCompat.setBackgroundTintList((View)inputView, (ColorStateList)colorStateList);
        this.setView(viewInflated);
        this.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                String javascriptEvent = "window.fallbackApp.bridgeEvent('UPDATE_TEXT', { value:'" + inputView.getText() + "', id:'" + payload.get("id") + "'})";
                if (Build.VERSION.SDK_INT >= 19) {
                    webView.evaluateJavascript(javascriptEvent, null);
                } else {
                    webView.loadUrl("javascript:" + javascriptEvent);
                }
                InputMethodManager inputMethodManager = (InputMethodManager)inputView.getContext().getSystemService("input_method");
                inputMethodManager.hideSoftInputFromWindow(inputView.getWindowToken(), 0);
                dialog.dismiss();
            }
        });
        this.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                InputMethodManager inputMethodManager = (InputMethodManager)inputView.getContext().getSystemService("input_method");
                inputMethodManager.hideSoftInputFromWindow(inputView.getWindowToken(), 0);
                dialog.cancel();
            }
        });
    }
}

