/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.widget.ImageView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.views.ResizableImageView;
import io.intercom.com.bumptech.glide.RequestBuilder;
import io.intercom.com.bumptech.glide.request.RequestOptions;

class Image {
    private final StyleType style;

    Image(StyleType style2) {
        this.style = style2;
    }

    protected StyleType getStyle() {
        return this.style;
    }

    protected void setImageViewBounds(int imageWidth, int imageHeight, ResizableImageView imageView, RequestBuilder requestBuilder) {
        int totalViewPadding = this.getTotalViewPadding(imageView.getContext());
        imageView.setTotalViewPadding(totalViewPadding);
        imageView.setDisplayImageDimensions(imageWidth, imageHeight);
        Point dimens = imageView.getImageDimens();
        if (dimens.x > 0 && dimens.y > 0) {
            requestBuilder.apply(new RequestOptions().override(dimens.x, dimens.y));
        }
    }

    protected void setBackground(ImageView imageView) {
        imageView.setBackgroundResource(R.drawable.intercom_rounded_image_preview);
    }

    private int getTotalViewPadding(Context context) {
        Resources resources = context.getResources();
        switch (this.style) {
            case USER: 
            case ADMIN: 
            case PREVIEW: {
                float rowIcon = resources.getDimension(R.dimen.intercom_avatar_size);
                float iconSpacer = resources.getDimension(R.dimen.intercom_conversation_row_icon_spacer);
                float rowEndMargin = resources.getDimension(R.dimen.intercom_conversation_row_margin);
                float rowInitialPadding = resources.getDimension(R.dimen.intercom_cell_horizontal_padding);
                return (int)(rowIcon + iconSpacer + rowEndMargin + rowInitialPadding * 3.0f);
            }
            case POST: {
                float generalPadding = resources.getDimension(R.dimen.intercom_cell_content_padding);
                float postPadding = resources.getDimension(R.dimen.intercom_post_cell_padding);
                return (int)(generalPadding + postPadding) * 2;
            }
            case NOTE: {
                float generalPadding = resources.getDimension(R.dimen.intercom_cell_content_padding);
                float notePadding = resources.getDimension(R.dimen.intercom_note_cell_padding);
                float noteLayoutMargin = resources.getDimension(R.dimen.intercom_note_layout_margin);
                return (int)(generalPadding + notePadding + noteLayoutMargin) * 2;
            }
            case CONTAINER_CARD: {
                float generalPadding = resources.getDimension(R.dimen.intercom_cell_content_padding);
                float containerPadding = resources.getDimension(R.dimen.intercom_note_cell_padding);
                float containerLayoutMargin = resources.getDimension(R.dimen.intercom_note_layout_margin);
                return (int)(generalPadding + containerPadding + containerLayoutMargin) * 2;
            }
            case CHAT_FULL: {
                return this.calculateChatFullPadding(context);
            }
        }
        return 0;
    }

    private int calculateChatFullPadding(Context context) {
        Resources resources = context.getResources();
        float chatBubbleWidth = resources.getDimension(R.dimen.intercom_chat_overlay_width);
        float chatBubblePadding = resources.getDimension(R.dimen.intercom_chat_overlay_padding_right);
        float textContainerMargin = resources.getDimension(R.dimen.intercom_chat_overlay_text_margin_left);
        float textContainerPaddingLeft = resources.getDimension(R.dimen.intercom_chat_overlay_text_padding_left);
        float textContainerPaddingRight = resources.getDimension(R.dimen.intercom_chat_overlay_text_padding_right);
        float offsets = chatBubblePadding + textContainerMargin + textContainerPaddingLeft + textContainerPaddingRight;
        int screenWidth = ScreenUtils.getScreenDimensions((Context)context).x;
        return (int)((float)screenWidth - (chatBubbleWidth - offsets));
    }
}

