/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.module;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import io.intercom.com.bumptech.glide.module.GlideModule;
import java.util.ArrayList;
import java.util.List;

public final class ManifestParser {
    private static final String TAG = "ManifestParser";
    private static final String GLIDE_MODULE_VALUE = "GlideModule";
    private final Context context;

    public ManifestParser(Context context) {
        this.context = context;
    }

    public List<GlideModule> parse() {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"Loading Glide modules");
        }
        ArrayList<GlideModule> modules = new ArrayList<GlideModule>();
        try {
            ApplicationInfo appInfo = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
            if (appInfo.metaData == null) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)"Got null app info metadata");
                }
                return modules;
            }
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("Got app info metadata: " + appInfo.metaData));
            }
            for (String key : appInfo.metaData.keySet()) {
                if (!GLIDE_MODULE_VALUE.equals(appInfo.metaData.get(key))) continue;
                modules.add(ManifestParser.parseModule(key));
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)("Loaded Glide module: " + key));
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Unable to find metadata to parse GlideModules", e);
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"Finished loading Glide modules");
        }
        return modules;
    }

    private static GlideModule parseModule(String className) {
        Object module;
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to find GlideModule implementation", e);
        }
        try {
            module = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate GlideModule implementation for " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to instantiate GlideModule implementation for " + clazz, e);
        }
        if (!(module instanceof GlideModule)) {
            throw new RuntimeException("Expected instanceof GlideModule, but found: " + module);
        }
        return (GlideModule)module;
    }
}

