/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;

public class UploadProgressBar
extends View {
    private static final int MAX = 100;
    private static final int STROKE_WIDTH = 8;
    private static final int START_ANGLE = -90;
    private final RectF rectF;
    private final Paint backgroundPaint;
    private final Paint foregroundPaint;
    private final Twig twig = LumberMill.getLogger();
    private int progress = 0;

    public UploadProgressBar(Context context) {
        this(context, null);
    }

    public UploadProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.rectF = new RectF();
        this.backgroundPaint = new Paint(1);
        this.backgroundPaint.setColor(-2013265920);
        this.backgroundPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.backgroundPaint.setStrokeWidth(8.0f);
        this.foregroundPaint = new Paint(1);
        this.foregroundPaint.setColor(-1);
        this.foregroundPaint.setStyle(Paint.Style.STROKE);
        this.foregroundPaint.setStrokeWidth(8.0f);
    }

    public void setProgress(int progress) {
        this.twig.internal("animation", "received progress of  " + progress);
        if (progress > this.progress) {
            this.progress = progress;
            this.invalidate();
        }
    }

    private void showBar() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(300L);
        objectAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        objectAnimator.start();
    }

    public void hideBar() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{1.0f, 0.0f}).setDuration(300L);
        objectAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        objectAnimator.start();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float angle = 360 * this.progress / 100;
        canvas.drawOval(this.rectF, this.backgroundPaint);
        canvas.drawArc(this.rectF, -90.0f, angle, false, this.foregroundPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = UploadProgressBar.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        int width = UploadProgressBar.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int min = Math.min(width, height);
        this.setMeasuredDimension(min, min);
        this.rectF.set(4.0f, 4.0f, (float)(min - 4), (float)(min - 4));
    }

    public void smoothStartAnimation() {
        if (this.getAlpha() < 1.0f) {
            this.showBar();
        }
        this.twig.internal("animation", "starting upload start animation");
        ObjectAnimator animator = ObjectAnimator.ofInt((Object)((Object)this), (String)"progress", (int[])new int[]{0, 10});
        animator.setDuration(1000L);
        animator.start();
    }

    public void smoothEndAnimation() {
        ObjectAnimator animator = this.getObjectAnimator();
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                UploadProgressBar.this.hideBar();
            }
        });
        animator.start();
    }

    public void smoothEndAnimation(Animator.AnimatorListener is) {
        ObjectAnimator animator = this.getObjectAnimator();
        animator.addListener(is);
        animator.start();
    }

    private ObjectAnimator getObjectAnimator() {
        this.twig.internal("animation", "starting upload end animation");
        return ObjectAnimator.ofInt((Object)((Object)this), (String)"progress", (int[])new int[]{90, 99}).setDuration(1000L);
    }
}

