/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.AppTypeDetector;
import io.intercom.android.sdk.metrics.MetricInterface;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.metrics.ops.OpsMetricObject;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.com.google.gson.Gson;
import io.intercom.okio.BufferedSink;
import io.intercom.okio.BufferedSource;
import io.intercom.okio.Okio;
import io.intercom.okio.Sink;
import io.intercom.okio.Source;
import io.intercom.retrofit2.Call;
import io.intercom.retrofit2.Callback;
import io.intercom.retrofit2.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class MetricsStore {
    private static final Executor EXECUTOR = Executors.newSingleThreadExecutor();
    private static final String METRICS_DISK_CACHE = "intercomMetricsDiskCache";
    private static final String OPS_METRICS_DISK_CACHE = "intercomOpsMetricsDiskCache";
    private static final String DELIMITER = "~";
    @VisibleForTesting
    final List<MetricObject> metrics = new ArrayList<MetricObject>();
    @VisibleForTesting
    final List<OpsMetricObject> opsMetrics = new ArrayList<OpsMetricObject>();
    final Context context;
    final Provider<Api> apiProvider;
    final String installerPackageName;
    final boolean isDebugBuild;
    final Gson gson = new Gson();
    private final Provider<AppConfig> appConfigProvider;
    private final Executor executor;
    private final Twig twig = LumberMill.getLogger();

    public MetricsStore(Context context, Provider<Api> apiProvider, Provider<AppConfig> appConfigProvider) {
        this(context, apiProvider, appConfigProvider, EXECUTOR);
    }

    @VisibleForTesting
    MetricsStore(Context context, Provider<Api> apiProvider, Provider<AppConfig> appConfigProvider, Executor executor) {
        this.context = context;
        this.apiProvider = apiProvider;
        this.appConfigProvider = appConfigProvider;
        this.executor = executor;
        this.isDebugBuild = AppTypeDetector.isDebugBuild(context);
        this.installerPackageName = AppTypeDetector.getInstallerPackageName(context);
    }

    public void track(final MetricObject metric) {
        if (this.isDisabled()) {
            this.twig.internal("Metrics have been remotely disabled");
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                MetricsStore.this.metrics.add(metric.addInstallerPackageName(MetricsStore.this.installerPackageName).addIsDebugBuild(MetricsStore.this.isDebugBuild));
                MetricsStore.this.persistMetric(metric, MetricsStore.METRICS_DISK_CACHE);
            }
        });
    }

    public void track(final OpsMetricObject opsMetric) {
        if (this.isDisabled()) {
            this.twig.internal("Metrics have been remotely disabled");
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                MetricsStore.this.opsMetrics.add(opsMetric);
                MetricsStore.this.persistMetric(opsMetric, MetricsStore.OPS_METRICS_DISK_CACHE);
            }
        });
    }

    private boolean isDisabled() {
        return !this.appConfigProvider.get().isMetricsEnabled();
    }

    public void loadAndSendCachedMetrics() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    MetricsStore.this.readMetricsFromDisk();
                    MetricsStore.this.sendMetrics();
                }
                catch (IOException e) {
                    MetricsStore.this.twig.internal("Couldn't read metric from disk: " + e.getMessage());
                }
            }
        });
    }

    public void sendMetrics() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (MetricsStore.this.metrics.isEmpty() && MetricsStore.this.opsMetrics.isEmpty()) {
                    return;
                }
                final ArrayList<MetricObject> sentMetrics = new ArrayList<MetricObject>(MetricsStore.this.metrics);
                final ArrayList<OpsMetricObject> sentOpsMetrics = new ArrayList<OpsMetricObject>(MetricsStore.this.opsMetrics);
                MetricsStore.this.apiProvider.get().sendMetrics(sentMetrics, sentOpsMetrics, new Callback<Void>(){

                    public void onResponse(Call<Void> call, Response<Void> response) {
                        if (response.isSuccessful()) {
                            MetricsStore.this.executor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    MetricsStore.this.cleanUpMetrics(sentMetrics, sentOpsMetrics);
                                }
                            });
                        }
                    }

                    public void onFailure(Call<Void> call, Throwable t) {
                    }
                });
            }
        });
    }

    @WorkerThread
    @VisibleForTesting
    void cleanUpMetrics(List<MetricObject> sentMetrics, List<OpsMetricObject> sentOpsMetrics) {
        this.metrics.removeAll(sentMetrics);
        this.opsMetrics.removeAll(sentOpsMetrics);
        this.context.deleteFile(METRICS_DISK_CACHE);
        this.context.deleteFile(OPS_METRICS_DISK_CACHE);
        if (!this.metrics.isEmpty()) {
            for (MetricObject metricObject : this.metrics) {
                this.persistMetric(metricObject, METRICS_DISK_CACHE);
            }
        }
        if (!this.opsMetrics.isEmpty()) {
            for (OpsMetricObject opsMetricObject : this.opsMetrics) {
                this.persistMetric(opsMetricObject, OPS_METRICS_DISK_CACHE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @VisibleForTesting
    void persistMetric(MetricInterface metric, String path) {
        try (BufferedSink bufferedSink = null;){
            bufferedSink = Okio.buffer((Sink)Okio.sink((OutputStream)this.context.openFileOutput(path, 32768)));
            String json = metric.toJson(this.gson);
            bufferedSink.writeUtf8(json + DELIMITER);
            this.twig.internal("Persisted metric: " + json);
            bufferedSink.flush();
        }
        catch (IOException e) {
            this.twig.internal("Couldn't persist metric to disk: " + e.getMessage());
        }
    }

    @WorkerThread
    void readMetricsFromDisk() throws IOException {
        this.getMetrics(this.loadObjectsAsJson(METRICS_DISK_CACHE), MetricObject.class);
        this.getMetrics(this.loadObjectsAsJson(OPS_METRICS_DISK_CACHE), OpsMetricObject.class);
    }

    @WorkerThread
    private void getMetrics(String[] objects, Class<?> metricClass) {
        for (String object : objects) {
            try {
                if (metricClass == MetricObject.class) {
                    this.metrics.add((MetricObject)this.gson.fromJson(object, MetricObject.class));
                    continue;
                }
                this.opsMetrics.add((OpsMetricObject)this.gson.fromJson(object, OpsMetricObject.class));
            }
            catch (Exception e) {
                this.twig.internal("Could not parse metric: " + object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private String[] loadObjectsAsJson(String path) throws IOException {
        String file;
        try (BufferedSource bufferedSource = null;){
            bufferedSource = Okio.buffer((Source)Okio.source((InputStream)this.context.openFileInput(path)));
            file = bufferedSource.readUtf8();
        }
        return file.split(DELIMITER);
    }
}

