/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.api.CallbackHolder;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.api.MessengerApi;
import io.intercom.android.sdk.api.ProgressRequestBody;
import io.intercom.android.sdk.api.RateLimiter;
import io.intercom.android.sdk.api.UserUpdateRequest;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.metrics.ops.OpsMetricObject;
import io.intercom.android.sdk.models.GifResponse;
import io.intercom.android.sdk.models.LinkResponse;
import io.intercom.android.sdk.models.UpdateUserResponse;
import io.intercom.android.sdk.models.Upload;
import io.intercom.android.sdk.models.events.UploadEvent;
import io.intercom.android.sdk.models.events.failure.UploadFailedEvent;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.user.DeviceData;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.okhttp3.Dispatcher;
import io.intercom.okhttp3.MediaType;
import io.intercom.okhttp3.MultipartBody;
import io.intercom.okhttp3.OkHttpClient;
import io.intercom.okhttp3.Request;
import io.intercom.okhttp3.RequestBody;
import io.intercom.okhttp3.Response;
import io.intercom.retrofit2.Call;
import io.intercom.retrofit2.Callback;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class Api {
    private static final String USER = "user";
    private static final String DEVICE_TOKEN = "device_token";
    private static final String USER_ATTRIBUTES = "user_attributes";
    private static final String DEVICE_DATA = "device_data";
    private static final String NEW_SESSION = "new_session";
    private static final String HMAC = "hmac";
    private static final String DATA = "data";
    private static final String UPLOAD = "upload";
    private static final String SENT_FROM_BACKGROUND = "sent_from_background";
    private static final String BATCH_SIZE = "batch_size";
    private static final Twig TWIG = LumberMill.getLogger();
    final CallbackHolder callbacks;
    private final Context context;
    private final AppIdentity appIdentity;
    private final Provider<AppConfig> appConfigProvider;
    final UserIdentity userIdentity;
    final OkHttpClient httpClient = new OkHttpClient();
    final Bus bus;
    private final MessengerApi messengerApi;
    private final OkHttpClient apiHttpClient;
    private final int defaultOkHttpMaxRequests;
    private final RateLimiter rateLimiter;
    private final Store<State> store;
    private final Callback<Void> emptyCallback = new Callback<Void>(){

        public void onResponse(Call<Void> call, io.intercom.retrofit2.Response<Void> response) {
        }

        public void onFailure(Call<Void> call, Throwable t) {
        }
    };

    public Api(Context context, AppIdentity appIdentity, UserIdentity userIdentity, Bus bus, OkHttpClient httpClient, MessengerApi messengerApi, CallbackHolder callbacks, RateLimiter rateLimiter, Store<State> store, Provider<AppConfig> appConfigProvider) {
        this.context = context;
        this.appIdentity = appIdentity;
        this.userIdentity = userIdentity;
        this.bus = bus;
        this.messengerApi = messengerApi;
        this.callbacks = callbacks;
        this.rateLimiter = rateLimiter;
        this.store = store;
        this.appConfigProvider = appConfigProvider;
        this.apiHttpClient = httpClient;
        this.defaultOkHttpMaxRequests = httpClient.dispatcher().getMaxRequests();
        this.updateMaxRequests();
    }

    public void updateMaxRequests() {
        int maxRequests = this.userIdentity.hasIntercomId() ? this.defaultOkHttpMaxRequests : 1;
        Dispatcher dispatcher = this.apiHttpClient.dispatcher();
        if (dispatcher.getMaxRequests() != maxRequests) {
            dispatcher.setMaxRequests(maxRequests);
        }
    }

    public void setDeviceToken(String deviceToken) {
        Map<String, Object> deviceData = DeviceData.generateDeviceData(this.context);
        deviceData.put(DEVICE_TOKEN, deviceToken);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put(DEVICE_DATA, deviceData);
        this.addSecureHash(params);
        this.messengerApi.setDeviceToken(params).enqueue(this.emptyCallback);
    }

    public void removeDeviceToken(String token) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put(DEVICE_TOKEN, token);
        this.addSecureHash(params);
        this.messengerApi.deleteDeviceToken(params).enqueue(this.emptyCallback);
    }

    public void updateUser(UserUpdateRequest userUpdateRequest) {
        boolean shouldLimitUpdate;
        boolean bl = shouldLimitUpdate = !userUpdateRequest.isInternalUpdate();
        if (shouldLimitUpdate) {
            if (this.rateLimiter.isLimited()) {
                this.rateLimiter.logError();
                return;
            }
            if (this.shouldStopBackgroundRequest(userUpdateRequest.isSentFromBackground())) {
                this.logBackgroundDisabledError();
                return;
            }
            this.rateLimiter.recordRequest();
        }
        this.retriableUpdateUser(this.generateUpdateUserParams(userUpdateRequest));
    }

    @VisibleForTesting
    void retriableUpdateUser(Map<String, Object> params) {
        this.retriableUpdateUser(params, this.userIdentity.getFingerprint());
    }

    private void retriableUpdateUser(final Map<String, Object> params, final String fingerprint) {
        this.messengerApi.updateUser(params).enqueue((Callback)new BaseCallback<UpdateUserResponse.Builder>(){

            @Override
            public void onSuccess(UpdateUserResponse.Builder builder) {
                if (fingerprint.equals(Api.this.userIdentity.getFingerprint())) {
                    TWIG.i("Successfully registered or updated user", new Object[0]);
                    Api.this.callbacks.unreadCallback().onSuccess(builder);
                    Api.this.callbacks.teamPresenceCallback().onSuccess(builder);
                }
            }

            @Override
            public void onError(ErrorObject errorObject) {
                Map user = (Map)params.get(Api.USER);
                if (Api.isUserNotFound(errorObject, user)) {
                    user.remove("intercom_id");
                    params.put(Api.USER, user);
                    Api.this.retriableUpdateUser(params, fingerprint);
                }
            }

            @Override
            void logFailure(String reason, ErrorObject error) {
                super.logFailure("Failed to register or update user", error);
            }
        });
    }

    public void logEvent(String name, Map<String, ?> metaData) {
        if (this.rateLimiter.isLimited()) {
            this.rateLimiter.logError();
            return;
        }
        boolean appBackgrounded = this.store.select(Selectors.APP_IS_BACKGROUNDED);
        if (this.shouldStopBackgroundRequest(appBackgrounded)) {
            this.logBackgroundDisabledError();
            return;
        }
        this.rateLimiter.recordRequest();
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        eventParams.put("event_name", name);
        if (!metaData.isEmpty()) {
            eventParams.put("metadata", metaData);
        }
        params.put("event", eventParams);
        params.put(SENT_FROM_BACKGROUND, appBackgrounded);
        this.addSecureHash(params);
        this.messengerApi.logEvent(params).enqueue(this.callbacks.unreadCallback());
    }

    public void markConversationAsRead(String conversationId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.appId());
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.messengerApi.markAsRead(conversationId, params).enqueue(this.callbacks.readCallback());
    }

    public void markConversationAsDismissed(String conversationId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("conversation_ids", new String[]{conversationId});
        this.addSecureHash(params);
        this.messengerApi.markAsDismissed(params).enqueue(this.emptyCallback);
    }

    public void getInbox() {
        Map<String, Object> params = this.userIdentity.toMap();
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.messengerApi.getConversations(params).enqueue(this.callbacks.inboxCallback());
    }

    public void getInboxBefore(long before) {
        Map<String, Object> params = this.userIdentity.toMap();
        params.put("before", String.valueOf(before));
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.messengerApi.getConversations(params).enqueue(this.callbacks.inboxCallback());
    }

    public void getUnreadConversations() {
        Map<String, Object> params = this.userIdentity.toMap();
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.messengerApi.getUnreadConversations(params).enqueue(this.callbacks.unreadCallback());
    }

    public void getConversation(String conversationId) {
        Map<String, Object> params = this.userIdentity.toMap();
        this.addSecureHash(params);
        this.messengerApi.getConversation(conversationId, params).enqueue(this.callbacks.conversationCallback());
    }

    public void fetchDefaultGifs(Callback<GifResponse> callback) {
        this.fetchGifs(null, callback);
    }

    public void fetchGifs(@Nullable String query, Callback<GifResponse> callback) {
        this.messengerApi.getGifs(query).enqueue(callback);
    }

    public void replyToConversation(String conversationId, List<Block.Builder> blocks, int tempPartPosition, String tempPartId, boolean isUpload) {
        Map<String, Object> params = this.createBaseReplyParams();
        params.put("blocks", blocks);
        this.messengerApi.replyToConversation(conversationId, params).enqueue(this.callbacks.replyCallback(tempPartPosition, isUpload, tempPartId, conversationId));
    }

    private Map<String, Object> createBaseReplyParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.appId());
        params.put("type", USER);
        params.put("message_type", "comment");
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        return params;
    }

    public void reactToConversation(String conversationId, int reactionIndex) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("reaction_index", reactionIndex);
        this.addSecureHash(params);
        this.messengerApi.reactToConversation(conversationId, params).enqueue(this.callbacks.reactCallback());
    }

    public void startNewConversation(List<Block.Builder> blocks, int position, String tempPartId) {
        Map<String, Object> params = this.baseNewConversationParams();
        params.put("blocks", blocks);
        this.messengerApi.startNewConversation(params).enqueue(this.callbacks.newConversationCallback(position, tempPartId));
    }

    private Map<String, Object> baseNewConversationParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.appId());
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        return params;
    }

    public void uploadFile(final GalleryImage data, final int tempPartPosition, final String tempPartId, final UploadingImageCache uploadingImageCache, final UploadProgressListener listener) {
        final String originalFileName = data.getFileName();
        final String mimeType = data.getMimeType();
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> uploadMap = new HashMap<String, Object>();
        uploadMap.put("original_filename", originalFileName);
        uploadMap.put("size_in_bytes", data.getFileSize());
        uploadMap.put("content_type", mimeType);
        uploadMap.put("width", data.getImageWidth());
        uploadMap.put("height", data.getImageHeight());
        params.put(UPLOAD, uploadMap);
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.messengerApi.uploadFile(params).enqueue((Callback)new BaseCallback<Upload.Builder>(){

            @Override
            public void onSuccess(Upload.Builder builder) {
                final Upload uploadResponse = builder.build();
                uploadingImageCache.put(uploadResponse, data);
                MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("key", uploadResponse.getKey()).addFormDataPart("acl", uploadResponse.getAcl()).addFormDataPart("Content-Type", uploadResponse.getContentType()).addFormDataPart("AWSAccessKeyId", uploadResponse.getAwsAccessKey()).addFormDataPart("policy", uploadResponse.getPolicy()).addFormDataPart("signature", uploadResponse.getSignature()).addFormDataPart("success_action_status", uploadResponse.getSuccessActionStatus()).addFormDataPart("file", originalFileName, (RequestBody)new ProgressRequestBody(MediaType.parse((String)mimeType), data.buildFile(), listener)).build();
                Api.this.httpClient.newCall(new Request.Builder().url(uploadResponse.getUploadDestination()).post((RequestBody)requestBody).build()).enqueue(new io.intercom.okhttp3.Callback(){

                    public void onFailure(io.intercom.okhttp3.Call call, IOException e) {
                        TWIG.e("Upload failed: " + e.getMessage(), new Object[0]);
                        Api.this.bus.post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
                    }

                    public void onResponse(io.intercom.okhttp3.Call call, Response response) throws IOException {
                        TWIG.internal("API Success", "Successfully uploaded");
                        if (response.isSuccessful()) {
                            Api.this.bus.post((Object)new UploadEvent(uploadResponse, data.getFileSize(), tempPartPosition, tempPartId));
                        } else {
                            TWIG.e("Upload failed: request body " + response.body(), new Object[0]);
                            Api.this.bus.post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
                        }
                        response.body().close();
                    }
                });
                TWIG.internal("API Success", "Successfully uploaded");
            }

            @Override
            public void onError(ErrorObject errorObject) {
                Api.this.bus.post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
            }

            @Override
            void logFailure(String reason, ErrorObject error) {
                super.logFailure("Upload failed", error);
            }
        });
    }

    public void getLink(String linkId, Callback<LinkResponse.Builder> callback) {
        Map<String, Object> params = this.userIdentity.toMap();
        this.addSecureHash(params);
        this.messengerApi.getLink(linkId, params).enqueue(callback);
    }

    public void reactToLink(String linkId, int reactionIndex) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("reaction_index", reactionIndex);
        this.addSecureHash(params);
        this.messengerApi.reactToLink(linkId, params).enqueue(this.callbacks.reactCallback());
    }

    public void sendMetrics(List<MetricObject> metrics, List<OpsMetricObject> opsMetrics, Callback<Void> callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("metrics", metrics);
        params.put("op_metrics", opsMetrics);
        this.messengerApi.sendMetrics(params).enqueue(callback);
    }

    public void getVideo(String url, io.intercom.okhttp3.Callback callback) {
        this.httpClient.newCall(new Request.Builder().url(url).build()).enqueue(callback);
    }

    public void hitTrackingUrl(String url) {
        this.httpClient.newCall(new Request.Builder().url(url).build()).enqueue(new io.intercom.okhttp3.Callback(){

            public void onFailure(io.intercom.okhttp3.Call call, IOException e) {
                TWIG.internal("Tracking Url", "Failed tracking url request");
            }

            public void onResponse(io.intercom.okhttp3.Call call, Response response) throws IOException {
                TWIG.internal("Tracking Url", "success");
                response.body().close();
            }
        });
    }

    protected static boolean isUserNotFound(ErrorObject error, Map userParams) {
        if (error.hasErrorBody() && error.getStatusCode() == 404 && userParams != null && userParams.get("intercom_id") != null && userParams.size() > 1) {
            try {
                JSONObject errorObject = new JSONObject(error.getErrorBody());
                if (errorObject.getJSONArray("errors").getJSONObject(0).getString("code").equals("not_found")) {
                    return true;
                }
            }
            catch (Exception ignored) {
                TWIG.internal("Could not parse error response");
            }
        }
        return false;
    }

    private void addSecureHash(Map<String, Object> params) {
        String data = this.userIdentity.getData();
        String hmac = this.userIdentity.getHmac();
        if (!TextUtils.isEmpty((CharSequence)data)) {
            params.put(DATA, data);
        }
        if (!TextUtils.isEmpty((CharSequence)hmac)) {
            params.put(HMAC, hmac);
        }
    }

    private Map<String, Object> generateUpdateUserParams(UserUpdateRequest userUpdateRequest) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put(DEVICE_DATA, DeviceData.generateDeviceData(this.context));
        params.put(NEW_SESSION, userUpdateRequest.isNewSession());
        params.put(SENT_FROM_BACKGROUND, userUpdateRequest.isSentFromBackground());
        params.put(BATCH_SIZE, userUpdateRequest.getBatchSize());
        params.put(USER_ATTRIBUTES, userUpdateRequest.getAttributes());
        this.addSecureHash(params);
        return params;
    }

    private boolean shouldStopBackgroundRequest(boolean background) {
        return background && this.appConfigProvider.get().backgroundRequestsDisabled();
    }

    private void logBackgroundDisabledError() {
        TWIG.e("Your request was not sent because the app is in the background. Please contact Intercom to enable background requests.", new Object[0]);
    }

    @VisibleForTesting
    boolean isSynchronous() {
        return this.apiHttpClient.dispatcher().getMaxRequests() == 1;
    }

    @VisibleForTesting
    public void setIdleCallback(Runnable idleCallback) {
        this.apiHttpClient.dispatcher().setIdleCallback(idleCallback);
    }

    @VisibleForTesting
    public boolean isIdle() {
        return this.apiHttpClient.dispatcher().runningCallsCount() == 0;
    }
}

