/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.support.annotation.NonNull;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebViewConversationAction {
    public static final String SET_CONVERSATION = "SET_CONVERSATION";
    public static final String CREATE_PART = "CREATE_PART";
    public static final String CREATE_UPLOAD = "CREATE_UPLOAD";
    public static final String PART_CREATED = "PART_CREATED";
    public static final String ADMIN_IS_TYPING = "ADMIN_IS_TYPING";
    public static final String CONVERSATION_CHANGED = "CONVERSATION_CHANGED";
    public static final String IMAGE_CLICKED = "IMAGE_CLICKED";
    public static final String ARTICLE_CARD_CLICKED = "ARTICLE_CARD_CLICKED";
    public static final String POST_CARD_CLICKED = "POST_CARD_CLICKED";
    private final String type;
    private final Map<String, Object> value;

    public WebViewConversationAction(@NonNull String type, @NonNull Map<String, Object> value) {
        this.type = type;
        this.value = value;
    }

    public static WebViewConversationAction setConversation(AppIdentity appIdentity, UserIdentity userIdentity, Provider<AppConfig> appConfigProvider, String conversationId) {
        HashMap<String, String> session = new HashMap<String, String>();
        session.put("appId", appIdentity.appId());
        if (!userIdentity.getUserId().isEmpty()) {
            session.put("userId", userIdentity.getUserId());
        }
        if (!userIdentity.getEmail().isEmpty()) {
            session.put("email", userIdentity.getEmail());
        }
        if (!userIdentity.getAnonymousId().isEmpty()) {
            session.put("userId", userIdentity.getAnonymousId());
        }
        if (!userIdentity.getHmac().isEmpty()) {
            session.put("userHash", userIdentity.getHmac());
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("session", session);
        value.put("conversationId", conversationId);
        value.put("locale", appConfigProvider.get().getLocale());
        value.put("appColor", String.format("#%06X", 0xFFFFFF & appConfigProvider.get().getBaseColor()));
        value.put("appName", appConfigProvider.get().getName());
        return new WebViewConversationAction(SET_CONVERSATION, value);
    }

    public static WebViewConversationAction createPart(List<Block.Builder> blockBuilders) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("body", blockBuilders);
        return new WebViewConversationAction(CREATE_PART, value);
    }

    public static WebViewConversationAction createUpload(String fileName, String mimeType, String base64Image) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("mimeType", mimeType);
        value.put("fileName", fileName);
        value.put("data", base64Image);
        return new WebViewConversationAction(CREATE_UPLOAD, value);
    }

    public static WebViewConversationAction partCreated() {
        return new WebViewConversationAction(PART_CREATED, new HashMap<String, Object>());
    }

    public static WebViewConversationAction adminIsTyping(String adminId, String firstName, String avatarUrl) {
        HashMap<String, Object> typingValue = new HashMap<String, Object>();
        typingValue.put("adminId", adminId);
        typingValue.put("firstName", firstName);
        typingValue.put("avatarUrl", avatarUrl);
        return new WebViewConversationAction(ADMIN_IS_TYPING, typingValue);
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getValue() {
        return this.value;
    }
}

