/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.widget.FrameLayout;
import com.intercom.composer.ComposerFragment;
import com.intercom.composer.ComposerHost;
import com.intercom.composer.OnInputSelectedListener;
import com.intercom.composer.input.Input;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.composer.InputDrawableManager;
import io.intercom.android.sdk.conversation.composer.InputProvider;
import io.intercom.android.sdk.conversation.composer.galleryinput.GalleryInputManager;
import io.intercom.android.sdk.conversation.composer.textinput.TextInputManager;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.nexus.NexusClient;
import java.util.ArrayList;
import java.util.List;

public class ComposerPresenter
implements OnInputSelectedListener {
    private static final int SELECT_INPUT_DELAY_MS = 100;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final Runnable defaultInputRunnable = new Runnable(){

        @Override
        public void run() {
            ComposerPresenter.this.composerFragment.selectInput("text_input", true);
        }
    };
    private final FrameLayout composerLayout;
    private final TextInputManager textInputManager;
    private final GalleryInputManager galleryInputManager;
    private final InputDrawableManager inputDrawableManager;
    private final ComposerFragment composerFragment;
    private final MetricTracker metricTracker;
    private String conversationId;
    private InputProvider inputProvider;

    public ComposerPresenter(Listener listener, FrameLayout composerLayout, FragmentManager fragmentManager, LayoutInflater inflater, NexusClient nexusClient, UserIdentity userIdentity, Provider<AppConfig> appConfigProvider, MetricTracker metricTracker, String conversationId, String initialMessage, Context context, @ColorInt int baseColor) {
        this.composerLayout = composerLayout;
        this.metricTracker = metricTracker;
        this.conversationId = conversationId;
        this.inputDrawableManager = new InputDrawableManager(context, appConfigProvider.get().getBaseColor());
        Fragment fragment = fragmentManager.findFragmentByTag(ComposerFragment.class.getName());
        if (fragment instanceof ComposerFragment) {
            this.composerFragment = (ComposerFragment)fragment;
        } else {
            this.composerFragment = ComposerFragment.newInstance(null, (boolean)false, (int)baseColor);
            fragmentManager.beginTransaction().replace(R.id.composer_container, (Fragment)this.composerFragment, ComposerFragment.class.getName()).commit();
        }
        this.composerFragment.setComposerHost(new ComposerHost(){

            @NonNull
            public List<Input> getInputs() {
                return ComposerPresenter.this.inputProvider.getInputs();
            }
        });
        this.composerFragment.setOnInputSelectedListener((OnInputSelectedListener)this);
        this.textInputManager = new TextInputManager(context, inflater, userIdentity, nexusClient, metricTracker, conversationId, initialMessage, this.inputDrawableManager, listener);
        this.galleryInputManager = new GalleryInputManager(context, this.inputDrawableManager, listener, metricTracker, conversationId);
        boolean canAccessFiles = true;
        if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT < 23) {
            canAccessFiles = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0;
        }
        this.setUpInputs(fragmentManager, canAccessFiles);
    }

    private void setUpInputs(FragmentManager fragmentManager, boolean canAccessFiles) {
        Fragment fragment;
        ArrayList<Input> inputs = new ArrayList<Input>();
        inputs.add(this.textInputManager.createInput());
        inputs.add(this.galleryInputManager.createGifInput());
        if (canAccessFiles) {
            inputs.add(this.galleryInputManager.createGalleryInput());
        }
        if ((fragment = fragmentManager.findFragmentByTag(InputProvider.class.getName())) == null) {
            this.inputProvider = new InputProvider();
            this.addInputsToProvider(inputs);
            fragmentManager.beginTransaction().add((Fragment)this.inputProvider, InputProvider.class.getName()).commit();
        } else {
            this.inputProvider = (InputProvider)fragment;
            if (this.inputProvider.getInputs().isEmpty()) {
                this.addInputsToProvider(inputs);
            }
        }
    }

    private void addInputsToProvider(List inputs) {
        this.inputProvider.addInputs(inputs);
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
        this.textInputManager.setConversationId(conversationId);
        this.galleryInputManager.setConversationId(conversationId);
    }

    public void setHint(@StringRes int hintRes) {
        this.textInputManager.setHint(hintRes);
    }

    public void requestFocus() {
        this.textInputManager.requestFocus();
    }

    public void showComposer() {
        this.composerLayout.setVisibility(0);
    }

    public void hideComposer() {
        this.composerLayout.setVisibility(8);
    }

    public void updateMaxLines() {
        this.textInputManager.updateMaxLines();
    }

    public void cleanup() {
        this.textInputManager.cleanup();
    }

    public void onBackPressed() {
        this.composerFragment.onBackPressed();
    }

    public boolean isOpen() {
        return this.composerFragment.isOpen();
    }

    public void returnToDefaultInput() {
        this.handler.postDelayed(this.defaultInputRunnable, 100L);
    }

    public void onInputSelected(Input input) {
        this.metricTracker.clickedInput(this.conversationId, input.getUniqueIdentifier());
    }

    public static interface Listener {
        public void onSendButtonPressed(CharSequence var1);

        public void onUploadImageSelected(GalleryImage var1);

        public void onRemoteImageSelected(GalleryImage var1);
    }
}

